@setlocal EnableDelayedExpansion
@ECHO OFF

IF (%4)==() GOTO Usage

SET PFX_FILE=%1
SET PEM_FILE=%2
SET PASS_IN=%3
SET PASS_OUT=%4

IF NOT EXIST %PFX_FILE% GOTO PFX_Error

IF EXIST %PEM_FILE% del %PEM_FILE%

openssl pkcs12 -in %PFX_FILE% -out %PEM_FILE%.orig -nocerts -passin pass:%PASS_IN% -passout pass:%PASS_OUT%

IF NOT EXIST %PEM_FILE%.orig GOTO PEM_Error

REM **********************************************
REM remove the first 3 line until the -----BEGIN
REM **********************************************

SET /A counter=0
FOR /F "tokens=*" %%i in (%PEM_FILE%.orig) do (
    SET /A counter=!counter!+1
    IF !counter! GTR 3 (ECHO %%i >> %PEM_FILE%)
)

del %PEM_FILE%.orig

EXIT /B %ERRORLEVEL%

:Usage
ECHO CreatePem.bat - convert pfx file to pem file
ECHO Usage: 
ECHO     CreatePem [pfx-file] [pem-file] [in-pass] [out-pass]
ECHO Where:
ECHO     pfx-file  = pfx input file
ECHO     pem-file  = pem output file
ECHO     in-pass   = pfx password
ECHO     out-pass  = pem password

ENDLOCAL
EXIT /B 1

:PFX_Error
ECHO file name %PFX_FILE% is not exists

ENDLOCAL
EXIT /B 1

:PEM_Error
ECHO Error creating PEM file, check that openssl installed

ENDLOCAL
EXIT /B 1
