using System;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class NotEmptyValidation : IValidation
	{
		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			if (value == null || (value is String && String.IsNullOrEmpty((string)value)))
			{
				result.Success = false;
				result.Reasons.Add("This field can't be empty.");
			}

			return result;
		}
	}
}