using System.Collections.Generic;
using System.Text;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class SpiceMenu
	{
		private IList<SpiceMenuItem> items;
		public IList<SpiceMenuItem> Items
		{
			get
			{
				if (items == null)
				{
					items = new List<SpiceMenuItem>();
				}

				return items;
			}
		}

		public IList<SpiceMenuItem> Descendants()
		{
			List<SpiceMenuItem> list = new List<SpiceMenuItem>();
			foreach (SpiceMenuItem item in items)
			{
				DescendantsInternal(list, item);
			}

			return list;
		}

		private void DescendantsInternal(IList<SpiceMenuItem> list, SpiceMenuItem root)
		{
			list.Add(root);
			if (root is SpiceMenuContainerItem)
			{
				foreach (SpiceMenuItem item in ((SpiceMenuContainerItem)root).Items)
				{
					DescendantsInternal(list, item);
				}
			}
		}

		public override string ToString()
		{
			StringBuilder builder = new StringBuilder();
			foreach (SpiceMenuItem item in Items)
			{
				builder.Append(ItemToString(item, null));
			}

			return builder.ToString();
		}

		private string ItemToString(SpiceMenuItem item, SpiceMenuItem parent)
		{
			StringBuilder builder = new StringBuilder();
			int parentID = parent != null ? parent.Id : 0;

			if (item is SpiceMenuCommandItem)
			{
				SpiceMenuCommandItem commandItem = (SpiceMenuCommandItem)item;
				builder.AppendFormat("{0}\r{1}\r{2}\r{3}\n", parentID, commandItem.Id, commandItem.Text, (commandItem.IsEnabled) ? 0 : 2);
			}

			if (item is SpiceMenuContainerItem)
			{
				SpiceMenuContainerItem containerItem = (SpiceMenuContainerItem)item;
				builder.AppendFormat("{0}\r{1}\r{2}\r4\n", parentID, containerItem.Id, containerItem.Text);

				if (containerItem.Items.Count > 0)
				{
					foreach (SpiceMenuItem localItem in containerItem.Items)
					{
						builder.Append(ItemToString(localItem, containerItem));
					}
				}
			}

			if (item is SpiceMenuSeparatorItem)
			{
				builder.AppendFormat("{0}\r{1}\r{2}\r1\n", parentID, item.Id, "-");
			}


			return builder.ToString();
		}
	}
}
