using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.common;
using org.ovirt.engine.ui.uicommon.validation;
 

using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.configure
{
	public class RoleModel : Model
	{
		#region Commands

		public UICommand ExpandAllCommand { get; private set; }
		public UICommand CollapseAllCommand { get; private set; }

		#endregion Commands

		#region Properties

		public bool IsNew { get; set; }

		public EntityModel Name { get; private set; }
		public EntityModel Description { get; private set; }

		private List<SelectionTreeNodeModel> permissionGroupModels;
		public List<SelectionTreeNodeModel> PermissionGroupModels
		{
			get { return permissionGroupModels; }
			set
			{
				if (permissionGroupModels != value)
				{
					permissionGroupModels = value;
					OnPropertyChanged(new PropertyChangedEventArgs("PermissionGroupModels"));
				}
			}
		}

		private bool canChangePermissions;
		public bool CanChangePermissions
		{
			get { return canChangePermissions; }
			set
			{
				if (canChangePermissions != value)
				{
					canChangePermissions = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CanChangePermissions"));
				}
			}
		}

		#endregion

		public RoleModel()
		{
			ExpandAllCommand = new UICommand("ExpandAll", this);
			CollapseAllCommand = new UICommand("CollapseAll", this);

			Name = new EntityModel();
			Description = new EntityModel();
		}

		public void ExpandAll()
		{
			//PermissionGroupModels.Each(a => a.IsExpanded = true );
			foreach (SelectionTreeNodeModel stm in PermissionGroupModels)
				stm.IsExpanded = true;
		}

		public void CollapseAll()
		{
			//PermissionGroupModels.Each(a => a.IsExpanded = false);
			foreach (SelectionTreeNodeModel stm in PermissionGroupModels)
				stm.IsExpanded = false;
		}

		internal bool Validate()
		{
			Name.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(),
					new RegexValidation 
					{
						Expression = @"^\w.{0,125}$",
						Message = "Name must be up to 126 characters and start with any word character."
					}
				});

			return Name.GetIsValid();
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == ExpandAllCommand)
			{
				ExpandAll();
			}
			else if (command == CollapseAllCommand)
			{
				CollapseAll();
			}
		}
	}


	//public class PermissionModel : Model
	//{
	//    #region Properties

	//    private string name;
	//    public string Name
	//    {
	//        get { return name; }
	//        set
	//        {
	//            if (name != value)
	//            {
	//                name = value;
	//                OnPropertyChanged(new PropertyChangedEventArgs("Name"));
	//            }
	//        }
	//    }

	//    private string description;
	//    public string Description
	//    {
	//        get { return description; }
	//        set
	//        {
	//            if (description != value)
	//            {
	//                description = value;
	//                OnPropertyChanged(new PropertyChangedEventArgs("Description"));
	//            }
	//        }
	//    }

	//    private bool isPermitted;
	//    public bool IsPermitted
	//    {
	//        get { return isPermitted; }
	//        set
	//        {
	//            if (isPermitted != value)
	//            {
	//                isPermitted = value;
	//                IsPermittedChanged();
	//                OnPropertyChanged(new PropertyChangedEventArgs("IsPermitted"));
	//            }
	//        }
	//    }

	//    private VdcActionType actionType;
	//    public VdcActionType ActionType
	//    {
	//        get { return actionType; }
	//        set
	//        {
	//            if (actionType != value)
	//            {
	//                actionType = value;
	//                OnPropertyChanged(new PropertyChangedEventArgs("ActionType"));
	//            }
	//        }
	//    }

	//    private IEnumerable<PermissionModel> children;
	//    public IEnumerable<PermissionModel> Children
	//    {
	//        get { return children; }
	//        set
	//        {
	//            if (children != value)
	//            {
	//                children = value;
	//                OnPropertyChanged(new PropertyChangedEventArgs("Children"));
	//            }
	//        }
	//    }

	//    private bool canChangePermissions;
	//    public bool CanChangePermissions
	//    {
	//        get { return canChangePermissions; }
	//        set
	//        {
	//            if (canChangePermissions != value)
	//            {
	//                canChangePermissions = value;
	//                OnPropertyChanged(new PropertyChangedEventArgs("CanChangePermissions"));
	//            }
	//        }
	//    }

	//    #endregion


	//    public PermissionModel()
	//    {
	//        Children = new List<PermissionModel>();
	//    }

	//    private void IsPermittedChanged()
	//    {
	//        foreach (var child in Children)
	//        {
	//            child.IsPermitted = IsPermitted;
	//        }
	//    }
	//}
}
