USE [rhevm]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET NOCOUNT ON
GO

-- vdc_options change
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vdc_options' and COLUMN_NAME = 'version'))
begin
ALTER TABLE dbo.vdc_options ADD version nvarchar(40) NOT NULL CONSTRAINT DF_vdc_options_version DEFAULT 'general'
ALTER TABLE dbo.vdc_options DROP CONSTRAINT PK_vdc_options
ALTER TABLE dbo.vdc_options ADD CONSTRAINT
	PK_vdc_options PRIMARY KEY CLUSTERED 
	(
	option_id
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE NONCLUSTERED INDEX IX_vdc_options ON dbo.vdc_options
	(
	option_name
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
end
GO


