PRINT 'Processing multileveladministration_sp.sql'

----------------------------------------------------------------
-- [dbo].[permissions] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertPermission')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertPermission] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertPermission]
    @ad_element_id uniqueidentifier,
	@id uniqueidentifier,
	@role_id uniqueidentifier,
	@object_id uniqueidentifier,
	@object_type_id int
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRY
    INSERT INTO [dbo].[permissions] ([ad_element_id], [id], [role_id], [object_id], [object_type_id])
	VALUES (@ad_element_id, @id, @role_id, @object_id, @object_type_id)

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeletePermission')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeletePermission] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeletePermission]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children
	SELECT @val = [id]
	FROM [dbo].[permissions] WITH (UPDLOCK)
	WHERE [id] = @id

    DELETE FROM [dbo].[permissions]
	WHERE [id]=@id

    SET NOCOUNT OFF
END


GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByid]
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByAdElementId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByAdElementId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByAdElementId]
	@ad_element_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [permissions_view].[ad_element_id] in (select id from getUserAndGroupsById(@ad_element_id))

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByRoleId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByRoleId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByRoleId]
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [role_id]=@role_id

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByRoleIdAndAdElementId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByRoleIdAndAdElementId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByRoleIdAndAdElementId]
	@role_id uniqueidentifier,
	@ad_element_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [role_id]=@role_id and [ad_element_id]= @ad_element_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByRoleIdAndAdElementIdAndObjectId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByRoleIdAndAdElementIdAndObjectId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByRoleIdAndAdElementIdAndObjectId]
	@role_id uniqueidentifier,
	@ad_element_id uniqueidentifier,
	@object_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [role_id]=@role_id and [ad_element_id]= @ad_element_id and [object_id]=@object_id

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetForRoleAndAdElementAndObject_wGroupCheck')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetForRoleAndAdElementAndObject_wGroupCheck] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetForRoleAndAdElementAndObject_wGroupCheck]
	@role_id uniqueidentifier,
	@ad_element_id uniqueidentifier,
	@object_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [role_id]=@role_id and [object_id]=@object_id and ad_element_id in (select id from getUserAndGroupsById(@ad_element_id))

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[roles] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertRole')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertRole] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertRole]
    @description nvarchar(MAX) = NULL,
	@id uniqueidentifier,
	@name nvarchar(126),
	@is_readonly bit,
	@role_type int
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRY
    INSERT INTO [dbo].[roles] ([description], [id], [name], [is_readonly], [role_type])
	VALUES (@description, @id, @name, @is_readonly, @role_type)

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateRole')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateRole] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateRole]
    @description nvarchar(MAX) = NULL,
	@id uniqueidentifier,
	@name nvarchar(126),
	@is_readonly bit,
	@role_type int
AS
BEGIN

	--The [dbo].[roles] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[roles]
	SET [description] = @description, [name] = @name, [is_readonly] = @is_readonly, [role_type] = @role_type
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteRole')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteRole] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteRole]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
    -- in order to force locking parent before children
	SELECT @val = [id]
	FROM [dbo].[roles] WITH (UPDLOCK)
	WHERE [id] = @id

    DELETE FROM [dbo].[roles]
	WHERE [id]=@id

    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromRole')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromRole] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromRole]
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles].[description] AS 'description',
	[roles].[id] AS 'id',
	[roles].[name] AS 'name',
	[roles].[is_readonly] AS 'is_readonly',
	[roles].[role_type] AS 'role_type'
FROM [dbo].[roles] [roles]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRolsByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetRolsByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetRolsByid]
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles].[description] AS 'description',
	[roles].[id] AS 'id',
	[roles].[name] AS 'name',
	[roles].[is_readonly] AS 'is_readonly',
	[roles].[role_type] AS 'role_type'
	FROM [dbo].[roles] [roles]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRoleByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetRoleByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetRoleByName]
	@name nvarchar(126)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles].[description] AS 'description',
	[roles].[id] AS 'id',
	[roles].[name] AS 'name',
	[roles].[is_readonly] AS 'is_readonly',
	[roles].[role_type] AS 'role_type'
	FROM [dbo].[roles] [roles]
	WHERE [name]=@name

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllRolesByAdElementId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllRolesByAdElementId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllRolesByAdElementId]
	@ad_element_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles].[description] AS 'description',
	[roles].[id] AS 'id',
	[roles].[name] AS 'name',
	[roles].[is_readonly] AS 'is_readonly',
	[roles].[role_type] AS 'role_type'
	FROM [roles] INNER JOIN
		[permissions] ON [permissions].[role_id] = [roles].[id]
	WHERE [permissions].[ad_element_id] in (select id from getUserAndGroupsById(@ad_element_id))

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRolesByAdElementId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetRolesByAdElementId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetRolesByAdElementId]
	@ad_element_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

select 	[roles].[description] AS 'description',
	[roles].[id] AS 'id',
	[roles].[name] AS 'name',
	[roles].[is_readonly] AS 'is_readonly',
	[roles].[role_type] AS 'role_type'
FROM roles
    inner join [dbo].[permissions] [permissions] on roles.id = [permissions].role_id
WHERE ad_element_id=@ad_element_id
	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[roles_relations] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertroles_relations')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertroles_relations] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertroles_relations]
    @role_container_id uniqueidentifier,
	@role_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRY
    INSERT INTO [dbo].[roles_relations] ([role_container_id], [role_id])
	VALUES (@role_container_id, @role_id)

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updateroles_relations')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updateroles_relations] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updateroles_relations]
    @role_container_id uniqueidentifier,
	@role_id uniqueidentifier
AS
BEGIN

	--The [dbo].[roles_relations] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY


	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteroles_relations')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteroles_relations] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteroles_relations]
	 @role_container_id uniqueidentifier,
	@role_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON

    DELETE FROM [dbo].[roles_relations]
	WHERE [role_container_id]=@role_container_id AND [role_id]=@role_id

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromroles_relations')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromroles_relations] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromroles_relations]
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles_relations].[role_container_id] AS 'role_container_id',
	[roles_relations].[role_id] AS 'role_id'
FROM [dbo].[roles_relations] [roles_relations]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getroles_relationsByrole_container_idAndByrole_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getroles_relationsByrole_container_idAndByrole_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getroles_relationsByrole_container_idAndByrole_id]
	@role_container_id uniqueidentifier,
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles_relations].[role_container_id] AS 'role_container_id',
	[roles_relations].[role_id] AS 'role_id'
	FROM [dbo].[roles_relations] [roles_relations]
	WHERE [role_container_id]=@role_container_id AND [role_id]=@role_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getrole_children')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getrole_children] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getrole_children]
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[roles_relations].[role_container_id] AS 'role_container_id',
	[roles_relations].[role_id] AS 'role_id'
	FROM [dbo].[roles_relations] [roles_relations]
	WHERE [role_container_id]=@role_id

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[user_action_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionByRoleId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].GetPermissionByRoleId AS RETURN')
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionByRoleId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].GetPermissionByRoleId AS RETURN')
END

GO

Alter PROCEDURE [dbo].GetPermissionByRoleId
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
select id, role_id, ad_element_id, object_id, object_type_id from dbo.permissions
where role_id = @role_id
	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'get_entity_permissions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[get_entity_permissions] AS RETURN')
END
go

-- gets entity permissions given the user id, action group id and the object type and id
ALTER PROCEDURE [dbo].[get_entity_permissions]
	-- Add the parameters for the stored procedure here
@user_id uniqueidentifier,@action_group_id int,@object_id uniqueidentifier,@object_type_id int,
@permission_id uniqueidentifier out
AS
BEGIN
	declare @everyone_object_id uniqueidentifier
	set @everyone_object_id = dbo.getGlobalIds('everyone') -- hardcoded also in MLA Handler
	select top 1 @permission_id = id from permissions
	where
		-- get all roles of action
		  role_id in (select role_id from roles_groups where action_group_id = @action_group_id)
		-- get allparents of object
		  and (object_id in (select id from  dbo.fn_get_entity_parents(@object_id,@object_type_id)))
		-- get user and his groups
		  and (ad_element_id = @everyone_object_id or
		  	ad_element_id in (select id from getUserAndGroupsById(@user_id))
		      )

END
GO
----------------------------------------------------------------
-- [dbo].[roles_groups] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insert_roles_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insert_roles_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insert_roles_groups]
    @action_group_id int,
	@role_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRY
    INSERT INTO [dbo].[roles_groups] ([action_group_id], [role_id])
	VALUES (@action_group_id, @role_id)

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Delete_roles_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Delete_roles_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Delete_roles_groups]
	@action_group_id int,
	@role_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON

    DELETE FROM [dbo].[roles_groups]
	WHERE [action_group_id]=@action_group_id AND [role_id]=@role_id

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Get_roles_groups_By_action_group_id_And_By_role_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Get_roles_groups_By_action_group_id_And_By_role_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Get_roles_groups_By_action_group_id_And_By_role_id]
	@action_group_id int,
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
		[roles_groups].[action_group_id] AS 'action_group_id',
		[roles_groups].[role_id] AS 'role_id'
	FROM
		[dbo].[roles_groups]
	where
		[action_group_id] = @action_group_id AND
		[role_id] = @role_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Get_role_groups_By_role_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Get_role_groups_By_role_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Get_role_groups_By_role_id]
	@role_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
		[roles_groups].[action_group_id] AS 'action_group_id',
		[roles_groups].[role_id] AS 'role_id'
	FROM
		[dbo].[roles_groups]
	where
		[role_id] = @role_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByEntityId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByEntityId] AS RETURN')
END

GO

ALTER PROCEDURE GetPermissionsByEntityId
@id uniqueidentifier
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
   	SELECT * FROM [dbo].[permissions_view]
			WHERE [object_id] = @id
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeletePermissionsByEntityId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeletePermissionsByEntityId] AS RETURN')
END

GO

ALTER PROCEDURE DeletePermissionsByEntityId
@id uniqueidentifier
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
   	DELETE FROM [dbo].[permissions]
			WHERE [object_id] = @id
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRoleActionGroupsByRoleId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetRoleActionGroupsByRoleId] AS RETURN')
END

GO

ALTER PROCEDURE GetRoleActionGroupsByRoleId
@id uniqueidentifier
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
   	SELECT * FROM [dbo].[roles_groups]
			WHERE [role_id] = @id
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsTreeByEntityId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsTreeByEntityId] AS RETURN')
END

GO

ALTER PROCEDURE GetPermissionsTreeByEntityId
@id uniqueidentifier,
@object_type_id Int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
   	SELECT * FROM [dbo].[permissions_view]
			WHERE [object_id] in (select id from  dbo.fn_get_entity_parents(@id,@object_type_id))
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetPermissionsByRoleIdAndObjectId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetPermissionsByRoleIdAndObjectId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetPermissionsByRoleIdAndObjectId]
	@role_id uniqueidentifier,
	@object_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
	[permissions_view].[ad_element_id] AS 'ad_element_id',
	[permissions_view].[id] AS 'id',
	[permissions_view].[role_id] AS 'role_id',
	[permissions_view].[object_id] AS 'object_id',
	[permissions_view].[object_type_id] AS 'object_type_id',
	[permissions_view].[role_name] AS 'role_name',
	[permissions_view].[object_name] AS 'object_name',
	[permissions_view].[owner_name] AS 'owner_name',
	[permissions_view].[role_type] AS 'role_type'
	FROM [dbo].[permissions_view] [permissions_view]
	WHERE [role_id]=@role_id and [object_id]= @object_id

	SET NOCOUNT OFF
END

GO
