PRINT 'Processing custom_actions_sp.sql'

----------------------------------------------------------------
-- [dbo].[custom_actions] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertcustom_actions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertcustom_actions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertcustom_actions]
    @action_id int OUT,
	@action_name nvarchar(50),
	@path nvarchar(300),
	@tab int = NULL,
	@description nvarchar(max) = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[custom_actions] ([action_name], [path], [tab], [description])
	VALUES (@action_name, @path, @tab, @description)
    SET @action_id = SCOPE_IDENTITY()
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatecustom_actions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatecustom_actions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatecustom_actions]
    @action_id int,
	@action_name nvarchar(50),
	@path nvarchar(300),
	@tab int = NULL,
	@description nvarchar(max) = NULL
AS
BEGIN

	--The [dbo].[custom_actions] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[custom_actions] 
	SET [action_name] = @action_name, [path] = @path, [tab] = @tab, [description] = @description
	WHERE [action_id]=@action_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletecustom_actions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletecustom_actions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletecustom_actions]
	 @action_id int
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[custom_actions]
		WHERE [action_id]=@action_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromcustom_actions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromcustom_actions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromcustom_actions]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[custom_actions].[action_id] AS 'action_id',
		[custom_actions].[action_name] AS 'action_name',
		[custom_actions].[path] AS 'path',
		[custom_actions].[tab] AS 'tab', 
		[custom_actions].[description] AS 'description'
	FROM [dbo].[custom_actions] [custom_actions]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getcustom_actionsByaction_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getcustom_actionsByaction_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getcustom_actionsByaction_id] 
	@action_id int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[custom_actions].[action_id] AS 'action_id',
		[custom_actions].[action_name] AS 'action_name',
		[custom_actions].[path] AS 'path',
		[custom_actions].[tab] AS 'tab',
		[custom_actions].[description] AS 'description'
		FROM [dbo].[custom_actions] [custom_actions]
		WHERE [action_id]=@action_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getcustom_actionsByTab_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getcustom_actionsByTab_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getcustom_actionsByTab_id] 
	@tab int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[custom_actions].[action_id] AS 'action_id',
		[custom_actions].[action_name] AS 'action_name',
		[custom_actions].[path] AS 'path',
		[custom_actions].[tab] AS 'tab',
		[custom_actions].[description] AS 'description'
		FROM [dbo].[custom_actions] [custom_actions]
		WHERE [tab]=@tab
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getcustom_actionsByNameAndTab')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getcustom_actionsByNameAndTab] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getcustom_actionsByNameAndTab] 
	@action_name nvarchar(50), 
	@tab int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[custom_actions].[action_id] AS 'action_id',
		[custom_actions].[action_name] AS 'action_name',
		[custom_actions].[path] AS 'path',
		[custom_actions].[tab] AS 'tab',
		[custom_actions].[description] AS 'description'
		FROM [dbo].[custom_actions] [custom_actions]
		WHERE [tab]=@tab and [action_name] = @action_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO