using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Input;
using System.Windows.Interactivity;
using Microsoft.Practices.Unity;
using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;

using org.ovirt.engine.ui.uicommon;
using System.Reflection;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	[TemplatePart(Type = typeof(FrameworkElement), Name = "PART_DragHandle")]
	public class WindowView : ViewBase
	{
		#region Properties

		public FrameworkElement DragHandle { get; private set; }


		public DataTemplate HeaderTemplate
		{
			get { return (DataTemplate)GetValue(HeaderTemplateProperty); }
			set { SetValue(HeaderTemplateProperty, value); }
		}

		public static readonly DependencyProperty HeaderTemplateProperty =
			DependencyProperty.Register("HeaderTemplate", typeof(DataTemplate), typeof(WindowView), new UIPropertyMetadata(null));

		#endregion

		protected override void OnKeyDown(KeyEventArgs e)
		{
			base.OnKeyDown(e);

			UICommand command;

			switch (e.Key)
			{
				case Key.Escape:
					command = Model.Commands != null ? Model.Commands.FirstOrDefault(a => a.IsCancel) : null;
					if (command != null && Model.Progress == null)
					{
						command.Execute();
					}
					break;

				case Key.Enter:
					command = Model.Commands != null ? Model.Commands.FirstOrDefault(a => a.IsDefault) : null;
					if (command != null)
					{
						command.Execute();
					}
					break;
			}
		}

		public override void OnApplyTemplate()
		{
			base.OnApplyTemplate();
			DragHandle = GetTemplateChild("PART_DragHandle") as FrameworkElement;

			//Make window draggable.
			var behaviors = Interaction.GetBehaviors(this);
			if (behaviors != null && !behaviors.Any(a => a is DraggableBehavior))
			{
				var behavior =
					new DraggableBehavior
					{
						DragHandle = DragHandle
					};
				behavior.Attach(this);
			}
		}
	}
}
