﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace UI.WPFClient
{
	/// <summary>
	/// A regular tab control with additional properties that may be used for more granular styling.
	/// </summary>
	public class TabControl : System.Windows.Controls.TabControl
	{
		#region Properties

		public CornerRadius CornerRadius
		{
			get { return (CornerRadius)GetValue(CornerRadiusProperty); }
			set { SetValue(CornerRadiusProperty, value); }
		}
		public static readonly DependencyProperty CornerRadiusProperty =
			DependencyProperty.Register("CornerRadius", typeof(CornerRadius), typeof(TabControl));


		public Thickness HeaderMargin
		{
			get { return (Thickness)GetValue(HeaderMarginProperty); }
			set { SetValue(HeaderMarginProperty, value); }
		}
		public static readonly DependencyProperty HeaderMarginProperty =
			DependencyProperty.Register("HeaderMargin", typeof(Thickness), typeof(TabControl));


		public Brush HeaderBackground
		{
			get { return (Brush)GetValue(HeaderBackgroundProperty); }
			set { SetValue(HeaderBackgroundProperty, value); }
		}
		public static readonly DependencyProperty HeaderBackgroundProperty =
			DependencyProperty.Register("HeaderBackground", typeof(Brush), typeof(TabControl));

		#endregion
	}
}
