using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;

using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class LocalStorageModel : Model, IStorageModel
	{
		#region Commands

		public UICommand UpdateCommand { get; private set; }

		#endregion

		#region Properties

		public StorageModel Container { get; set; }
		public StorageDomainType Role { get; set; }

		public EntityModel Path { get; set; }

		#endregion

		public LocalStorageModel()
		{
			UpdateCommand = new UICommand("Update", this);

			Path = new EntityModel();
		}

		public bool Validate()
		{
			Path.ValidateEntity(new[] { new NotEmptyValidation() });

			return Path.IsValid;
		}

		public StorageType Type
		{
			get { return StorageType.LOCALFS; }
		}
	}
}
