﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class HostInterfaceLineModel : Model
	{
		#region Properties

		public VdsNetworkInterface Interface { get; set; }


		private bool isBonded;
		public bool IsBonded
		{
			get { return isBonded; }
			set
			{
				if (isBonded != value)
				{
					isBonded = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsBonded"));
				}
			}
		}

		private string bondName;
		public string BondName
		{
			get { return bondName; }
			set
			{
				if (bondName != value)
				{
					bondName = value;
					OnPropertyChanged(new PropertyChangedEventArgs("BondName"));
				}
			}
		}

		private string address;
		public string Address
		{
			get { return address; }
			set
			{
				if (address != value)
				{
					address = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Address"));
				}
			}
		}

		private List<HostInterface> interfaces;
		public List<HostInterface> Interfaces
		{
			get { return interfaces; }
			set
			{
				if (interfaces != value)
				{
					interfaces = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Interfaces"));
				}
			}
		}

		private List<HostVLan> vLans;
		public List<HostVLan> VLans
		{
			get { return vLans; }
			set
			{
				if (vLans != value)
				{
					vLans = value;
					OnPropertyChanged(new PropertyChangedEventArgs("VLans"));
				}
			}
		}

		private string networkName;
		public string NetworkName
		{
			get { return networkName; }
			set
			{
				if (networkName != value)
				{
					networkName = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NetworkName"));
				}
			}
		}

		private bool isManagement;
		public bool IsManagement
		{
			get { return isManagement; }
			set
			{
				if (isManagement != value)
				{
					isManagement = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsManagement"));
				}
			}
		}

		#endregion
	}


	public class HostInterface : Model
	{
		#region Properties

		public VdsNetworkInterface Interface { get; set; }


		private InterfaceStatus status;
		public InterfaceStatus Status
		{
			get { return status; }
			set
			{
				if (status != value)
				{
					status = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Status"));
				}
			}
		}

		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private string address;
		public string Address
		{
			get { return address; }
			set
			{
				if (address != value)
				{
					address = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Address"));
				}
			}
		}

		private string mac;
		public string MAC
		{
			get { return mac; }
			set
			{
				if (mac != value)
				{
					mac = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MAC"));
				}
			}
		}

		private int? speed;
		public int? Speed
		{
			get { return speed; }
			set
			{
				if (speed == null && value == null)
					return;
				if (speed == null || speed != value)
				{
					speed = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Speed"));
				}
			}
		}

		private double? rxRate;
		public double? RxRate
		{
			get { return rxRate; }
			set
			{
				if (rxRate == null && value == null)
					return;
				if (rxRate == null || rxRate != value)
				{
					rxRate = value;
					OnPropertyChanged(new PropertyChangedEventArgs("RxRate"));
				}
			}
		}

		private double? rxDrop;
		public double? RxDrop
		{
			get { return rxDrop; }
			set
			{
				if (rxDrop == null && value == null)
					return;
				if (rxDrop == null || rxDrop != value)
				{
					rxDrop = value;
					OnPropertyChanged(new PropertyChangedEventArgs("RxDrop"));
				}
			}
		}

		private double? txRate;
		public double? TxRate
		{
			get { return txRate; }
			set
			{
				if (txRate == null && value == null)
					return;
				if (txRate == null || txRate != value)
				{
					txRate = value;
					OnPropertyChanged(new PropertyChangedEventArgs("TxRate"));
				}
			}
		}

		private double? txDrop;
		public double? TxDrop
		{
			get { return txDrop; }
			set
			{
				if (txDrop == null && value == null)
					return;
				if (txDrop == null || txDrop != value)
				{
					txDrop = value;
					OnPropertyChanged(new PropertyChangedEventArgs("TxDrop"));
				}
			}
		}

		#endregion
	}



	public class HostVLan : Model
	{
		#region Properties

		public VdsNetworkInterface Interface { get; set; }


		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private string networkName;
		public string NetworkName
		{
			get { return networkName; }
			set
			{
				if (networkName != value)
				{
					networkName = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NetworkName"));
				}
			}
		}

		private string address;
		public string Address
		{
			get { return address; }
			set
			{
				if (address != value)
				{
					address = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Address"));
				}
			}
		}

		#endregion
	}
}
