﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.common;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.datacenters
{
	public class DataCenterNetworkModel : NetworkModel
	{
		public network currentNetwork { get; set; }
		public List<VDSGroup> newClusters { get; set; }

		public UICommand DetachAllCommand { get; set; }
		public EntityModel DetachAllAvailable { get; set; }

		public List<VDSGroup> Clusters
		{
			get { return null; }
			set
			{
				SelectionTreeNodeModel nodeModel;
				foreach (VDSGroup selectionTreeNodeModel in value)
				{
					nodeModel = new SelectionTreeNodeModel();
					nodeModel.Entity = selectionTreeNodeModel;
					nodeModel.Description = selectionTreeNodeModel.name;
					nodeModel.IsSelectedNullable = false;
					ClusterTreeNodes.Add(nodeModel);
				}
			}
		}
		public List<SelectionTreeNodeModel> clusterTreeNodes { get; set; }
		public List<SelectionTreeNodeModel> ClusterTreeNodes
		{
			get { return clusterTreeNodes; }
			set 
			{ 
				clusterTreeNodes = value;
				OnPropertyChanged(new PropertyChangedEventArgs("ClusterTreeNodes"));
			}
		}
		public List<VDSGroup> OriginalClusters { get; set; }

        public EntityModel IsEnabled { get; set; }

		public DataCenterNetworkModel() : base()
		{
			ClusterTreeNodes = new List<SelectionTreeNodeModel>();
			OriginalClusters = new List<VDSGroup>();
			IsEnabled = new EntityModel();
			IsEnabled.Entity = true;
			DetachAllAvailable = new EntityModel();
			DetachAllAvailable.Entity = false;
		}
	}
}
