﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using VdcCommon.BusinessEntities;
using System.Text.RegularExpressions;
using VdcUtils;

namespace VdcCommon.Ovf
{
    public class OvfParser
    {
        protected XmlDocument _document;
        protected XmlNamespaceManager _xmlNS;

        // DateTimeRegex parse date string in this format: yyyy/M/dd hh:mm:ss
        public static string DateTimeRegex = @"^(?<year>\d{4})[^\d](?<month>\d{1,2})[^\d](?<day>\d{1,2})\s+(?<hour>\d{1,2})[^\d](?<minute>\d{1,2})[^\d](?<second>\d{1,2})$";

        public OvfParser(string ovfstring)
        {
            _document = new XmlDocument();
            _document.LoadXml(ovfstring);

            _xmlNS = new XmlNamespaceManager(_document.NameTable);
        }

        public bool IsTemplate()
        {
            string id1 = "1";
            string id2 = "2";

            XmlNode node = _document.SelectSingleNode("//*/Content/TemplateId");
            if (!string.IsNullOrEmpty(node.InnerText))
            {
                id1 = node.InnerText;
            }

            XmlNodeList list = _document.SelectNodes("//*/Content/Section");
            foreach (XmlNode section in list)
            {
                string value = section.Attributes["xsi:type"].Value;

                switch (value)
                {
                    case "ovf:OperatingSystemSection_Type":
                        id2 = section.Attributes["ovf:id"].Value;
                        break;
                }
            }

            return id1 == id2;
        }

        // imageFile is: [image group id]/[image id]
        //               7D1FE0AA-A153-4AAF-95B3-3654A54443BE/7D1FE0AA-A153-4AAF-95B3-3654A54443BE
        public static string CreateImageFile(DiskImage image)
        {
            string retVal = string.Empty;
            if (image.image_group_id.HasValue)
            {
                retVal += image.image_group_id.Value.ToString();
            }
            else
            {
                retVal += Guid.Empty;
            }
            retVal += "/" + image.image_guid.ToString();
            return retVal;
        }

        public static Guid? GetImageGrupIdFromImageFile(string imageFile)
        {
            if (!String.IsNullOrEmpty(imageFile))
            {
                return new Guid(imageFile.Split('/')[0]);
            }
            return null;
        }

        public static Guid? GetImageIdFromImageFile(string imageFile)
        {
            if (!String.IsNullOrEmpty(imageFile))
            {
                string[] all = imageFile.Split('/');
                if (all.Length > 1)
                {
                    return new Guid(imageFile.Split('/')[1]);
                }
            }
            return null;
        }

        public static string LocalDateToUtcDateString(DateTime date)
        {
            string retVal = date.ToUniversalTime().ToString("yyyy/M/dd hh:mm:ss");
            return retVal;
        }

        /// <summary>
        /// Method return false if the format is not yyyy/mm/dd hh:mm:ss
        /// </summary>
        /// <param name="str"></param>
        /// <param name="date"></param>
        /// <returns></returns>
        public static bool UtcDateStringToLocaDate(string str, out DateTime date)
        {
            date = DateTime.MinValue;
            if (String.IsNullOrEmpty(str))
            {
                return false;
            }

            string exception = "OVF DateTime format Error, Expected: yyyy/M/dd hh:mm:ss";
            Match match = Regex.Match(str, DateTimeRegex);
            if (!match.Success)
            {
                QLogger.Instance.Error(exception);
                return false;
            }

            try
            {
                date = new DateTime(Int32.Parse(match.Groups["year"].Value),
                    Int32.Parse(match.Groups["month"].Value),
                    Int32.Parse(match.Groups["day"].Value),
                    Int32.Parse(match.Groups["hour"].Value),
                    Int32.Parse(match.Groups["minute"].Value),
                    Int32.Parse(match.Groups["second"].Value));

                date = date.ToLocalTime();

                return true;
            }
            catch
            {
                QLogger.Instance.Error(exception);
                return false;
            }
        }

    }
}
