package org.ovirt.engine.core.vdsbroker.vdsbroker;

import java.util.Map;

import org.ovirt.engine.core.vdsbroker.irsbroker.*;
import org.ovirt.engine.core.vdsbroker.xmlrpc.XmlRpcObjectDescriptor;
import org.ovirt.engine.core.vdsbroker.xmlrpc.XmlRpcStruct;

public final class VGListReturnForXmlRpc extends StatusReturnForXmlRpc {
    private static final String VG_LIST = "vglist";
    // We are ignoring missing fields after the status, because on failure it is
    // not sent.
    // [XmlRpcMissingMapping(MappingAction.Ignore), XmlRpcMember("vglist")]
    public XmlRpcStruct[] vgList;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(super.toString());
        builder.append("\n");
        XmlRpcObjectDescriptor.ToStringBuilder(vgList, builder);
        return builder.toString();
    }

    @SuppressWarnings("unchecked")
    public VGListReturnForXmlRpc(Map<String, Object> innerMap) {
        super(innerMap);
        Object[] temp = (Object[]) innerMap.get(VG_LIST);
        if (temp != null) {
            vgList = new XmlRpcStruct[temp.length];
            for (int i = 0; i < temp.length; i++) {
                vgList[i] = new XmlRpcStruct((Map<String, Object>) temp[i]);
            }
        }
    }

}
