#!/bin/bash

# refreshStoredProcedures.sh
echo $1
if [[ $1 = "-h" || $1 = "--help" ]]
then
    echo Usage : refreshStoredProcedures [server] [dbname] [user] [password] [xmlconfigfile]
    echo     "server    - the sql server to access (default = .\sqlexpress)"
    echo     "dbname    - the database name to access/create (default = rhevm)"
    echo     "user      - the datbase user name (default = sa)"
    echo     "password	- the datbase user password (default = RHEVMadmin2009!)"
    echo     "xmlconfigfile - fully qualified name of the FieldsInVdcConfig.xml file"
    exit
fi


sqlServer=$1
if [[ ! -n $1 ]]
then
    sqlServer=.\sqlexpress
fi

dbname=$2
if [[ ! -n $2 ]]
then
     dbname=rhevm
fi

user=$3
if [[ ! -n $3 ]]
then
    user=sa
fi

password=$4
if [[ ! -n $4 ]]
then
     password=RHEVMadmin2009!
fi

xmlconfigfile=$5
if [[ ! -n $5 ]]
then
     xmlconfigfile=../../../../FieldsInVDCConfig.xml
fi

echo server - $sqlServer
echo dbname - $dbname
echo user - $user
echo password - $password
echo xmlconfigfile - $xmlconfigfile

#escape xml special characters
# commented for no , TODO
#escapedxml=$(python -c "from xml.sax import saxutils;from xml.dom import minidom;print saxutils.escape(minidom.parse('$xmlconfigfile').toxml(),{'\n':'\n','\r\n':'\r\n'})");

../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -i../sync_sp.sql
if [[ $? != 0 ]]
then
    exit 1
fi
../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -Q"execute Sync_update_config_values_linux '$(cat $xmlconfigfile)'"
if [[ $? != 0 ]]
then
    exit 2
fi
../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -Q"execute attach_user_to_su_role"
if [[ $? != 0 ]]
then
    exit 3
fi
echo Done.
