PRINT 'Processing bookmarksAndVMPools_sp.sql'

----------------------------------------------------------------
-- [dbo].[bookmarks] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertBookmark')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertBookmark] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertBookmark]
    @bookmark_name nvarchar(40),
	@bookmark_value nvarchar(300)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[bookmarks] ([bookmark_id],[bookmark_name], [bookmark_value])
	VALUES (newid(),@bookmark_name, @bookmark_value)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateBookmark')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateBookmark] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateBookmark]
	@bookmark_id uniqueidentifier,
    @bookmark_name nvarchar(40),
	@bookmark_value nvarchar(300)
	
AS
BEGIN

	--The [dbo].[bookmarks] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[bookmarks] 
	SET [bookmark_name]=@bookmark_name,
	[bookmark_value]=@bookmark_value
	WHERE [bookmark_Id]=@bookmark_Id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteBookmark')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteBookmark] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteBookmark]
  @bookmark_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[bookmarks]
		WHERE [bookmark_id]=@bookmark_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromBookmarks')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromBookmarks] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromBookmarks]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[bookmarks].[bookmark_id] AS 'bookmark_id',
		[bookmarks].[bookmark_name] AS 'bookmark_name',
		[bookmarks].[bookmark_value] AS 'bookmark_value'
		FROM [dbo].[bookmarks] [bookmarks]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetBookmarkBybookmark_name')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetBookmarkBybookmark_name] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetBookmarkBybookmark_name] 
	@bookmark_name nvarchar(40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[bookmarks].[bookmark_id] AS 'bookmark_id',
		[bookmarks].[bookmark_name] AS 'bookmark_name',
		[bookmarks].[bookmark_value] AS 'bookmark_value'
		FROM [dbo].[bookmarks] [bookmarks]
		WHERE [bookmark_name]=@bookmark_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetBookmarkBybookmark_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetBookmarkBybookmark_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetBookmarkBybookmark_id] 
 @bookmark_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[bookmarks].[bookmark_id] AS 'bookmark_id',
		[bookmarks].[bookmark_name] AS 'bookmark_name',
		[bookmarks].[bookmark_value] AS 'bookmark_value'
		FROM [dbo].[bookmarks] [bookmarks]
		WHERE [bookmark_id]=@bookmark_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


----------------------------------------------------------------
-- [dbo].[vm_pools] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVm_pools')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVm_pools] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVm_pools]
    @vm_pool_description nvarchar(max),  
 @vm_pool_id uniqueidentifier OUT,  
 @vm_pool_name nvarchar(255),  
 @vm_pool_type int,  
 @parameters nvarchar(200),  
 @vds_group_id uniqueidentifier  

AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
	SET @vm_pool_id = newid()
	    INSERT INTO [dbo].[vm_pools] ([vm_pool_id],[vm_pool_description], [vm_pool_name],
								  [vm_pool_type],[parameters],[vds_group_id])
				
	VALUES (@vm_pool_id,@vm_pool_description, @vm_pool_name,@vm_pool_type,@parameters,@vds_group_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVm_pools')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVm_pools] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVm_pools]
    @vm_pool_description nvarchar(max),  
 @vm_pool_id uniqueidentifier,  
 @vm_pool_name nvarchar(255),  
 @vm_pool_type int,  
 @parameters nvarchar(200),  
 @vds_group_id uniqueidentifier  

AS
BEGIN

	--The [dbo].[vm_pools] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_pools] 
	SET [vm_pool_description] = @vm_pool_description, 
		[vm_pool_name] = @vm_pool_name,
		[vm_pool_type] = @vm_pool_type,
		[parameters] = @parameters,
		[vds_group_id] = @vds_group_id
	WHERE [vm_pool_id]=@vm_pool_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVm_pools')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVm_pools] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVm_pools]
  @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @val uniqueidentifier
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [vm_pool_id]
		FROM [dbo].[vm_pools] WITH (UPDLOCK)
		WHERE [vm_pool_id]=@vm_pool_id

		DELETE FROM [dbo].[vm_pools]
		WHERE [vm_pool_id]=@vm_pool_id

		-- delete VmPool permissions --
		DELETE FROM [dbo].[permissions] where object_id = @vm_pool_id

	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVm_pools')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVm_pools] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVm_pools]    
AS
BEGIN

      SET NOCOUNT ON
	  BEGIN TRY
		BEGIN TRAN
			  declare @vm_pool_group table
			  (
					vm_pool_id uniqueidentifier,
					assigned_vm_count int
			  )

			  insert @vm_pool_group
			  (
					vm_pool_id,
					assigned_vm_count
			  )     

			  select
			  vm_pools_view.vm_pool_id,
			  count(vm_pool_map.vm_pool_id)
			  from dbo.vm_pools_view vm_pools_view
			  left join vm_pool_map on vm_pools_view.vm_pool_id = vm_pool_map.vm_pool_id
			  group by vm_pools_view.vm_pool_id, vm_pool_map.vm_pool_id

			  declare @vm_pool_running table 
			  (
					vm_pool_id uniqueidentifier,
					vm_running_count int
			  )

			  insert @vm_pool_running 
			  (
					vm_pool_id,
					vm_running_count
			  )

			  select vm_pools_view.vm_pool_id, count(vm_pools_view.vm_pool_id)      
			  from vm_pools_view
			  left join vm_pool_map on vm_pools_view.vm_pool_id = vm_pool_map.vm_pool_id
			  left join vm_dynamic on vm_pool_map.vm_guid = vm_dynamic.vm_guid
			  where vm_dynamic.status > 0
			  group by vm_pools_view.vm_pool_id

			  declare @vm_pool_preresult table
			  (
					vm_pool_id uniqueidentifier,
					assigned_vm_count int,
					vm_running_count int
			  )

			  insert @vm_pool_preresult
			  (
					vm_pool_id,
					assigned_vm_count,
					vm_running_count
			  )

			  select pg.vm_pool_id, pg.assigned_vm_count, pr.vm_running_count
			  from @vm_pool_group pg
			  left join @vm_pool_running pr on pg.vm_pool_id = pr.vm_pool_id

			  update @vm_pool_preresult
			  set vm_running_count = 0
			  where vm_running_count is NULL

			  declare @vm_pool_result table
			  (
					vm_pool_id uniqueidentifier,
					assigned_vm_count int,
					vm_running_count int,
					vm_pool_description nvarchar(max),
					vm_pool_name nvarchar(255),
   				vm_pool_type int,
				parameters nvarchar(200),
   				vds_group_id uniqueidentifier,
				vds_group_name nvarchar(40)

			  )

			  insert @vm_pool_result
			  (
					vm_pool_id,
					assigned_vm_count,
					vm_running_count,
					vm_pool_description,
					vm_pool_name,
				vm_pool_type,
				parameters,
				vds_group_id,
				vds_group_name
			  )

			  select ppr.vm_pool_id, ppr.assigned_vm_count, ppr.vm_running_count,
  				 p.vm_pool_description, p.vm_pool_name, p.vm_pool_type, p.parameters,
					 p.vds_group_id, p.vds_group_name
			  from @vm_pool_preresult ppr
			  inner join vm_pools_view p on ppr.vm_pool_id = p.vm_pool_id

			  select vm_pool_description, vm_pool_id, vm_pool_name,
					 vm_pool_type,parameters,
					assigned_vm_count, vm_running_count,
					 vds_group_id, vds_group_name
			  from @vm_pool_result
		COMMIT TRAN
      END TRY
      BEGIN CATCH
		IF (@@TRANCOUNT > 0)
			ROLLBACK TRAN
		EXEC RethrowError;
	  END CATCH
      SET NOCOUNT OFF

END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVm_poolsByvm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVm_poolsByvm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVm_poolsByvm_pool_id] 
	@vm_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_pools_full_view].[vm_pool_description] AS 'vm_pool_description',
		[vm_pools_full_view].[vm_pool_id] AS 'vm_pool_id',
		[vm_pools_full_view].[vm_pool_name] AS 'vm_pool_name',
		[vm_pools_full_view].[vm_pool_type] AS 'vm_pool_type',
		[vm_pools_full_view].[parameters] AS 'parameters',
		[vm_pools_full_view].[vds_group_id] AS 'vds_group_id',
		[vm_pools_full_view].[vds_group_name] AS 'vds_group_name',
		[vm_pools_full_view].[assigned_vm_count] AS 'assigned_vm_count',
		[vm_pools_full_view].[vm_running_count] AS 'vm_running_count'
		FROM [dbo].[vm_pools_full_view] [vm_pools_full_view]
		WHERE [vm_pool_id]=@vm_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVm_poolsByvm_pool_name')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVm_poolsByvm_pool_name] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVm_poolsByvm_pool_name] 
	@vm_pool_name nvarchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_pools_view].[vm_pool_description] AS 'vm_pool_description',
		[vm_pools_view].[vm_pool_id] AS 'vm_pool_id',
		[vm_pools_view].[vm_pool_name] AS 'vm_pool_name',
		[vm_pools_view].[vm_pool_type] AS 'vm_pool_type',
		[vm_pools_view].[parameters] AS 'parameters',
		[vm_pools_view].[vds_group_id] AS 'vds_group_id',
		[vm_pools_view].[vds_group_name] AS 'vds_group_name'

		FROM [dbo].[vm_pools_view] [vm_pools_view]
		WHERE [vm_pool_name]=@vm_pool_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO




IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllVm_poolsByUser_id_with_groups_and_UserRoles')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllVm_poolsByUser_id_with_groups_and_UserRoles] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllVm_poolsByUser_id_with_groups_and_UserRoles] 
	@user_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	BEGIN TRY
		SELECT  DISTINCT  
		[vm_pools_view].vm_pool_id, 
		[vm_pools_view].vm_pool_name, 
		[vm_pools_view].vm_pool_description,
		[vm_pools_view].[vm_pool_type] AS 'vm_pool_type',
		[vm_pools_view].[parameters] AS 'parameters',
		[vm_pools_view].[vds_group_id] AS 'vds_group_id',
		[vm_pools_view].[vds_group_name] AS 'vds_group_name'
		FROM dbo.vm_pools_view 
		inner join permissions_view as perms on vm_pools_view.vm_pool_id = perms.object_id
		WHERE perms.ad_element_id in (select id from getUserAndGroupsById(@user_id))
			and perms.role_type = 2
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVm_poolsByAdGroup_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVm_poolsByAdGroup_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVm_poolsByAdGroup_id] 
	@ad_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT DISTINCT 
			[vm_pools_view].[vm_pool_id], 
			[vm_pools_view].[vm_pool_name], 
			[vm_pools_view].[vm_pool_description],
			[vm_pools_view].[vm_pool_type] AS 'vm_pool_type',
			[vm_pools_view].[parameters] AS 'parameters',
			[vm_pools_view].[vds_group_id] AS 'vds_group_id',
			[vm_pools_view].[vds_group_name] AS 'vds_group_name' 
			FROM  dbo.ad_vm_pool_group_map INNER JOIN
						  dbo.vm_pools_view ON dbo.ad_vm_pool_group_map.vm_pool_id = dbo.vm_pools_view.vm_pool_id
			WHERE(dbo.ad_vm_pool_group_map.group_id =@ad_group_id)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	
	SET NOCOUNT OFF
END
GO

----------------------------------------------------------------
-- [dbo].[time_lease_vm_pool_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttime_lease_vm_pool_map]
    @end_time datetime,  
 @id uniqueidentifier,  
 @start_time datetime,  
 @type int,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[time_lease_vm_pool_map] ([end_time], [id], [start_time], [type], [vm_pool_id])
	VALUES (@end_time, @id, @start_time, @type, @vm_pool_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatetime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatetime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatetime_lease_vm_pool_map]
    @end_time datetime,
	@id uniqueidentifier,
	@start_time datetime,
	@type int,
	@vm_pool_id uniqueidentifier
AS
BEGIN

	--The [dbo].[time_lease_vm_pool_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[time_lease_vm_pool_map] 
	SET [end_time] = @end_time, [start_time] = @start_time, [type] = @type
	WHERE [id]=@id AND [vm_pool_id]=@vm_pool_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetime_lease_vm_pool_map]
  @id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[time_lease_vm_pool_map]
		WHERE [id]=@id AND [vm_pool_id]=@vm_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtime_lease_vm_pool_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
	FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettime_lease_vm_pool_mapByidAndByvm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByidAndByvm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByidAndByvm_pool_id] 
 @id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
		WHERE [id]=@id AND [vm_pool_id]=@vm_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllUsersFromtime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllUsersFromtime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllUsersFromtime_lease_vm_pool_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
	FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
	WHERE [time_lease_vm_pool_map].type = 0
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllGroupsFromtime_lease_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllGroupsFromtime_lease_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllGroupsFromtime_lease_vm_pool_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
	FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
	WHERE [time_lease_vm_pool_map].type = 0
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettime_lease_vm_pool_mapByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByid] 
 @id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
		WHERE [id]=@id 
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettime_lease_vm_pool_mapByvm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByvm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettime_lease_vm_pool_mapByvm_pool_id] 
 @id uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[time_lease_vm_pool_map].[end_time] AS 'end_time',
		[time_lease_vm_pool_map].[id] AS 'id',
		[time_lease_vm_pool_map].[start_time] AS 'start_time',
		[time_lease_vm_pool_map].[type] AS 'type',
		[time_lease_vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[time_lease_vm_pool_map] [time_lease_vm_pool_map]
		WHERE [vm_pool_id]=@vm_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvm_pools_by_time_leased_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvm_pools_by_time_leased_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvm_pools_by_time_leased_id] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT    	
		[vm_pools_view].[vm_pool_description] AS 'vm_pool_description',
		[vm_pools_view].[vm_pool_id] AS 'vm_pool_id',
		[vm_pools_view].[vm_pool_name] AS 'vm_pool_name',
		[vm_pools_view].[vm_pool_type] AS 'vm_pool_type',
		[vm_pools_view].[parameters] AS 'parameters',
		[vm_pools_view].[vds_group_id] AS 'vds_group_id',
		[vm_pools_view].[vds_group_name] AS 'vds_group_name'

		FROM         dbo.time_lease_vm_pool_map INNER JOIN
							  dbo.vm_pools_view ON 
							dbo.time_lease_vm_pool_map.vm_pool_id = dbo.vm_pools_view.vm_pool_id
		WHERE     (dbo.time_lease_vm_pool_map.id = @id)

	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettime_leasedusers_by_vm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettime_leasedusers_by_vm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettime_leasedusers_by_vm_pool_id] 
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT     
			[users].[department] AS 'department',
			[users].[desktop_device] AS 'desktop_device',
			[users].[domain] AS 'domain',
			[users].[email] AS 'email',
			[users].[groups] AS 'groups',
			[users].[name] AS 'name',
			[users].[note] AS 'note',
			[users].[role] AS 'role',
			[users].[status] AS 'status',
			[users].[surname] AS 'surname',
			[users].[user_icon_path] AS 'user_icon_path',
			[users].[user_id] AS 'user_id',
			[users].[username] AS 'username',
			[time_lease_vm_pool_map].[start_time] AS 'from',
			[time_lease_vm_pool_map].[end_time] AS 'to'
		 FROM         dbo.users INNER JOIN
							  dbo.time_lease_vm_pool_map ON dbo.users.user_id = dbo.time_lease_vm_pool_map.id
		WHERE     (dbo.time_lease_vm_pool_map.vm_pool_id = @vm_pool_id)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettime_leasedad_groups_by_vm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettime_leasedad_groups_by_vm_pool_id] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[Gettime_leasedad_groups_by_vm_pool_id] 
 @vmPoolId uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT DISTINCT 
						[ad_groups].[id] AS 'id',
						[ad_groups].[name] AS 'name',
						[ad_groups].[status]  AS 'status',
						[ad_groups].[domain] AS 'domain',
						[time_lease_vm_pool_map].[start_time] AS 'from',
						[time_lease_vm_pool_map].[end_time] AS 'to'
		FROM         dbo.ad_groups INNER JOIN
						dbo.time_lease_vm_pool_map 
						ON dbo.ad_groups.id= dbo.time_lease_vm_pool_map.id
		                      
		WHERE     (dbo.time_lease_vm_pool_map.vm_pool_id = @vmPoolId)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
