using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.ComponentModel;
using System.Collections.Specialized;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.monitor;
using System.Collections.ObjectModel;

namespace UI.WPFClient
{
	public class BarChart : Chart
	{
		private Canvas host;

		#region Properties

		public ChartSeries Series
		{
			get { return (ChartSeries)GetValue(SeriesProperty); }
			set { SetValue(SeriesProperty, value); }
		}
		public static readonly DependencyProperty SeriesProperty =
			DependencyProperty.Register("Series", typeof(ChartSeries), typeof(BarChart), new UIPropertyMetadata(null, ChartSeriesChanged));

		private static void ChartSeriesChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			BarChart instance = (BarChart)d;
			instance.ChartSeriesChanged();
		}


		public DataTemplate BarTemplate
		{
			get { return (DataTemplate)GetValue(BarTemplateProperty); }
			set { SetValue(BarTemplateProperty, value); }
		}
		public static readonly DependencyProperty BarTemplateProperty =
			DependencyProperty.Register("BarTemplate", typeof(DataTemplate), typeof(BarChart), new UIPropertyMetadata(null));


		public double ScaleYFactor { get; set; }

		#endregion

		public BarChart()
		{
			ScaleYFactor = 1.0;
		}

		public override void OnApplyTemplate()
		{
			base.OnApplyTemplate();

			host = GetTemplateChild("PART_Host") as Canvas;
			host.SizeChanged += Host_SizeChanged;
		}

		private void Host_SizeChanged(object sender, SizeChangedEventArgs e)
		{
			BuildShape();
		}

		private void ChartSeriesChanged()
		{
			if (Series != null)
			{
				BuildShape();
				//var notifier = Series.Items as INotifyCollectionChanged;
				//if (notifier != null)
				//{
				//    notifier.CollectionChanged += Items_CollectionChanged;
				//}
				//else
				//{
				//    BuildShape();
				//}
			}
		}

		void Items_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
		{
			//if (e.Action == NotifyCollectionChangedAction.Add)
			//{
			//    foreach (var item in e.NewItems)
			//    {
			//        if (item is INotifyPropertyChanged)
			//        {
			//            ((INotifyPropertyChanged)item).PropertyChanged += ItemPropertyChanged;
			//        }
			//    }
			//}

			//if (e.Action == NotifyCollectionChangedAction.Remove)
			//{
			//    foreach (var item in e.OldItems)
			//    {
			//        if (item is INotifyPropertyChanged)
			//        {
			//            ((INotifyPropertyChanged)item).PropertyChanged -= ItemPropertyChanged;
			//        }
			//    }
			//}

			BuildShape();
		}

		//protected virtual void ItemPropertyChanged(object sender, PropertyChangedEventArgs e)
		//{
		//    BuildShape();
		//}

		private void BuildShape()
		{
			if (host == null || Series == null)
			{
				return;
			}

			host.Children.Clear();

			double width = host.ActualWidth / Series.Items.Count;
			width = Math.Min(30, width);
			int index = 0;
			foreach (var item in Series.Items ?? new ObservableCollection<ChartSeriesModel>())
			{
				var obj = BarTemplate.LoadContent() as ProgressBar;
				if (obj != null)
				{
					obj.DataContext = item;

					double y = host.ActualHeight / 100.0 * Convert.ToDouble(item.Y);
					double x = width * index;

					obj.Maximum = host.ActualHeight;
					obj.Minimum = 0.0;
					obj.Value = y * ScaleYFactor;
					obj.Width = width;
					obj.Height = host.ActualHeight;
					Canvas.SetTop(obj, 0);
					Canvas.SetBottom(obj, host.ActualHeight);
					Canvas.SetLeft(obj, x);
					host.Children.Add(obj);
				}

				index++;
			}
		}
	}
}
