﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace VdcCommon.BusinessEntities
{
    public partial class VmOperationParameterBase : VdcActionParametersBase
    {
        public VmOperationParameterBase()
        {
        }
        public VmOperationParameterBase(Guid vmId)
        {
            VmId = vmId;
        }
    }
    
    public partial class RemoveVmParameters : VmOperationParameterBase
    {
        public RemoveVmParameters() { }
        public RemoveVmParameters(Guid vmId, bool force)
            : base(vmId)
        {
            Force = force;
        }
    }

    public partial class RemoveVmFromImportExportParamenters
    {
        public RemoveVmFromImportExportParamenters(VM vm, Guid storageDomainId, Guid storagePoolId) 
            : base(vm.vm_guid,false)
        {
            _vm = vm;
            this.StorageDomainId = storageDomainId;
            this.StoragePoolId = storagePoolId;
        }

        public RemoveVmFromImportExportParamenters() { }
    }

    public partial class MigrateVmToServerParameters : MigrateVmParameters
    {
        public MigrateVmToServerParameters() { }

        public MigrateVmToServerParameters(bool forceMigration, Guid vmId, Guid serverId)
            : base(forceMigration, vmId)
        {
            VdsId = serverId;
        }
    }

    public partial class MigrateVmParameters : VmOperationParameterBase
    {
       public MigrateVmParameters() { }

        public MigrateVmParameters(bool forceMigrationForNonMigrableVM, Guid vmId)
            : base(vmId)
        {
            this.forceMigrationForNonMigratableVM = forceMigrationForNonMigrableVM;
        }
    }

    public partial class CreateAllSnapshotsFromVmParameters : VmOperationParameterBase
    {
        public CreateAllSnapshotsFromVmParameters() { }

        public CreateAllSnapshotsFromVmParameters(Guid vmId, string description):
            base(vmId)
        {
            _description = description;
        }
    }

	public partial class TryBackToAllSnapshotsOfVmParameters : VmOperationParameterBase
    {
        public TryBackToAllSnapshotsOfVmParameters() { }
        public TryBackToAllSnapshotsOfVmParameters(Guid vmId, Guid dstSnapshotId) :
            base(vmId)
        {
            _dstSnapshotId = dstSnapshotId;
        }
    }

	public partial class RestoreAllSnapshotsParameters : TryBackToAllSnapshotsOfVmParameters
    {
        public RestoreAllSnapshotsParameters() { }
        public RestoreAllSnapshotsParameters(Guid vmId, Guid dstSnapshotId) :
            base(vmId, dstSnapshotId)
        {
        }
    }

    public partial class StopVmParameters : VmOperationParameterBase
    {	
        public StopVmParameters() { }

        public StopVmParameters(Guid vmID, StopVmTypeEnum stopVmType)
            : base(vmID)
        {
            _stopVmType = stopVmType;
        }
    }

    public partial class ShutdownVmParameters : VmOperationParameterBase
    {
        public ShutdownVmParameters()
        {
            _waitBeforeShutdown = true;
        }

        public ShutdownVmParameters(Guid vmID, bool waitBeforeShutdown)
            : base(vmID)
        {
            _waitBeforeShutdown = waitBeforeShutdown;
        }
    }

    public partial class RunVmParams : VmOperationParameterBase
    {
        public RunVmParams(Guid vmId)
            : base(vmId)
        {
            _internal = false;
            DiskPath = string.Empty;
            KvmEnable = true;
            AcpiEnable = true;
        }

        public RunVmParams()
            : base()
        {
            _internal = false;
            DiskPath = string.Empty;
            KvmEnable = true;
            AcpiEnable = true;
        }
    }

    public partial class ChangeDiskCommandParameters : VmOperationParameterBase
    {
        public ChangeDiskCommandParameters() { }
        public ChangeDiskCommandParameters(Guid vmId, string cdImagePath)
            : base(vmId)
        {
            _cdImagePath = cdImagePath;
        }
    }

    public partial class SetVmTicketParameters : VmOperationParameterBase
    {
        public SetVmTicketParameters() { }

        public SetVmTicketParameters(Guid vmId, string ticket, int validTime)
            : base(vmId)
        {
            _ticket = ticket;
            _validTime = validTime;
        }
	}

    public partial class VmManagementParametersBase : VmOperationParameterBase    
    {
        public VmManagementParametersBase()
        {
        }
        public VmManagementParametersBase(VM vm) : base (vm.vm_guid)
        {
            _vm = vm;
        }
    }
    
    public partial class AddVmFromTemplateParameters : VmManagementParametersBase
    {
        public AddVmFromTemplateParameters() { }
        public AddVmFromTemplateParameters(VM vm, Dictionary<string, DiskImageBase> diskInfoList, Guid storageDomainId)
            : base(vm)
        {
            StorageDomainId = storageDomainId;
            DiskInfoList = (valueObjectMap)diskInfoList;
        }
    }

	public partial class AddVmFromScratchParameters : VmManagementParametersBase
	{
		public AddVmFromScratchParameters()
		{
		}

		public AddVmFromScratchParameters(VM vm, List<DiskImageBase> diskInfoList, Guid storageDomainId)
			: base(vm)
		{
			DiskInfoList = (diskInfoList ?? new List<DiskImageBase>()).ToArray();
			StorageDomainId = storageDomainId;
			_interfaces = new List<VmNetworkInterface>().ToArray();
		}
	}

    public partial class AddDiskToVmParameters : VmOperationParameterBase
    {
        public AddDiskToVmParameters() { }

        public AddDiskToVmParameters(Guid vmId, DiskImageBase diskInfo)
            : base(vmId)
        {
            DiskInfo = diskInfo;
        }
    }
	
	public partial class RemoveDisksFromVmParameters : VmOperationParameterBase
	{
        public RemoveDisksFromVmParameters() { }
        public RemoveDisksFromVmParameters(Guid vmId, List<Guid> imageIds)
            : base(vmId)
        {
			ImageIds = imageIds.Select(a=>(guid)a).ToArray();
        }
    }

    public partial class UpdateVmDiskParameters : AddDiskToVmParameters
    {
        public UpdateVmDiskParameters() { }
        public UpdateVmDiskParameters(Guid vmId, Guid imageId, DiskImageBase diskInfo)
            : base(vmId, diskInfo)
        {
            ImageId = imageId;
        }
    }

    public partial class MoveOrCopyParameters : StorageDomainParametersBase
    {
		public MoveOrCopyParameters() { }
		public MoveOrCopyParameters(Guid containerId, Guid storageDomainId)
            : base(storageDomainId)
        {
            ContainerId = containerId;
            TemplateMustExists = false;
            ForceOverride = false;
        }
	}

    public partial class MoveVmParameters : MoveOrCopyParameters
	{
        public MoveVmParameters() { }

        public MoveVmParameters(Guid vmId, Guid storageDomainId)
			: base (vmId, storageDomainId)
        {
        }
    }

    public partial class ImprotVmTemplateParameters : MoveOrCopyParameters
    {
		public ImprotVmTemplateParameters() { }
        public ImprotVmTemplateParameters(Guid storagePoolId, Guid sourceDomainId, Guid destDomainId, Guid vdsGroupId, VmTemplate template)
			: base(template.Id, destDomainId)
        {
            this.VmTemplate = template;
            this.DestDomainId = destDomainId;
            this.SourceDomainId = sourceDomainId;
            this.StorageDomainId = this.DestDomainId;
            this.StoragePoolId = storagePoolId;
            this.VdsGroupId = vdsGroupId;
        }
    }

    public partial class ImportVmParameters : MoveVmParameters
    {
        public ImportVmParameters() { }

        public ImportVmParameters(VM vm, Guid sourceStorageDomainId, Guid destStorageDomainId, Guid storagePoolId, Guid vdsGroupId)
            : base(vm.vm_guid, destStorageDomainId)
        {
            _vm = vm;
            _sourceDomainId = sourceStorageDomainId;
            _destDomainId = destStorageDomainId;
            StorageDomainId = destStorageDomainId;
            StoragePoolId = storagePoolId;
            _vdsGroupId = vdsGroupId;
        }
    }

	public partial class AddVmInterfaceParameters : VmOperationParameterBase
	{
		public AddVmInterfaceParameters() { }

		public AddVmInterfaceParameters(Guid vmId, VmNetworkInterface iface)
			: base(vmId)
		{
			Interface = iface;
		}
	}

    public partial class RemoveVmInterfaceParameters : VmOperationParameterBase
    {
        public RemoveVmInterfaceParameters() { }

        public RemoveVmInterfaceParameters(Guid vmId, Guid ifaceId)
            : base(vmId)
        {
            InterfaceId = ifaceId; 
        }
    }

    public partial class HibernateVmParameters : VmOperationParameterBase
    {
        public HibernateVmParameters() { }
        public HibernateVmParameters(Guid vmId)
            : base(vmId)
        {
        }
    }

    public partial class ChangeVMClusterParameters : VmOperationParameterBase
    {
        public ChangeVMClusterParameters() { }
        public ChangeVMClusterParameters(Guid clusterId, Guid vmId)
        {
            this.clusterId = clusterId;
            this.VmId = vmId;
        }
    }
}
