-- this procedure will write our event data into the table and send the notification email

if exists (select [name] from sys.tables where [name] = 'trap_deadlocks')
begin
	DROP TABLE trap_deadlocks
	DROP PROCEDURE usp_ProcessNotification
	DROP EVENT NOTIFICATION DeadLockNotificationEvent ON SERVER 
	DROP ROUTE DeadLockNotificationsRoute
	DROP SERVICE DeadLockNotificationsService
	DROP QUEUE DeadLockNotificationsQueue

end
go

CREATE PROCEDURE usp_ProcessNotification 
AS
    DECLARE @msgBody XML    
    DECLARE @dlgId uniqueidentifier

    -- you can change this to get all messages at once
    WHILE(1=1)
    BEGIN
        BEGIN TRANSACTION    
        BEGIN TRY        
            -- receive messages from the queue one by one            
            ;RECEIVE TOP(1) 
                    @msgBody    = message_body,
                    @dlgId        = conversation_handle
            FROM    dbo.DeadLockNotificationsQueue
            
            -- exit when the whole queue has been processed
            IF @@ROWCOUNT = 0
            BEGIN
                IF @@TRANCOUNT > 0
                BEGIN 
                    ROLLBACK;
                END  
                BREAK;
            END 

            -- insert event data into our table 
            INSERT INTO trap_deadlocks(eventMsg)
            SELECT @msgBody
            
            DECLARE @MailBody NVARCHAR(MAX)    
            SELECT @MailBody = CAST(@msgBody AS NVARCHAR(MAX));

            -- send an email with the defined email profile. 
            -- since this is async it doesn't halt execution
            -- EXEC msdb.dbo.sp_send_dbmail
            --         @profile_name = 'your mail profile', -- your defined email profile 
            --         @recipients = 'dba@yourCompany.com', -- your email
            --         @subject = 'Deadlock occured notification',
            --         @body = @MailBody;
            
            IF @@TRANCOUNT > 0
            BEGIN 
                COMMIT;
            END
        END TRY
        BEGIN CATCH
            IF @@TRANCOUNT > 0
            BEGIN 
                ROLLBACK;
            END
            -- write any error in to the event log
            DECLARE @errorNumber BIGINT, @errorMessage nvarchar(2048), @dbName nvarchar(128)
            SELECT  @errorNumber = ERROR_NUMBER(), @errorMessage = ERROR_MESSAGE(), @dbName = DB_NAME()

            RAISERROR (N'Error WHILE receiving Service Broker message FROM queue DeadLockNotificationsQueue.
                        DATABASE Name: %s; Error number: %I64d; Error Message: %s', 
                        16, 1, @dbName, @errorNumber, @errorMessage) WITH LOG;
        END CATCH;
    END
GO

-- create the notification queue that will receive the event notification messages
-- add the activation stored procedure that will process the messages in the queue
-- as they arrive
CREATE QUEUE DeadLockNotificationsQueue
    WITH STATUS = ON,
    ACTIVATION (
        PROCEDURE_NAME = usp_ProcessNotification,
        MAX_QUEUE_READERS = 1,
        EXECUTE AS 'dbo' );
GO

-- crete the notofication service for our queue with the pre-defined message type
CREATE SERVICE DeadLockNotificationsService
    ON QUEUE DeadLockNotificationsQueue 
                ([http://schemas.microsoft.com/SQL/Notifications/PostEventNotification]);
GO

-- create the route for the service
CREATE ROUTE DeadLockNotificationsRoute
    WITH SERVICE_NAME = 'DeadLockNotificationsService',
    ADDRESS = 'LOCAL';
GO

-- create the event notification for the DEADLOCK_GRAPH event. 
-- other lock events can be added 
CREATE EVENT NOTIFICATION DeadLockNotificationEvent
ON SERVER 
FOR DEADLOCK_GRAPH -- , LOCK_DEADLOCK_CHAIN, LOCK_DEADLOCK, LOCK_ESCALATION -- ANY OF these can be SET
TO SERVICE 'DeadLockNotificationsService', 
           'current database' -- CASE sensitive string that specifies USE OF server broker IN CURRENT db
GO

-- check to see if our event notification has been created ok
--SELECT * FROM sys.server_event_notifications WHERE name = 'DeadLockNotificationEvent';
--GO

-- create the table that will hold our deadlock info
CREATE TABLE trap_deadlocks(Id INT IDENTITY(1,1), EventMsg xml, EventDate datetime default(GETDATE()))
GO

