/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata.countermaps;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.countermaps.CounterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicCounterMap<T>
implements CounterMap<T>,
HasBeenInstrumented {
    private final ConcurrentMap<T, AtomicInteger> counters = new ConcurrentHashMap<T, AtomicInteger>();

    @Override
    public final void incrementValue(T key, int inc) {
        AtomicInteger v = (AtomicInteger)this.counters.get(key);
        if (v != null) {
            v.addAndGet(inc);
        } else {
            v = this.counters.putIfAbsent(key, new AtomicInteger(inc));
            if (v != null) {
                v.addAndGet(inc);
            }
        }
    }

    @Override
    public final void incrementValue(T key) {
        AtomicInteger v = (AtomicInteger)this.counters.get(key);
        if (v != null) {
            v.incrementAndGet();
        } else {
            v = this.counters.putIfAbsent(key, new AtomicInteger(1));
            if (v != null) {
                v.incrementAndGet();
            }
        }
    }

    @Override
    public final int getValue(T key) {
        AtomicInteger v = (AtomicInteger)this.counters.get(key);
        return v == null ? 0 : v.get();
    }

    @Override
    public synchronized Map<T, Integer> getFinalStateAndCleanIt() {
        LinkedHashMap res = new LinkedHashMap();
        Iterator iterator = this.counters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            int old = ((AtomicInteger)entry.getValue()).get();
            iterator.remove();
            if (old <= 0) continue;
            res.put(key, old);
        }
        return res;
    }

    public int getSize() {
        return this.counters.size();
    }
}

