﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace UI.WPFClient
{
	public class UpdateBindingSourceBehavior : Behavior<FrameworkElement>
	{
		public DependencyProperty Property { get; set; }


		protected override void OnAttached()
		{
			base.OnAttached();

			AssociatedObject.KeyDown += AssociatedObject_KeyDown;
		}

		void AssociatedObject_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.Key == Key.Enter)
			{
				var binding = AssociatedObject.GetBindingExpression(Property);
				if (binding != null)
				{
					binding.UpdateSource();
				}
			}
		}
	}
}
