﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Xml;
using VdcCommon.VdcQueries;
using VdcCommon.BusinessEntities;

namespace VdcCommon.BusinessEntities
{
	[DataContract]
	public class IrsBaseVDSCommandParameters : VDSParametersBase
	{
		public IrsBaseVDSCommandParameters(Guid storagePoolId)
		{
			StoragePoolId = storagePoolId;
		}

		[DataMember]
		public Guid StoragePoolId
		{
			get;
			set;
		}

		[DataMember]
		public bool IgnoreFailoverLimit
		{
			get;
			set;
		}
		[DataMember]
		public string CompatibilityVersion
		{
			get;
			set;
		}
	}
	public class StoragePoolDomainAndGroupIdBaseVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public StoragePoolDomainAndGroupIdBaseVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId)
			: base (storagePoolId)
		{
			StorageDomainId = storageDomainId;
			ImageGroupId = imageGroupId;
		}
		[DataMember]
		public Guid StorageDomainId
		{
			get;
			set;
		}
		[DataMember]
		public Guid ImageGroupId
		{
			get;
			set;
		}
	}
	[DataContract]
	public class CreateImageVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		public CreateImageVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, long imageSizeInBytes,
                                                    VolumeType imageType, VolumeFormat volFormat, DiskType diskType, Guid newImageId, string newImageDescription, string competabilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId)
		{
			_imageSizeInBytes = imageSizeInBytes;
			_imageType = imageType;
			this.VolumeFormat = volFormat;
			this.DiskType = diskType;
            NewImageID = newImageId;
            NewImageDescription = newImageDescription;
            CompatibilityVersion = competabilityVersion;
		}

		[DataMember]
		private readonly long _imageSizeInBytes;
		[DataMember]
		private readonly VolumeType _imageType;

		public long ImageSizeInBytes
		{
			get { return _imageSizeInBytes; }
		}
		public VolumeType ImageType
		{
			get { return _imageType; }
		}
		public VolumeFormat VolumeFormat
		{
			get;
			protected set;
		}
		public DiskType DiskType
		{
			get;
			protected set;
		}
        public Guid NewImageID
        {
            get;
            protected set;
        }

        public string NewImageDescription
        {
            get;
            protected set;
        }
	}
	[DataContract]
	public class ImageIdVDSCommandParametersBase : IrsBaseVDSCommandParameters
	{
		public ImageIdVDSCommandParametersBase(Guid storagePoolId, Guid imageId)
			: base(storagePoolId)
		{
			_imageId = imageId;
		}

		[DataMember]
		private readonly Guid _imageId;

		public Guid ImageId
		{
			get { return _imageId; }
		}
	}
	[DataContract]
	public class AllStorageAndImageIdVDSCommandParametersBase : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		public AllStorageAndImageIdVDSCommandParametersBase(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId)
			: base(storagePoolId, storageDomainId, imageGroupId)
		{
			_imageId = imageId;
		}

		[DataMember]
		private readonly Guid _imageId;

		public Guid ImageId
		{
			get { return _imageId; }
		}
	}
	[DataContract]
	public class DestroyImageVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		public DestroyImageVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, List<Guid> imageList, bool postZero)
			: base(storagePoolId, storageDomainId, imageGroupId, Guid.Empty)
		{
			PostZero = postZero;
		    ImageList = imageList;
		}
        [DataMember]
        public List<Guid> ImageList
        {
            get; private set;
        }
		[DataMember]
		public bool PostZero
		{
			get;
			protected set;
		}
	}
	[DataContract]
	public class GetImageInfoVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		public GetImageInfoVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId)
			: base(storagePoolId, storageDomainId, imageGroupId, imageId)
		{
		}
	}
	[DataContract]
	public class CopyImageVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		public CopyImageVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid vmId, Guid imageGroupId, Guid srcImageId, 
			Guid dstImageGroupId, Guid dstVolUUID, string description, Guid dstStorageDomainId, CopyVolumeType copyVolumeType,
								VolumeFormat volumeFormat, VolumeType preallocate, bool postZero, bool force, string compatibilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId, srcImageId)
		{
			this.dstImageGroupId = dstImageGroupId;
			VmId = vmId;
            DstImageId = dstVolUUID;
            ImageDescription = description;
            PostZero = postZero;
            Force = force;
			DstStorageDomainId = dstStorageDomainId;
			CopyVolumeType = copyVolumeType;
			VolumeFormat = volumeFormat;
			Preallocate = preallocate;
			CompatibilityVersion = compatibilityVersion;
		}
		
		[DataMember]
		public Guid dstImageGroupId
		{
			get;
			set;
		}

		[DataMember]
		public Guid VmId
		{
			get;
			set;
		}

        [DataMember]
        public Guid DstImageId
        {
            get;
            set;
        }

        [DataMember]
        public string ImageDescription
        {
            get;
            set;
        }

		[DataMember]
		public Guid DstStorageDomainId
		{
			get;
			set;
		}

		[DataMember]
		public CopyVolumeType CopyVolumeType
		{
			get;
			set;
		}

		[DataMember]
		public VolumeFormat VolumeFormat
		{
			get;
			set;
		}

		[DataMember]
		public VolumeType Preallocate
		{
			get;
			set;
		}

		[DataMember]
		public bool PostZero
		{
			get;
			set;
		}

		[DataMember]
		public bool Force
		{
			get;
			set;
		}
	}
	[DataContract]
	public class CreateSnapshotVDSCommandParameters : CreateImageVDSCommandParameters
	{
		public CreateSnapshotVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId, long imgSizeInBytes,
													VolumeType imageType, VolumeFormat volFormat, DiskType diskType, Guid sourceImageGroupId, Guid newImageId, string newImageDescription, string competabilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId, imgSizeInBytes, imageType, volFormat, diskType, newImageId, newImageDescription, competabilityVersion)
		{
			_imageId = imageId;
			SourceImageGroupId = sourceImageGroupId;
		}
		[DataMember]
		private readonly Guid _imageId;

		public Guid ImageId
		{
			get { return _imageId; }
		}

		[DataMember]
		public Guid SourceImageGroupId
		{
			get;
			set;
		}
	}
	[DataContract]
	public class MergeSnapshotsVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly Guid _imageId2;
		public MergeSnapshotsVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid vmId, Guid imageGroupId, Guid imageId, Guid imageId2, bool postZero, string compatibilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId, imageId)
		{
			_imageId2 = imageId2;
			VmId = vmId;
            PostZero = postZero;
			CompatibilityVersion = compatibilityVersion;
		}

		public Guid ImageId2
		{
			get
			{
				return _imageId2;
			}
		}
		[DataMember]
		public Guid VmId
		{
			get;
			set;
		}
        [DataMember]
        public bool PostZero
        {
            get;
            set;
        }
	}
	[DataContract]
	public class SetImageDescriptionVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly string _description;
		public SetImageDescriptionVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId, string description)
			: base(storagePoolId, storageDomainId, imageGroupId, imageId)
		{
			_description = description;
		}

		public string Description
		{
			get
			{
				return _description;
			}
		}
	}
	[DataContract]
	public class SetImageLegalityVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly bool _isLegal;
		public SetImageLegalityVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId, bool isLegal)
			: base(storagePoolId, storageDomainId, imageGroupId, imageId)
		{
			_isLegal = isLegal;
		}

		public bool IsLegal
		{
			get
			{
				return _isLegal;
			}
		}
	}
	[DataContract]
	public class ResetIrsVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public ResetIrsVDSCommandParameters(Guid storagePoolId, string hostName, int vdsId)
			: base(storagePoolId)
		{
		    VdsId = vdsId;
			_hostName = hostName;
		}

		[DataMember]
		private readonly string _hostName;

	    [DataMember] 
	    public int VdsId
	    {
	         get; set;
	    }
		public string HostName
		{
			get { return _hostName; }
		}

		[DataMember]
		public bool IgnoreStopFailed
		{
			get;
			set;
		}
	}
	[DataContract]
	public class GetImportCandidatesVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		[DataMember]
		public string Path { get; set; }

		[DataMember]
		public ImportCandidateSourceEnum CandidateSource { get; set; }

		[DataMember]
		public ImportCandidateTypeEnum CandidateType { get; set; }

		public GetImportCandidatesVDSCommandParameters(Guid storagePoolId,
			string path,
			ImportCandidateSourceEnum candidateSource,
			ImportCandidateTypeEnum candidateType)
			: base(storagePoolId)
		{
			Path = path;
			CandidateSource = candidateSource;
			CandidateType = candidateType;
		}
	}

	[DataContract]
	public class GetCandidateInfoVDSCommandParameters : GetImportCandidatesVDSCommandParameters
	{
		[DataMember]
		public string CandidateID { get; set; }

		public GetCandidateInfoVDSCommandParameters(Guid storagePoolId,
			string candidateID,
			string path,
			ImportCandidateSourceEnum candidateSource,
			ImportCandidateTypeEnum candidateType)
			: base(storagePoolId, path, candidateSource, candidateType)
		{
			CandidateID = candidateID;
		}
	}

	[DataContract]
	public class ImportCandidateVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		[DataMember]
		public string CandidateID { get; protected set; }

		[DataMember]
		public Guid BaseID { get; protected set; }

		[DataMember]
		public Dictionary<string, Guid> BaseImageIDs { get; protected set; }

		[DataMember]
		public ImportCandidateSourceEnum CandidateSource { get; protected set; }

		[DataMember]
		public string ImportPath { get; protected set; }

		[DataMember]
		public bool Force { get; protected set; }

		public ImportCandidateVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, 
			string candidateID, 
			Guid baseID, 
			Dictionary<string, Guid> baseImageIDs,
			ImportCandidateSourceEnum candidateSource,
			string importPath,
			bool force) 
			: base (storagePoolId, storageDomainId, imageGroupId)
	    {
            CandidateID = candidateID;
			BaseID = baseID;
			BaseImageIDs = baseImageIDs;
			CandidateSource = candidateSource;
			ImportPath = importPath;
			Force = force;
	    }
	}

	[DataContract]
	public class ExportCandidateVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		[DataMember]
		public Guid VmGUID { get; private set; }
		[DataMember]
		public Guid StorageDomainId { get; private set; }
		[DataMember]
		public Dictionary<string, List<Guid>> ListOfImages { get; private set; }
		[DataMember]
		public string VmMeta { get; private set; }
		[DataMember]
		public Guid VmTemplateGUID { get; private set; }
		[DataMember]
		public Dictionary<string, Guid> VmTemplateImageGUIDs { get; private set; }
		[DataMember]
		public string VmTemplateMeta { get; private set; }
		[DataMember]
		public string Path { get; private set; }
		[DataMember]
		public bool Collapse { get; private set; }
		[DataMember]
		public bool Force { get; set; }

		public ExportCandidateVDSCommandParameters(Guid storagePoolId,
			Guid storageDomainId,
			Guid vmGUID,
			Dictionary<string, List<Guid>> listOfImages,
			string vmMeta,
			Guid vmTemplateGUID,
			Dictionary<string, Guid> vmTemplateImageGUIDs,
			string vmTemplateMeta,
			string path,
			bool collapse,
			bool force)
			: base(storagePoolId)
		{
			StorageDomainId = storageDomainId;
			VmGUID = vmGUID;
			ListOfImages = listOfImages;
			VmMeta = vmMeta;
			VmTemplateGUID = vmTemplateGUID;
			VmTemplateImageGUIDs = vmTemplateImageGUIDs;
			VmTemplateMeta = vmTemplateMeta;
			Path = path;
			Collapse = collapse;
			Force = force;
		}
	}
	[DataContract]
	public class ListImageIdsVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		public ListImageIdsVDSCommandParameters()
			: this(Guid.Empty, Guid.Empty, Guid.Empty)
		{
		}
		public ListImageIdsVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId)
			: base(storagePoolId, storageDomainId, imageGroupId)
		{
		}
	}

	[DataContract]
	public class ExtendVolumeVDSCommandParameters : AllStorageAndImageIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly int _newSize;
		public ExtendVolumeVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid imageId, int newSize)
			: base(storagePoolId, storageDomainId, imageGroupId, imageId)
		{
			_newSize = newSize;
		}

		public int NewSize
		{
			get
			{
				return _newSize;
			}
		}
	}

	#region Storage Domains
	

	[DataContract]
	public class ActivateStorageDomainVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		[DataMember]
		public Guid StorageDomainId { get; private set; }

		public ActivateStorageDomainVDSCommandParameters(Guid storagePoolId, Guid storageDomainId)
			: base(storagePoolId)
		{
			StorageDomainId = storageDomainId;
		}
	}

	[DataContract]
	public class DeactivateStorageDomainVDSCommandParameters : ActivateStorageDomainVDSCommandParameters
	{
		[DataMember]
		public Guid MasterStorageDomainId { get; private set; }
		[DataMember]
		public int MasterVersion { get; private set; }

		public DeactivateStorageDomainVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid masterStorageDomainId, int masterVersion)
			: base(storagePoolId, storageDomainId)
		{
			MasterStorageDomainId = masterStorageDomainId;
			MasterVersion = masterVersion;
		}
	}

	[DataContract]
	public class DetachStorageDomainVDSCommandParameters : DeactivateStorageDomainVDSCommandParameters
	{
		public DetachStorageDomainVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid masterStorageDomainId, int masterVersion)
			: base(storagePoolId, storageDomainId, masterStorageDomainId, masterVersion)
		{
		}

		public bool Force
		{
			get;
			set;
		}
	}
	
	[DataContract]
	public class AttachStorageDomainVDSCommandParameters : ActivateStorageDomainVDSCommandParameters
	{
		public AttachStorageDomainVDSCommandParameters(Guid storagePoolId, Guid storageDomainId)
			: base(storagePoolId, storageDomainId)
		{
		}
	}

	[DataContract]
	public class SetStorageDomainDescriptionVDSCommandParameters : ActivateStorageDomainVDSCommandParameters
	{
		[DataMember]
		public string Description { get; private set; }

		public SetStorageDomainDescriptionVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, string description)
			: base(storagePoolId, storageDomainId)
		{
			Description = description;
		}
	}

	[DataContract]
	public class GetStorageDomainInfoVDSCommandParameters : ActivateStorageDomainVDSCommandParameters
	{
		public GetStorageDomainInfoVDSCommandParameters(Guid storagePoolId, Guid storageDomainId)
			: base(storagePoolId, storageDomainId)
		{
		}
	}

	[DataContract]
	public class GetStorageDomainsListVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public GetStorageDomainsListVDSCommandParameters(Guid storagePoolId)
			: base(storagePoolId)
		{
		}
	}
	[DataContract]
	public class ExtendStorageDomainVDSCommandParameters : ActivateStorageDomainVDSCommandParameters
	{
		public ExtendStorageDomainVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, List<string> deviceList)
			: base(storagePoolId, storageDomainId)
		{
			DeviceList = deviceList;
		}
		[DataMember]
		public List<string> DeviceList { get; private set; }
	}
	#endregion
	#region Storage Pools
	[DataContract]
	public class SetStoragePoolDescriptionVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		[DataMember]
		public string Description { get; private set; }

		public SetStoragePoolDescriptionVDSCommandParameters(Guid storagePoolId, string description)
			: base(storagePoolId)
		{
			Description = description;
		}
	}
	[DataContract]
	public class GetStoragePoolInfoVDSCommandParameters : GetStorageDomainsListVDSCommandParameters
	{
		public GetStoragePoolInfoVDSCommandParameters(Guid storagePoolId)
			: base(storagePoolId)
		{
		}
	}
	[DataContract]
	public class DeleteImageGroupVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		public DeleteImageGroupVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, bool postZeros, bool force, string competabilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId)
		{
            PostZeros = postZeros;
            ForceDelete = force;
            CompatibilityVersion = competabilityVersion;
		}

        [DataMember]
        public bool PostZeros
        {
            get;
            protected set;
        }
        [DataMember]
        public bool ForceDelete
        {
            get;
            set;
        }
	}
	[DataContract]
	public class MoveImageGroupVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		[DataMember]
		public Guid DstDomainId { get; private set; }
		[DataMember]
		public Guid VmId { get; private set; }
		[DataMember]
		public ImageOperation Op { get; private set; }
		public MoveImageGroupVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, Guid imageGroupId, Guid dstStorageDomainId, 
			Guid vmId, ImageOperation op, bool postZero, bool force, string compatibilityVersion)
			: base(storagePoolId, storageDomainId, imageGroupId)
		{
			DstDomainId = dstStorageDomainId;
			VmId = vmId;
			Op = op;
            PostZero = postZero;
            Force = force;
			CompatibilityVersion = compatibilityVersion;
		}

		[DataMember]
		public bool PostZero
		{
			get;
			set;
		}

		[DataMember]
		public bool Force
		{
			get;
			set;
		}
	}
	[DataContract]
	public class MoveMultipleImageGroupsVDSCommandParameters : StoragePoolDomainAndGroupIdBaseVDSCommandParameters
	{
		[DataMember]
		public Guid DstDomainId { get; private set; }
		[DataMember]
		public Guid ContainerId { get; private set; }
		[DataMember]
		public List<DiskImage> ImagesList { get; private set; }
		public MoveMultipleImageGroupsVDSCommandParameters(Guid storagePoolId, Guid storageDomainId, List<DiskImage> imagesList, Guid dstStorageDomainId, Guid containerId)
			: base(storagePoolId, storageDomainId, Guid.Empty)
		{
			DstDomainId = dstStorageDomainId;
			ContainerId = containerId;
			ImagesList = imagesList;
		}
	}
	[DataContract]
	public class GetImageDomainsListVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public GetImageDomainsListVDSCommandParameters(Guid storagePoolId, Guid imageGroupId)
			: base(storagePoolId)
		{
			ImageGroupId = imageGroupId;
		}
		[DataMember]
		public Guid ImageGroupId { get; private set; }
	}
	#endregion

	[DataContract]
	public class SetMaxHostsVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public SetMaxHostsVDSCommandParameters(Guid storagePoolId, int maxHosts)
			: base(storagePoolId)
		{
			MaxHosts = maxHosts;
		}
		[DataMember]
		public int MaxHosts { get; private set; }
	}

	[DataContract]
	public class SPMTaskGuidBaseVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public SPMTaskGuidBaseVDSCommandParameters(Guid storagePoolId, Guid taskId)
			: base(storagePoolId)
		{
			TaskId = taskId;
		}
		[DataMember]
		public Guid TaskId { get; private set; }
	}

	[DataContract]
	public class UpdateVMVDSCommandParameters : IrsBaseVDSCommandParameters
	{
		public UpdateVMVDSCommandParameters(Guid storagePoolId, Dictionary<Guid, KeyValuePair<string, List<Guid>>> infoDictionary)
			: base(storagePoolId)
		{
			InfoDictionary = infoDictionary ?? new Dictionary<Guid, KeyValuePair<string, List<Guid>>>();
		}
		[DataMember]
		public Dictionary<Guid, KeyValuePair<string, List<Guid>>> InfoDictionary { get; private set; }
        [DataMember]
        public Guid StorageDomainId { get; set; }
	}
	[DataContract]
	public class RemoveVMVDSCommandParameters : IrsBaseVDSCommandParameters
	{
        public RemoveVMVDSCommandParameters(Guid storagePoolId, Guid vmGuid)
            : this(storagePoolId, vmGuid, Guid.Empty)
        {
        }
		public RemoveVMVDSCommandParameters(Guid storagePoolId, Guid vmGuid, Guid storageDomainId)
			: base(storagePoolId)
		{
			VmGuid = vmGuid;
            StorageDomainId = storageDomainId;
		}
		[DataMember]
		public Guid VmGuid{ get; set; }
		[DataMember]
		public Guid StorageDomainId{ get; set; }
	}
}
