'''
Created on May 13, 2010

@author: mpastern@redhat.com
'''

import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions

class ArgsWrapper(object):
    '''
    classdocs
    '''
    __args = []
    __client = None
    __methodsContainer = []

    def __init__(self, args, client=None):
        '''
        Constructor
        '''
        self.__args = args
        self.__client = client
#TODO: Add support for rhev_client args, e.g rhevClient [OPTIONS] [arg] [params]         
    def wrapArgs(self):
        argsList = []
        if  (not self.__args == None) and (len(self.__args) > 0):                    
            argsList.append(self.__args[0])
            cmd = {}
            for arg in self.__args[1:]:
                if(arg.startswith('-') or arg.startswith('--')):
                    if(not cmd == {}):
                        argsList.append(cmd)
                        cmd = {}
                    if(arg.startswith('--')):
                        cmd[arg[2:]] = ''
                    elif(arg.startswith('-')):
                        cmd[arg[1:]] = ''
                    else:
                        cmd[arg] = ''
                elif(not len(cmd.items()) == 0):
                        cmd[cmd.keys()[0]] = arg
                        argsList.append(cmd)
                        cmd = {}
                else: raise Exceptions.WrongArgumentFormat(arg)     
                        
        if(not cmd == {}): argsList.append(cmd)              
        return argsList

    def __getMethod(self, methodName):
        method = self.__client.getMethodSignatureByName(methodName)            
        if(method == [] or method == None or method == ''):
            raise Exceptions.MethodNotFound(methodName)
        elif(len(method) > 1):
            raise Exceptions.MultipaleMethodsFound(methodName)
        else:
            return method[0]
    
    def __isThisHelpRequest(self):
#TODO: Threat 'help' discovering nicely.
        if (not self.__args == None) and len(self.__args) > 0 and((self.__args.__contains__('-h') or self.__args.__contains__('-help')or self.__args.__contains__('--help'))):
            return True
        return False
    
    def __preProcessArgs(self, args={}):                    
        methodName = args[0]
        method = self.__getMethod(methodName)        
        
        if(method.get_argument_processing_algorithm() != 'leaf'):
            return args
        
        newArgs = []
        newArgs.append(methodName)
        argsContainer = method.get_args_container()
        
        for arg in args[1:]:
            param = argsContainer.getParameterByUniqueName(arg.keys()[0])           
            if(param.__len__() != 0):
                if(param.__len__() > 1):
                    raise Exceptions.\
                           AmbiguousParameterException(methodName, arg.keys()[0])
                key = param[0].get_fq_name()
                value = arg.values()[0]
                newArgs.append({key:value}) 
            else: newArgs.append(arg)                          

        return newArgs
    
    def wrapAndCollapseArgs(self, args={}):

        kwargs = {}
        methodName = ''
        method = None
        methodAargs = {}
        if(args == {}): args = self.wrapArgs()  
        
        if(args.__len__()>0 and (args[0]=='-h' or args[0]=='--help')):
            methodName = 'Help'
            if(args.__len__()==2):
                kwargs = args[1]
            return methodName, kwargs
           
        args = self.__preProcessArgs(args)   
        clientTypes = self.__client.getTypes()    

        if ((not self.__args == None) and (len(self.__args) > 0) or (not args == {})):
            methodName = args[0]
            method = self.__getMethod(methodName)
            methodAargs = method.getParams()
            
            for arg in args[1:]:
                key = arg.keys()[0]
                value = arg.values()[0]
                splitedKey = key.split(".")
                                
                if(len(splitedKey) >= 2):                                        
                    paramType = method.getParamType(splitedKey[0])                   
            
                    if(self.__isThisArgClientType(paramType, clientTypes) and (not kwargs.__contains__(splitedKey[0]))):
                        kwargs[splitedKey[0]] = self.__createClientTypeInstance(paramType)                                    
                    if((kwargs.__contains__(splitedKey[0])) and self.__isThisArgumentValidForNetstedType(kwargs[splitedKey[0]], splitedKey[1:])):
                        self.__setArgumentValue(kwargs[splitedKey[0]], splitedKey[1:], value)
                    elif((not kwargs.__contains__(splitedKey[0])) and self.__isThisArgumentValidForMethod(method, key, methodAargs)):
                        kwargs[key] = value
                else:
                    if(self.__isThisArgumentValidForMethod(method, key, methodAargs)):
                        kwargs[key] = value
        return methodName, kwargs
    
    def __setArgumentValue(self, objType=None, property=[], value=''):
        if(len(property) > 1):
            return self.__setArgumentValue(type(objType).__getattribute__(objType, property[0]), property[1:], value)
        try:     
            objType.__setattr__(property[0], value)
        except Exception: 
            raise Exceptions.ValueAssigningFailure(objType, property[0], value)    
    def __isThisArgumentValidForNetstedType(self, objType, property=[]):
        if(len(property) > 1):
            return self.__isThisArgumentValidForNetstedType(type(objType).__getattribute__(objType, property[0]), property[1:])
        try:             
#TODO:  Replace exception by valid prop validation.
            prpVal = type(objType).__getattribute__(objType, property[0]) 
            del prpVal
            return True
        except Exception: 
            raise Exceptions.NotValidArgumentForNestedType(objType, property[0])

    def __isThisArgumentValidForMethod(self, method, key, mParams):
        if(mParams == None or mParams == [] or mParams == ''):
            raise Exceptions.MethodShouldHaveNoArgs(method.getName(), key)
        
        for val in mParams.values():
            if(val.keys()[0] == key):
                return True
            
        raise Exceptions.NotValidArgumentForMethod(method.getName(), key)
    def __isThisArgClientType(self, arg, clientTypes):
        if(arg in clientTypes):
            return True
        return False
    def __createClientTypeInstance(self, arg):        
        return (self.__client.createEntity(arg))
        
