/* AUTOMATICALLY GENERATED, DO NOT MODIFY */

/*
 * schema-defined QAPI types
 *
 * Copyright IBM, Corp. 2011
 *
 * Authors:
 *  Anthony Liguori   <aliguori@us.ibm.com>
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 *
 */

#ifndef RHEV_QAPI_TYPES_H
#define RHEV_QAPI_TYPES_H

#include "qapi/qapi-types-core.h"

extern const char *NewImageMode_lookup[];
typedef enum NewImageMode
{
    NEW_IMAGE_MODE_EXISTING = 0,
    NEW_IMAGE_MODE_ABSOLUTE_PATHS = 1,
    NEW_IMAGE_MODE_MAX = 2,
} NewImageMode;

typedef struct BlockdevSnapshot BlockdevSnapshot;

typedef struct BlockdevSnapshotList
{
    BlockdevSnapshot *value;
    struct BlockdevSnapshotList *next;
} BlockdevSnapshotList;

typedef struct BlockdevMirror BlockdevMirror;

typedef struct BlockdevMirrorList
{
    BlockdevMirror *value;
    struct BlockdevMirrorList *next;
} BlockdevMirrorList;

typedef struct BlockdevAction BlockdevAction;

typedef struct BlockdevActionList
{
    BlockdevAction *value;
    struct BlockdevActionList *next;
} BlockdevActionList;

extern const char *BlockdevActionKind_lookup[];
typedef enum BlockdevActionKind
{
    BLOCKDEV_ACTION_KIND_BLOCKDEV_SNAPSHOT_SYNC = 0,
    BLOCKDEV_ACTION_KIND_COM_REDHAT_DRIVE_MIRROR = 1,
    BLOCKDEV_ACTION_KIND_MAX = 2,
} BlockdevActionKind;

typedef struct ImageCheck ImageCheck;

typedef struct ImageCheckList
{
    ImageCheck *value;
    struct ImageCheckList *next;
} ImageCheckList;

typedef struct BlockDeviceMapEntry BlockDeviceMapEntry;

typedef struct BlockDeviceMapEntryList
{
    BlockDeviceMapEntry *value;
    struct BlockDeviceMapEntryList *next;
} BlockDeviceMapEntryList;

typedef struct EventInfo EventInfo;

typedef struct EventInfoList
{
    EventInfo *value;
    struct EventInfoList *next;
} EventInfoList;

typedef struct String String;

typedef struct StringList
{
    String *value;
    struct StringList *next;
} StringList;

typedef struct InetSocketAddress InetSocketAddress;

typedef struct InetSocketAddressList
{
    InetSocketAddress *value;
    struct InetSocketAddressList *next;
} InetSocketAddressList;

typedef struct UnixSocketAddress UnixSocketAddress;

typedef struct UnixSocketAddressList
{
    UnixSocketAddress *value;
    struct UnixSocketAddressList *next;
} UnixSocketAddressList;

typedef struct SocketAddress SocketAddress;

typedef struct SocketAddressList
{
    SocketAddress *value;
    struct SocketAddressList *next;
} SocketAddressList;

extern const char *SocketAddressKind_lookup[];
typedef enum SocketAddressKind
{
    SOCKET_ADDRESS_KIND_INET = 0,
    SOCKET_ADDRESS_KIND_UNIX = 1,
    SOCKET_ADDRESS_KIND_FD = 2,
    SOCKET_ADDRESS_KIND_MAX = 3,
} SocketAddressKind;

typedef struct ChardevFile ChardevFile;

typedef struct ChardevFileList
{
    ChardevFile *value;
    struct ChardevFileList *next;
} ChardevFileList;

typedef struct ChardevHostdev ChardevHostdev;

typedef struct ChardevHostdevList
{
    ChardevHostdev *value;
    struct ChardevHostdevList *next;
} ChardevHostdevList;

typedef struct ChardevSocket ChardevSocket;

typedef struct ChardevSocketList
{
    ChardevSocket *value;
    struct ChardevSocketList *next;
} ChardevSocketList;

typedef struct ChardevDgram ChardevDgram;

typedef struct ChardevDgramList
{
    ChardevDgram *value;
    struct ChardevDgramList *next;
} ChardevDgramList;

typedef struct ChardevMux ChardevMux;

typedef struct ChardevMuxList
{
    ChardevMux *value;
    struct ChardevMuxList *next;
} ChardevMuxList;

typedef struct ChardevStdio ChardevStdio;

typedef struct ChardevStdioList
{
    ChardevStdio *value;
    struct ChardevStdioList *next;
} ChardevStdioList;

typedef struct ChardevSpiceChannel ChardevSpiceChannel;

typedef struct ChardevSpiceChannelList
{
    ChardevSpiceChannel *value;
    struct ChardevSpiceChannelList *next;
} ChardevSpiceChannelList;

typedef struct ChardevSpicePort ChardevSpicePort;

typedef struct ChardevSpicePortList
{
    ChardevSpicePort *value;
    struct ChardevSpicePortList *next;
} ChardevSpicePortList;

typedef struct ChardevVC ChardevVC;

typedef struct ChardevVCList
{
    ChardevVC *value;
    struct ChardevVCList *next;
} ChardevVCList;

typedef struct ChardevRingbuf ChardevRingbuf;

typedef struct ChardevRingbufList
{
    ChardevRingbuf *value;
    struct ChardevRingbufList *next;
} ChardevRingbufList;

typedef struct ChardevDummy ChardevDummy;

typedef struct ChardevDummyList
{
    ChardevDummy *value;
    struct ChardevDummyList *next;
} ChardevDummyList;

typedef struct ChardevBackend ChardevBackend;

typedef struct ChardevBackendList
{
    ChardevBackend *value;
    struct ChardevBackendList *next;
} ChardevBackendList;

extern const char *ChardevBackendKind_lookup[];
typedef enum ChardevBackendKind
{
    CHARDEV_BACKEND_KIND_FILE = 0,
    CHARDEV_BACKEND_KIND_SERIAL = 1,
    CHARDEV_BACKEND_KIND_PARALLEL = 2,
    CHARDEV_BACKEND_KIND_PIPE = 3,
    CHARDEV_BACKEND_KIND_SOCKET = 4,
    CHARDEV_BACKEND_KIND_DGRAM = 5,
    CHARDEV_BACKEND_KIND_PTY = 6,
    CHARDEV_BACKEND_KIND_NULL = 7,
    CHARDEV_BACKEND_KIND_MUX = 8,
    CHARDEV_BACKEND_KIND_MSMOUSE = 9,
    CHARDEV_BACKEND_KIND_BRAILLE = 10,
    CHARDEV_BACKEND_KIND_STDIO = 11,
    CHARDEV_BACKEND_KIND_CONSOLE = 12,
    CHARDEV_BACKEND_KIND_SPICEVMC = 13,
    CHARDEV_BACKEND_KIND_SPICEPORT = 14,
    CHARDEV_BACKEND_KIND_VC = 15,
    CHARDEV_BACKEND_KIND_MEMORY = 16,
    CHARDEV_BACKEND_KIND_MAX = 17,
} ChardevBackendKind;

typedef struct ChardevReturn ChardevReturn;

typedef struct ChardevReturnList
{
    ChardevReturn *value;
    struct ChardevReturnList *next;
} ChardevReturnList;

struct BlockdevSnapshot
{
    char * device;
    char * snapshot_file;
    bool has_format;
    char * format;
    bool has_mode;
    NewImageMode mode;
};

void qapi_free_BlockdevSnapshotList(BlockdevSnapshotList * obj);
void qapi_free_BlockdevSnapshot(BlockdevSnapshot * obj);

struct BlockdevMirror
{
    char * device;
    char * target;
    bool has_format;
    char * format;
    bool has_speed;
    int64_t speed;
    bool has_full;
    bool full;
    bool has_mode;
    NewImageMode mode;
};

void qapi_free_BlockdevMirrorList(BlockdevMirrorList * obj);
void qapi_free_BlockdevMirror(BlockdevMirror * obj);

struct BlockdevAction
{
    BlockdevActionKind kind;
    union {
        void *data;
        BlockdevSnapshot * blockdev_snapshot_sync;
        BlockdevMirror * __com_redhat_drive_mirror;
    };
};
void qapi_free_BlockdevActionList(BlockdevActionList * obj);
void qapi_free_BlockdevAction(BlockdevAction * obj);

struct ImageCheck
{
    char * filename;
    char * format;
    int64_t check_errors;
    bool has_image_end_offset;
    int64_t image_end_offset;
    bool has_corruptions;
    int64_t corruptions;
    bool has_leaks;
    int64_t leaks;
    bool has_corruptions_fixed;
    int64_t corruptions_fixed;
    bool has_leaks_fixed;
    int64_t leaks_fixed;
    bool has_total_clusters;
    int64_t total_clusters;
    bool has_allocated_clusters;
    int64_t allocated_clusters;
    bool has_fragmented_clusters;
    int64_t fragmented_clusters;
};

void qapi_free_ImageCheckList(ImageCheckList * obj);
void qapi_free_ImageCheck(ImageCheck * obj);

struct BlockDeviceMapEntry
{
    int64_t start;
    int64_t length;
    int64_t depth;
    bool zero;
    bool data;
    bool has_offset;
    int64_t offset;
};

void qapi_free_BlockDeviceMapEntryList(BlockDeviceMapEntryList * obj);
void qapi_free_BlockDeviceMapEntry(BlockDeviceMapEntry * obj);

struct EventInfo
{
    char * name;
};

void qapi_free_EventInfoList(EventInfoList * obj);
void qapi_free_EventInfo(EventInfo * obj);

struct String
{
    char * str;
};

void qapi_free_StringList(StringList * obj);
void qapi_free_String(String * obj);

struct InetSocketAddress
{
    char * host;
    char * port;
    bool has_to;
    uint16_t to;
    bool has_ipv4;
    bool ipv4;
    bool has_ipv6;
    bool ipv6;
};

void qapi_free_InetSocketAddressList(InetSocketAddressList * obj);
void qapi_free_InetSocketAddress(InetSocketAddress * obj);

struct UnixSocketAddress
{
    char * path;
};

void qapi_free_UnixSocketAddressList(UnixSocketAddressList * obj);
void qapi_free_UnixSocketAddress(UnixSocketAddress * obj);

struct SocketAddress
{
    SocketAddressKind kind;
    union {
        void *data;
        InetSocketAddress * inet;
        UnixSocketAddress * q_unix;
        String * fd;
    };
};
void qapi_free_SocketAddressList(SocketAddressList * obj);
void qapi_free_SocketAddress(SocketAddress * obj);

struct ChardevFile
{
    bool has_in;
    char * in;
    char * out;
};

void qapi_free_ChardevFileList(ChardevFileList * obj);
void qapi_free_ChardevFile(ChardevFile * obj);

struct ChardevHostdev
{
    char * device;
};

void qapi_free_ChardevHostdevList(ChardevHostdevList * obj);
void qapi_free_ChardevHostdev(ChardevHostdev * obj);

struct ChardevSocket
{
    SocketAddress * addr;
    bool has_server;
    bool server;
    bool has_wait;
    bool wait;
    bool has_nodelay;
    bool nodelay;
    bool has_telnet;
    bool telnet;
};

void qapi_free_ChardevSocketList(ChardevSocketList * obj);
void qapi_free_ChardevSocket(ChardevSocket * obj);

struct ChardevDgram
{
    SocketAddress * remote;
    bool has_local;
    SocketAddress * local;
};

void qapi_free_ChardevDgramList(ChardevDgramList * obj);
void qapi_free_ChardevDgram(ChardevDgram * obj);

struct ChardevMux
{
    char * chardev;
};

void qapi_free_ChardevMuxList(ChardevMuxList * obj);
void qapi_free_ChardevMux(ChardevMux * obj);

struct ChardevStdio
{
    bool has_signal;
    bool signal;
};

void qapi_free_ChardevStdioList(ChardevStdioList * obj);
void qapi_free_ChardevStdio(ChardevStdio * obj);

struct ChardevSpiceChannel
{
    char * type;
};

void qapi_free_ChardevSpiceChannelList(ChardevSpiceChannelList * obj);
void qapi_free_ChardevSpiceChannel(ChardevSpiceChannel * obj);

struct ChardevSpicePort
{
    char * fqdn;
};

void qapi_free_ChardevSpicePortList(ChardevSpicePortList * obj);
void qapi_free_ChardevSpicePort(ChardevSpicePort * obj);

struct ChardevVC
{
    bool has_width;
    int64_t width;
    bool has_height;
    int64_t height;
    bool has_cols;
    int64_t cols;
    bool has_rows;
    int64_t rows;
};

void qapi_free_ChardevVCList(ChardevVCList * obj);
void qapi_free_ChardevVC(ChardevVC * obj);

struct ChardevRingbuf
{
    bool has_size;
    int64_t size;
};

void qapi_free_ChardevRingbufList(ChardevRingbufList * obj);
void qapi_free_ChardevRingbuf(ChardevRingbuf * obj);

struct ChardevDummy
{
#ifdef _MSC_VER
    int dummy;
#endif
};

void qapi_free_ChardevDummyList(ChardevDummyList * obj);
void qapi_free_ChardevDummy(ChardevDummy * obj);

struct ChardevBackend
{
    ChardevBackendKind kind;
    union {
        void *data;
        ChardevFile * file;
        ChardevHostdev * serial;
        ChardevHostdev * parallel;
        ChardevHostdev * pipe;
        ChardevSocket * socket;
        ChardevDgram * dgram;
        ChardevDummy * pty;
        ChardevDummy * null;
        ChardevMux * mux;
        ChardevDummy * msmouse;
        ChardevDummy * braille;
        ChardevStdio * stdio;
        ChardevDummy * console;
        ChardevSpiceChannel * spicevmc;
        ChardevSpicePort * spiceport;
        ChardevVC * vc;
        ChardevRingbuf * memory;
    };
};
void qapi_free_ChardevBackendList(ChardevBackendList * obj);
void qapi_free_ChardevBackend(ChardevBackend * obj);

struct ChardevReturn
{
    bool has_pty;
    char * pty;
};

void qapi_free_ChardevReturnList(ChardevReturnList * obj);
void qapi_free_ChardevReturn(ChardevReturn * obj);

#endif
