/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT MODIFY */

/*
 * schema-defined QMP->QAPI command dispatch
 *
 * Copyright IBM, Corp. 2011
 *
 * Authors:
 *  Anthony Liguori   <aliguori@us.ibm.com>
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 *
 */

#include "qemu-objects.h"
#include "qapi/qmp-core.h"
#include "qapi/qapi-visit-core.h"
#include "qapi/qmp-output-visitor.h"
#include "qapi/qmp-input-visitor.h"
#include "qapi/qapi-dealloc-visitor.h"
#include "qga-qapi-types.h"
#include "qga-qapi-visit.h"

#include "qga-qmp-commands.h"

static void qmp_marshal_output_guest_sync_delimited(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_sync_delimited(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t id;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_sync_delimited(id, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_sync_delimited(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_sync(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_sync(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t id;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &id, "id", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_sync(id, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_sync(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &id, "id", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_input_guest_ping(QDict *args, QObject **ret, Error **errp)
{
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_ping(errp);

out:

    return;
}

static void qmp_marshal_output_guest_get_time(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_get_time(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_get_time(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_get_time(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_input_guest_set_time(QDict *args, QObject **ret, Error **errp)
{
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t time;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &time, "time", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_set_time(time, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &time, "time", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_info(GuestAgentInfo * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestAgentInfo(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestAgentInfo(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_info(QDict *args, QObject **ret, Error **errp)
{
    GuestAgentInfo * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_info(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_info(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_input_guest_shutdown(QDict *args, QObject **ret, Error **errp)
{
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_mode = false;
    char * mode = NULL;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_mode, "mode", errp);
    if (has_mode) {
        visit_type_str(v, &mode, "mode", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_shutdown(has_mode, mode, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_mode, "mode", NULL);
    if (has_mode) {
        visit_type_str(v, &mode, "mode", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_file_open(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_file_open(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    char * path = NULL;
    bool has_mode = false;
    char * mode = NULL;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_str(v, &path, "path", errp);
    visit_start_optional(v, &has_mode, "mode", errp);
    if (has_mode) {
        visit_type_str(v, &mode, "mode", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_file_open(path, has_mode, mode, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_file_open(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_str(v, &path, "path", NULL);
    visit_start_optional(v, &has_mode, "mode", NULL);
    if (has_mode) {
        visit_type_str(v, &mode, "mode", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_input_guest_file_close(QDict *args, QObject **ret, Error **errp)
{
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t handle;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &handle, "handle", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_file_close(handle, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &handle, "handle", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_file_read(GuestFileRead * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestFileRead(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestFileRead(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_file_read(QDict *args, QObject **ret, Error **errp)
{
    GuestFileRead * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t handle;
    bool has_count = false;
    int64_t count;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &handle, "handle", errp);
    visit_start_optional(v, &has_count, "count", errp);
    if (has_count) {
        visit_type_int(v, &count, "count", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_file_read(handle, has_count, count, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_file_read(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &handle, "handle", NULL);
    visit_start_optional(v, &has_count, "count", NULL);
    if (has_count) {
        visit_type_int(v, &count, "count", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_file_write(GuestFileWrite * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestFileWrite(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestFileWrite(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_file_write(QDict *args, QObject **ret, Error **errp)
{
    GuestFileWrite * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t handle;
    char * buf_b64 = NULL;
    bool has_count = false;
    int64_t count;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &handle, "handle", errp);
    visit_type_str(v, &buf_b64, "buf-b64", errp);
    visit_start_optional(v, &has_count, "count", errp);
    if (has_count) {
        visit_type_int(v, &count, "count", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_file_write(handle, buf_b64, has_count, count, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_file_write(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &handle, "handle", NULL);
    visit_type_str(v, &buf_b64, "buf-b64", NULL);
    visit_start_optional(v, &has_count, "count", NULL);
    if (has_count) {
        visit_type_int(v, &count, "count", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_file_seek(GuestFileSeek * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestFileSeek(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestFileSeek(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_file_seek(QDict *args, QObject **ret, Error **errp)
{
    GuestFileSeek * retval = NULL;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t handle;
    int64_t offset;
    int64_t whence;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &handle, "handle", errp);
    visit_type_int(v, &offset, "offset", errp);
    visit_type_int(v, &whence, "whence", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_file_seek(handle, offset, whence, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_file_seek(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &handle, "handle", NULL);
    visit_type_int(v, &offset, "offset", NULL);
    visit_type_int(v, &whence, "whence", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_input_guest_file_flush(QDict *args, QObject **ret, Error **errp)
{
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    int64_t handle;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_int(v, &handle, "handle", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_file_flush(handle, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &handle, "handle", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_output_guest_fsfreeze_status(GuestFsfreezeStatus ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestFsfreezeStatus(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestFsfreezeStatus(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_fsfreeze_status(QDict *args, QObject **ret, Error **errp)
{
    GuestFsfreezeStatus retval;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_fsfreeze_status(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_fsfreeze_status(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_output_guest_fsfreeze_freeze(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_fsfreeze_freeze(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_fsfreeze_freeze(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_fsfreeze_freeze(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_output_guest_fsfreeze_thaw(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_fsfreeze_thaw(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_fsfreeze_thaw(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_fsfreeze_thaw(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_input_guest_fstrim(QDict *args, QObject **ret, Error **errp)
{
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    bool has_minimum = false;
    int64_t minimum;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_start_optional(v, &has_minimum, "minimum", errp);
    if (has_minimum) {
        visit_type_int(v, &minimum, "minimum", errp);
    }
    visit_end_optional(v, errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_fstrim(has_minimum, minimum, errp);

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_start_optional(v, &has_minimum, "minimum", NULL);
    if (has_minimum) {
        visit_type_int(v, &minimum, "minimum", NULL);
    }
    visit_end_optional(v, NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

static void qmp_marshal_input_guest_suspend_disk(QDict *args, QObject **ret, Error **errp)
{
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_suspend_disk(errp);

out:

    return;
}

static void qmp_marshal_input_guest_suspend_ram(QDict *args, QObject **ret, Error **errp)
{
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_suspend_ram(errp);

out:

    return;
}

static void qmp_marshal_input_guest_suspend_hybrid(QDict *args, QObject **ret, Error **errp)
{
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    qmp_guest_suspend_hybrid(errp);

out:

    return;
}

static void qmp_marshal_output_guest_network_get_interfaces(GuestNetworkInterfaceList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestNetworkInterfaceList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestNetworkInterfaceList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_network_get_interfaces(QDict *args, QObject **ret, Error **errp)
{
    GuestNetworkInterfaceList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_network_get_interfaces(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_network_get_interfaces(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_output_guest_get_vcpus(GuestLogicalProcessorList * ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_GuestLogicalProcessorList(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestLogicalProcessorList(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_get_vcpus(QDict *args, QObject **ret, Error **errp)
{
    GuestLogicalProcessorList * retval = NULL;
    (void)args;
    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_get_vcpus(errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_get_vcpus(retval, ret, errp);
    }

out:

    return;
}

static void qmp_marshal_output_guest_set_vcpus(int64_t ret_in, QObject **ret_out, Error **errp)
{
    QapiDeallocVisitor *md = qapi_dealloc_visitor_new();
    QmpOutputVisitor *mo = qmp_output_visitor_new();
    Visitor *v;

    v = qmp_output_get_visitor(mo);
    visit_type_int(v, &ret_in, "unused", errp);
    if (!error_is_set(errp)) {
        *ret_out = qmp_output_get_qobject(mo);
    }
    qmp_output_visitor_cleanup(mo);
    v = qapi_dealloc_get_visitor(md);
    visit_type_int(v, &ret_in, "unused", NULL);
    qapi_dealloc_visitor_cleanup(md);
}

static void qmp_marshal_input_guest_set_vcpus(QDict *args, QObject **ret, Error **errp)
{
    int64_t retval;
    QmpInputVisitor *mi;
    QapiDeallocVisitor *md;
    Visitor *v;
    GuestLogicalProcessorList * vcpus = NULL;

    mi = qmp_input_visitor_new(QOBJECT(args));
    v = qmp_input_get_visitor(mi);
    visit_type_GuestLogicalProcessorList(v, &vcpus, "vcpus", errp);
    qmp_input_visitor_cleanup(mi);

    if (error_is_set(errp)) {
        goto out;
    }
    retval = qmp_guest_set_vcpus(vcpus, errp);
    if (!error_is_set(errp)) {
        qmp_marshal_output_guest_set_vcpus(retval, ret, errp);
    }

out:
    md = qapi_dealloc_visitor_new();
    v = qapi_dealloc_get_visitor(md);
    visit_type_GuestLogicalProcessorList(v, &vcpus, "vcpus", NULL);
    qapi_dealloc_visitor_cleanup(md);
    return;
}

#ifndef _MSC_VER
static
#endif
void qmp_init_marshal(void)
{
    qmp_register_command("guest-sync-delimited", qmp_marshal_input_guest_sync_delimited, QCO_NO_OPTIONS);
    qmp_register_command("guest-sync", qmp_marshal_input_guest_sync, QCO_NO_OPTIONS);
    qmp_register_command("guest-ping", qmp_marshal_input_guest_ping, QCO_NO_OPTIONS);
    qmp_register_command("guest-get-time", qmp_marshal_input_guest_get_time, QCO_NO_OPTIONS);
    qmp_register_command("guest-set-time", qmp_marshal_input_guest_set_time, QCO_NO_OPTIONS);
    qmp_register_command("guest-info", qmp_marshal_input_guest_info, QCO_NO_OPTIONS);
    qmp_register_command("guest-shutdown", qmp_marshal_input_guest_shutdown, QCO_NO_SUCCESS_RESP);
    qmp_register_command("guest-file-open", qmp_marshal_input_guest_file_open, QCO_NO_OPTIONS);
    qmp_register_command("guest-file-close", qmp_marshal_input_guest_file_close, QCO_NO_OPTIONS);
    qmp_register_command("guest-file-read", qmp_marshal_input_guest_file_read, QCO_NO_OPTIONS);
    qmp_register_command("guest-file-write", qmp_marshal_input_guest_file_write, QCO_NO_OPTIONS);
    qmp_register_command("guest-file-seek", qmp_marshal_input_guest_file_seek, QCO_NO_OPTIONS);
    qmp_register_command("guest-file-flush", qmp_marshal_input_guest_file_flush, QCO_NO_OPTIONS);
    qmp_register_command("guest-fsfreeze-status", qmp_marshal_input_guest_fsfreeze_status, QCO_NO_OPTIONS);
    qmp_register_command("guest-fsfreeze-freeze", qmp_marshal_input_guest_fsfreeze_freeze, QCO_NO_OPTIONS);
    qmp_register_command("guest-fsfreeze-thaw", qmp_marshal_input_guest_fsfreeze_thaw, QCO_NO_OPTIONS);
    qmp_register_command("guest-fstrim", qmp_marshal_input_guest_fstrim, QCO_NO_OPTIONS);
    qmp_register_command("guest-suspend-disk", qmp_marshal_input_guest_suspend_disk, QCO_NO_SUCCESS_RESP);
    qmp_register_command("guest-suspend-ram", qmp_marshal_input_guest_suspend_ram, QCO_NO_SUCCESS_RESP);
    qmp_register_command("guest-suspend-hybrid", qmp_marshal_input_guest_suspend_hybrid, QCO_NO_SUCCESS_RESP);
    qmp_register_command("guest-network-get-interfaces", qmp_marshal_input_guest_network_get_interfaces, QCO_NO_OPTIONS);
    qmp_register_command("guest-get-vcpus", qmp_marshal_input_guest_get_vcpus, QCO_NO_OPTIONS);
    qmp_register_command("guest-set-vcpus", qmp_marshal_input_guest_set_vcpus, QCO_NO_OPTIONS);
}

#ifndef _MSC_VER
qapi_init(qmp_init_marshal);
#endif
