"""
provides all the predefined variables for engine upgrade 3.0 -> 3.1
"""

import basedefs
import os

ANSWER_FILE_TEMPLATE = """
[general]
OVERRIDE_IPTABLES=no
HTTP_PORT=8080
HTTPS_PORT=8443
MAC_RANGE=%s
HOST_FQDN=%s
AUTH_PASS=%s
DB_PASS=%s
ORG_NAME=localorg
DC_TYPE=NFS
CONFIG_NFS=no
NFS_MP=
ISO_DOMAIN_NAME=localiso
"""

ANSWER_FILE = "/tmp/answer"

# Full path of the JBoss 5 base installation directory:
JBOSS_5_PATH = os.path.join(basedefs.DIR_VAR_LIB, "jbossas")

# Name and directory of the JBoss 5 profile used by the engine:
JBOSS_5_PROFILE_NAME = "rhevm-slimmed"
JBOSS_5_PROFILE_PATH = os.path.join(JBOSS_5_PATH, "server", JBOSS_5_PROFILE_NAME)

DIR_BASE_CONF = "/etc/%s" % basedefs.ENGINE_RPM_NAME
DIR_RHEVM_PKI="/etc/pki/rhevm"
DIR_CONFIG="%s/rhevm/conf" % basedefs.DIR_USR_SHARE
ENGINE_SERVICE_NAME_30="jbossas"
ETL_SERVICE_NAME = "rhevm-etl"
NOTIFIER_SERVICE_NAME = "rhevm-notifierd"
FILE_JBOSS_HTTP_PARAMS = DIR_BASE_CONF + "/web-conf.js"
FILE_RHEVM_CONFIG_BIN="/usr/bin/rhevm-config"
FILE_RHEVM_CONFIG_PROPS="rhevm-config-install.properties"
FILE_RHEVM_EXTENDED_CONF = os.path.join(DIR_CONFIG, FILE_RHEVM_CONFIG_PROPS)

OLD_VERSION_FILES = "/var/rhevm-backup.tar.bz2"
OLD_KRB5 = "/etc/jbossas/%s/krb5.conf" % JBOSS_5_PROFILE_NAME
JS_WAR_PATH = os.path.join(JBOSS_5_PROFILE_PATH, "deploy", "rhevm-reports.war")
REPORTS_DB_NAME="rhevmreports"
UPGRADE_FLAG = "/etc/ovirt-engine/reports-upgrade"

# Full path of the server.xml file inside the profile used by the
# engine:
JBOSS_5_SERVER_XML_PATH = os.path.join(JBOSS_5_PROFILE_PATH, "deploy", "jbossweb.sar", "server.xml")
