using System;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	/// <summary>
	/// Represents an implementor of a Spice. That way we have a bridge
	/// between Console model and concrete Spice accessor.
	/// In case of WPF there will be direct Spice ActiveX instantiation,
	/// while Web implementor of Spice will generate corresponding HTML.
	/// </summary>
	public interface ISpice
	{
		//event EventHandler<ErrorCodeEventArgs> Disconnected;
		//event EventHandler<SpiceMenuItemEventArgs> MenuItemSelected;

		Event DisconnectedEvent { get; }
		Event MenuItemSelectedEvent { get; }
		Event UsbAutoShareChangedEvent { get; }

		Version CurrentVersion { get; }
		bool IsInstalled { get; }

		Version DesiredVersion { get; set; }
		int Port { get; set; }
		string Host { get; set; }
		bool FullScreen { get; set; }
		string Password { get; set; }
		int NumberOfMonitors { get; set; }
		int UsbListenPort { get; set; }
		bool AdminConsole { get; set; }
		string GuestHostName { get; set; }
		int SecurePort { get; set; }
		string SslChanels { get; set; }
		string CipherSuite { get; set; }
		string HostSubject { get; set; }
		string TrustStore { get; set; }
		string Title { get; set; }
		string HotKey { get; set; }
		string[] LocalizedStrings { get; set; }
		string Menu { get; set; }

		string GuestID { get; set; }
		bool NoTaskMgrExecution { get; set; }
		bool SendCtrlAltDelete { get; set; }
		bool UsbAutoShare { get; set; }
		string UsbFilter { get; set; }

		void Connect();
		void Install();
	}
}
