using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class NfsStorageModel : Model, IStorageModel
	{
		#region Events

		public static EventDefinition PathChangedEventDefinition;
		public Event PathChangedEvent { get; private set; }

		#endregion

		#region Commands

		public UICommand UpdateCommand { get; private set; }

		#endregion

		#region Properties

		public StorageModel Container { get; set; }
		public StorageDomainType Role { get; set; }

		public EntityModel Path { get; set; }

		#endregion

		static NfsStorageModel()
		{
			PathChangedEventDefinition = new EventDefinition("PathChanged", typeof(NfsStorageModel));
		}

		public NfsStorageModel()
		{
			PathChangedEvent = new Event(PathChangedEventDefinition);

			UpdateCommand = new UICommand("Update", this);

			Path = new EntityModel();
			Path.EntityChangedEvent.addListener(this);
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(EntityModel.EntityChangedEventDefinition) && sender == Path)
			{
				Path_EntityChanged();
			}
		}

		private void Path_EntityChanged()
		{
			PathChangedEvent.raise(this, EventArgs.Empty);
		}

		public bool Validate()
		{
			Path.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(),
					new RegexValidation
					{
						Expression = DataProvider.GetLinuxMountPointRegex(), 
						Message = "NFS mount path is illegal, please use [IP:/path or FQDN:/path] convention."
					}
				});


			return Path.IsValid;
		}

		public StorageType Type
		{
			get { return StorageType.NFS; }
		}
	}
}
