using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class InstallModel : Model
	{
		#region Properties

		public EntityModel RootPassword { get; private set; }
		public EntityModel HostVersion { get; private set; }
		public ListModel oVirtISO { get; private set; }
		public EntityModel OverrideIpTables { get; private set; }

		#endregion

		public InstallModel()
		{
			RootPassword = new EntityModel();
			HostVersion = new EntityModel();
			oVirtISO = new ListModel();
			OverrideIpTables = new EntityModel { Entity = false };
		}

		internal bool Validate(bool isOVirt)
		{
			oVirtISO.IsValid = true;
			RootPassword.IsValid = true;

			if (isOVirt)
			{
				oVirtISO.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}
			else
			{
				RootPassword.ValidateEntity(new IValidation[] { new NotEmptyValidation() });
			}

			return RootPassword.IsValid
				   && oVirtISO.IsValid;
		}
	}
}
