﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using System.Text;

namespace org.ovirt.engine.ui.uicompat
{
	public class EventProvidingCollection<T> : ObservableCollection<T>, IProvideCollectionChangedEvent
	{
		#region Events

		public Event CollectionChangedEvent { get; private set; }

		#endregion

		public EventProvidingCollection()
		{
			CollectionChangedEvent = new Event(ProvideCollectionChangedEvent.Definition);
		}

		protected override void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
		{
			base.OnCollectionChanged(e);
			CollectionChangedEvent.raise(this, e);
		}
	}
}
