package org.ovirt.engine.core.bll;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

import org.ovirt.engine.core.common.action.VdsActionParameters;
import org.ovirt.engine.core.common.businessentities.vds_spm_id_map;
import org.ovirt.engine.core.compat.Guid;
import org.ovirt.engine.core.dal.dbbroker.DbFacade;
import org.ovirt.engine.core.utils.linq.Function;
import org.ovirt.engine.core.utils.linq.LinqUtils;
import org.ovirt.engine.core.utils.transaction.TransactionMethod;
import org.ovirt.engine.core.utils.transaction.TransactionSupport;

//VB & C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
@NonTransactiveCommandAttribute
public class AddVdsSpmIdCommand<T extends VdsActionParameters> extends VdsCommand<T> {


    private static ReentrantLock lock = new ReentrantLock();
    /**
     * Constructor for command creation when compensation is applied on startup
     *
     * @param commandId
     */
    public AddVdsSpmIdCommand(Guid commandId) {
        super(commandId);
    }

    public AddVdsSpmIdCommand(T parametars) {
        super(parametars);
    }

    @Override
    protected boolean canDoAction() {
        // check if vds already has vds spm id and storage pool exists
        return !Guid.Empty.equals(getVds().getstorage_pool_id())
                && DbFacade.getInstance().getVdsSpmIdMapDAO().get(getVdsId()) == null;
    }

    @Override
    protected void executeCommand() {
        // according to shaharf the first id is 1
        // LINQ 31899
        // Iterable<Integer> map = null; //
        // DbFacade.Instance.Getvds_spm_id_mapByStoragePoolId(Vds.storage_pool_id).OrderBy(a
        // => a.vds_spm_id).Select(a => a.vds_spm_id);
        lock.lock();
        try {
            List<vds_spm_id_map> list = DbFacade.getInstance().getVdsSpmIdMapDAO().getAll(
                    getVds().getstorage_pool_id());
            final List<Integer> map = LinqUtils.foreach(list, new Function<vds_spm_id_map, Integer>() {
                @Override
                public Integer eval(vds_spm_id_map vds_spm_id_map) {
                    return vds_spm_id_map.getvds_spm_id();
                }
            });
            TransactionSupport.executeInNewTransaction(new TransactionMethod<Void>() {

                @Override
                public Void runInTransaction() {
                    int selectedId = 1;
                    Collections.sort(map);
                    for (int id : map) {
                        if (selectedId == id) {
                            selectedId++;
                        } else {
                            break;
                        }
                    }
                    vds_spm_id_map newMap = new vds_spm_id_map(getVds().getstorage_pool_id(), getVdsId(), selectedId);
                    DbFacade.getInstance().getVdsSpmIdMapDAO().save(newMap);
                    if (getParameters().isCompensationEnabled()) {
                        getCompensationContext().snapshotNewEntity(newMap);
                        getCompensationContext().stateChanged();
                    }
                    return null;
                }
            });
        }
        finally {
            lock.unlock();
        }

        setSucceeded(true);
    }
}
