/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.StreamError;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerException
extends SQLException {
    static final String EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH = "08001";
    static final String EXCEPTION_XOPEN_CONNECTION_DOES_NOT_EXIST = "08003";
    static final String EXCEPTION_XOPEN_CONNECTION_FAILURE = "08006";
    static final int LOGON_FAILED = 18456;
    static final int PASSWORD_EXPIRED = 18488;
    static Logger exLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerException");
    static final int DRIVER_ERROR_NONE = 0;
    static final int DRIVER_ERROR_FROM_DATABASE = 2;
    static final int DRIVER_ERROR_IO_FAILED = 3;
    static final int DRIVER_ERROR_INVALID_TDS = 4;
    static final int DRIVER_ERROR_SSL_FAILED = 5;
    static final int DRIVER_ERROR_UNSUPPORTED_CONFIG = 6;
    private int driverErrorCode = 0;

    final int getDriverErrorCode() {
        return this.driverErrorCode;
    }

    final void setDriverErrorCode(int n) {
        this.driverErrorCode = n;
    }

    private void logException(Object object, String string, boolean bl) {
        String string2 = "";
        if (object != null) {
            string2 = object.toString();
        }
        if (exLogger.isLoggable(Level.FINE)) {
            exLogger.fine("*** SQLException:" + string2 + " " + this.toString() + " " + string);
        }
        if (bl && exLogger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuilder.append(stackTraceElementArray[i].toString());
            }
            exLogger.fine(stringBuilder.toString());
        }
    }

    static String getErrString(String string) {
        return SQLServerResource.getResource(string);
    }

    SQLServerException(String string, SQLState sQLState, DriverError driverError, Throwable throwable) {
        this(string, sQLState.getSQLStateCode(), driverError.getErrorCode(), throwable);
    }

    SQLServerException(String string, String string2, int n, Throwable throwable) {
        super(string, string2, n);
        this.logException(null, string, true);
        this.initCause(throwable);
    }

    SQLServerException(Object object, String string, String string2, int n, boolean bl) {
        super(string, string2, n);
        this.logException(object, string, bl);
    }

    SQLServerException(Object object, String string, String string2, StreamError streamError, boolean bl) {
        super(string, string2, streamError.getErrorNumber());
        string = "Msg " + streamError.getErrorNumber() + ", Level " + streamError.getErrorSeverity() + ", State " + streamError.getErrorState() + ", " + string;
        this.logException(object, string, bl);
    }

    static void makeFromDriverError(SQLServerConnection sQLServerConnection, Object object, String string, String string2, boolean bl) throws SQLServerException {
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        if (sQLServerConnection == null || !sQLServerConnection.xopenStates) {
            string3 = SQLServerException.mapFromXopen(string2);
        }
        SQLServerException sQLServerException = new SQLServerException(object, string, string3, 0, bl);
        if (null != string2 && string2.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE) && null != sQLServerConnection) {
            sQLServerConnection.notifyPooledConnection(sQLServerException);
            sQLServerConnection.close();
        }
        throw sQLServerException;
    }

    static void makeFromDatabaseError(SQLServerConnection sQLServerConnection, Object object, String string, StreamError streamError, boolean bl) throws SQLServerException {
        String string2 = SQLServerException.generateStateCode(sQLServerConnection, streamError.getErrorNumber(), streamError.getErrorState());
        SQLServerException sQLServerException = new SQLServerException(object, string, string2, streamError, bl);
        sQLServerException.setDriverErrorCode(2);
        if (streamError.getErrorSeverity() >= 20 && null != sQLServerConnection) {
            sQLServerConnection.notifyPooledConnection(sQLServerException);
            sQLServerConnection.close();
        }
        throw sQLServerException;
    }

    static String mapFromXopen(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("07009")) {
            return "S1093";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH)) {
            return "08S01";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE)) {
            return "08S01";
        }
        return "";
    }

    static String generateStateCode(SQLServerConnection sQLServerConnection, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = sQLServerConnection != null && sQLServerConnection.xopenStates;
        if (bl) {
            switch (n) {
                case 4060: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 18456: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 2714: {
                    return "42S01";
                }
                case 208: {
                    return "42S02";
                }
                case 207: {
                    return "42S22";
                }
            }
            return "42000";
        }
        switch (n) {
            case 8152: {
                return "22001";
            }
            case 515: 
            case 547: {
                return "23000";
            }
            case 2714: {
                return "S0001";
            }
            case 208: {
                return "S0002";
            }
            case 1205: {
                return "40001";
            }
            case 2627: {
                return "23000";
            }
        }
        return "S000" + n2;
    }
}

