using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models.vms;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;

namespace UI.WPFClient
{
	public partial class VmGuideView
	{
		private WindowView view;

		public new VmGuideModel Model
		{
			get { return (VmGuideModel)base.Model; }
			set { base.Model = value; }
		}

		public VmGuideView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.Window is DiskModel)
				{
					view = TypeResolver.Instance.Resolve<DiskView>();
				}
				else if (Model.Window is VmInterfaceModel)
				{
					view = TypeResolver.Instance.Resolve<VmInterfaceView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}
	}
}
