using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models;
using VdcCommon.BusinessEntities;
using System.Collections;

namespace UI.WPFClient
{
	public partial class ConfirmationView
	{
		public new ConfirmationModel Model
		{
			get { return (ConfirmationModel)base.Model; }
			set { base.Model = value; }
		}

		public ConfirmationView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			viewer.Document = Generate(Model, @"{0}");
		}

		public static FlowDocument Generate(ConfirmationModel model, string messageFormat)
		{
			var doc =
				new FlowDocument
				{
					TextAlignment = TextAlignment.Left,
					PagePadding = new Thickness(0),
					FontFamily = new FontFamily("Verdana"),
					FontSize = 12
				};

			doc.Blocks.Add(
				new Paragraph(
					new Run(String.Format(messageFormat, model.Message))
				)
			);

			if (model.Items != null)
			{
				var p = new Paragraph();
				foreach (var item in model.Items)
				{
					p.Inlines.Add(new Run("- " + item));
					p.Inlines.Add(new LineBreak());
				}
				doc.Blocks.Add(p);
			}

			return doc;
		}
	}
}
