using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmInterfaceModel : Model
	{
		#region Properties

		public bool IsNew { get; set; }

		public EntityModel Name { get; private set; }
		public ListModel Network { get; private set; }
		public ListModel NicType { get; private set; }
		public EntityModel MAC { get; private set; }

		#endregion

		public VmInterfaceModel()
		{
			Name = new EntityModel();
			Network = new ListModel();
			NicType = new ListModel();
			MAC = new EntityModel();
			MAC.PropertyChangedEvent.addListener(this);
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (sender == MAC)
			{
				MAC_PropertyChanged((PropertyChangedEventArgs)args);
			}
		}

		void MAC_PropertyChanged(PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "IsChangeAllowed" && !MAC.IsChangable)
			{
				MAC.IsValid = true;
			}
		}

		internal bool Validate()
		{
			Name.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(), 
					new RegexValidation
					{
						Expression = @"^\w+$", 
						Message = "Name must contain alphanumeric characters only."
					}
				});

			Network.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			NicType.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			MAC.IsValid = true;
			if (MAC.IsChangable)
			{
				MAC.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new MacAddressValidation() });
			}

			return Name.IsValid
				   && Network.IsValid
				   && NicType.IsValid
				   && MAC.IsValid;
		}
	}
}
