using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class RdpConsoleModel : ConsoleModel
	{
		public static EventDefinition RdpDisconnectedEventDefinition = new EventDefinition("RdpDisconnected", typeof(RdpConsoleModel));
		
		public IRdp rdp { get; private set; }

		public RdpConsoleModel()
		{
			Title = "RDP";

			rdp = (IRdp)TypeResolver.Instance.Resolve(typeof(IRdp));
		}

		protected override void Connect()
		{
			if (Entity != null)
			{
				Logger.Debug("Connecting to RDP console...");

				rdp.Address = Entity.vm_host.Split(' ')[0];
				rdp.GuestID = Entity.vm_guid.ToString();

				//Subscribe to disconnect event
				if (rdp.DisconnectedEvent != null)
				{
					rdp.DisconnectedEvent.addListener(this);
				}

				//Try to connect.
				try
				{
					rdp.Connect();
					UpdateActionAvailability();
				}
				catch (Exception ex)
				{
					Logger.Error("Exception on RDP connect", ex);
				}
			}
		}

		protected override void UpdateActionAvailability()
		{
			base.UpdateActionAvailability();

			ConnectCommand.IsExecutionAllowed = Entity != null
				&& (Entity.status == VMStatus.Up || Entity.status == VMStatus.PoweringDown)
				&& DataProvider.IsWindowsOsType(Entity.vm_os);
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (rdp.DisconnectedEvent != null && ev.Equals(rdp.DisconnectedEvent))
			{
				Rdp_Disconnected(sender, (ErrorCodeEventArgs)args);
			}
		}

		private void Rdp_Disconnected(object sender, ErrorCodeEventArgs e)
		{
			rdp.DisconnectedEvent.removeListener(this);

			if (e.ErrorCode > 100)
			{
				ErrorEvent.raise(this, e);
			}
		}
	}
}
