using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;
using System.Collections;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class UserVmModel : Model
	{
		#region Properties

		public virtual bool IsNew { get; set; }

		public VmType VmType { get; set; }


		bool isWindowsOS;
		public bool IsWindowsOS
		{
			get { return isWindowsOS; }
			set
			{
				if (isWindowsOS != value)
				{
					isWindowsOS = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsWindowsOS"));
				}
			}
		}


		bool isLinux_Unassign_UnknownOS;
		public bool IsLinux_Unassign_UnknownOS
		{
			get { return isLinux_Unassign_UnknownOS; }
			set
			{
				if (isLinux_Unassign_UnknownOS != value)
				{
					isLinux_Unassign_UnknownOS = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsLinux_Unassign_UnknownOS"));
				}
			}
		}

		bool isBlankTemplate;
		public bool IsBlankTemplate
		{
			get { return isBlankTemplate; }
			set
			{
				if (isBlankTemplate != value)
				{
					isBlankTemplate = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsBlankTemplate"));
				}
			}
		}

		private string cpuNotification;
		public string CPUNotification
		{
			get { return cpuNotification; }
			set
			{
				if (cpuNotification != value)
				{
					cpuNotification = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CPUNotification"));
				}
			}
		}
		public bool isCPUsAmountValid;
		public bool IsCPUsAmountValid
		{
			get { return isCPUsAmountValid; }
			set
			{
				if (isCPUsAmountValid != value)
				{
					isCPUsAmountValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCPUsAmountValid"));
				}
			}
		}

		bool isGeneralTabValid;
		public bool IsGeneralTabValid
		{
			get { return isGeneralTabValid; }
			set
			{
				if (isGeneralTabValid != value)
				{
					isGeneralTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsGeneralTabValid"));
				}
			}
		}

		bool isFirstRunTabValid;
		public bool IsFirstRunTabValid
		{
			get { return isFirstRunTabValid; }
			set
			{
				if (isFirstRunTabValid != value)
				{
					isFirstRunTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsFirstRunTabValid"));
				}
			}
		}

		bool isDisplayTabValid;
		public bool IsDisplayTabValid
		{
			get { return isDisplayTabValid; }
			set
			{
				if (isDisplayTabValid != value)
				{
					isDisplayTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsDisplayTabValid"));
				}
			}
		}

		bool isAllocationTabValid;
		public bool IsAllocationTabValid
		{
			get { return isAllocationTabValid; }
			set
			{
				if (isAllocationTabValid != value)
				{
					isAllocationTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsAllocationTabValid"));
				}
			}
		}

		bool isHostTabValid;
		public bool IsHostTabValid
		{
			get { return isHostTabValid; }
			set
			{
				if (isHostTabValid != value)
				{
					isHostTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHostTabValid"));
				}
			}
		}

		bool isBootSequenceTabValid;
		public bool IsBootSequenceTabValid
		{
			get { return isBootSequenceTabValid; }
			set
			{
				if (isBootSequenceTabValid != value)
				{
					isBootSequenceTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsBootSequenceTabValid"));
				}
			}
		}

		bool isCustomPropertiesTabValid;
		public bool IsCustomPropertiesTabValid
		{
			get { return isCustomPropertiesTabValid; }
			set
			{
				if (isCustomPropertiesTabValid != value)
				{
					isCustomPropertiesTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCustomPropertiesTabValid"));
				}
			}
		}

		public ListModel DataCenter { get; private set; }
		public ListModel StorageDomain { get; private set; }
		public ListModel Template { get; private set; }
		public EntityModel Name { get; private set; }
		public ListModel OSType { get; private set; }
		public ListModel NumOfMonitors { get; private set; }
		public EntityModel Description { get; private set; }
		public EntityModel Domain { get; private set; }
		public EntityModel MemSize { get; private set; }
		public EntityModel MinAllocatedMemory { get; private set; }
		public ListModel Cluster { get; private set; }
		public ListModel UsbPolicy { get; private set; }
		public ListModel TimeZone { get; private set; }

		public RangeEntityModel NumOfSockets { get; private set; }
		public RangeEntityModel TotalCPUCores { get; private set; }

		public ListModel DefaultHost { get; private set; }
		public EntityModel IsStateless { get; private set; }
		public ListModel DisplayProtocol { get; private set; }
		public ListModel Provisioning { get; private set; }
		public ListModel Priority { get; private set; }
		public EntityModel IsHighlyAvailable { get; private set; }
		public ListModel FirstBootDevice { get; private set; }
		public ListModel SecondBootDevice { get; private set; }
		public ListModel CdImage { get; private set; }

		public EntityModel Initrd_path { get; private set; }
		public EntityModel Kernel_path { get; private set; }
		public EntityModel Kernel_parameters { get; private set; }

		public EntityModel CustomProperties { get; private set; }
		public List<string> CustomPropertiesKeysList { get; set; }

		public EntityModel IsAutoAssign { get; set; }
		public EntityModel RunVMOnSpecificHost { get; set; }
		public EntityModel DontMigrateVM { get; set; }

		public EntityModel IsTemplatePublic { get; private set; }

		public string IsoPath { get; set; }

		public bool IsFirstRun { get; set; }

		private IList<DiskModel> disks;
		public IList<DiskModel> Disks
		{
			get { return disks; }
			set
			{
				if (disks != value)
				{
					disks = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Disks"));
				}
			}
		}

		private bool isDisksAvailable;
		public bool IsDisksAvailable
		{
			get { return isDisksAvailable; }
			set
			{
				if (isDisksAvailable != value)
				{
					isDisksAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsDisksAvailable"));
				}
			}
		}

		private bool isCustomPropertiesAvailable;
		public bool IsCustomPropertiesAvailable
		{
			get { return isCustomPropertiesAvailable; }
			set
			{
				if (isCustomPropertiesAvailable != value)
				{
					isCustomPropertiesAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCustomPropertiesAvailable"));

					if (value == false)
					{
						CustomProperties.Entity = String.Empty;
					}
				}
			}
		}

		private bool isHostAvailable;
		public bool IsHostAvailable
		{
			get { return isHostAvailable; }
			set
			{
				if (isHostAvailable != value)
				{
					isHostAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHostAvailable"));
				}
			}
		}

		#endregion

		private int _minMemSize = 1;
		public int _MinMemSize { get { return _minMemSize; } set { _minMemSize = value; } }
		private int _maxMemSize32 = 262144;
		private int _maxMemSize64 = 262144;
		private int _maxCpus = 0;
		public int _MaxCpus { get { return _maxCpus; } set { _maxCpus = value; } }
		private int _maxCpusPerSocket = 0;
		public int _MaxCpusPerSocket { get { return _maxCpusPerSocket; } set { _maxCpusPerSocket = value; } }
		private Guid dataCenterId;

		#region Const

		public const int WINDOWS_VM_NAME_MAX_LIMIT = 15;
		public const int NON_WINDOWS_VM_NAME_MAX_LIMIT = 64;

		#endregion Const

		public UserVmModel()
		{
			DataProvider.GetVolumeTypeList();

			DataCenter = new ListModel();
			DataCenter.SelectedItemChangedEvent.addListener(this);

			StorageDomain = new ListModel();

			Template = new ListModel();
			Template.SelectedItemChangedEvent.addListener(this);

			Name = new EntityModel();
			NumOfMonitors = new ListModel();
			Description = new EntityModel();
			Domain = new EntityModel();
			MemSize = new EntityModel();
			MemSize.EntityChangedEvent.addListener(this);
			MinAllocatedMemory = new EntityModel();

			Cluster = new ListModel();
			Cluster.SelectedItemChangedEvent.addListener(this);

			UsbPolicy = new ListModel();

			TimeZone = new ListModel();
			TimeZone.SelectedItemChangedEvent.addListener(this);

			NumOfSockets = new RangeEntityModel();
			NumOfSockets.EntityChangedEvent.addListener(this);

			TotalCPUCores = new RangeEntityModel();

			DefaultHost = new ListModel();
			DefaultHost.SelectedItemChangedEvent.addListener(this);

			IsStateless = new EntityModel();

			CdImage = new ListModel();

			IsHighlyAvailable = new EntityModel();

			DontMigrateVM = new EntityModel();

			RunVMOnSpecificHost = new EntityModel();
			RunVMOnSpecificHost.EntityChangedEvent.addListener(this);

			IsAutoAssign = new EntityModel();
			IsAutoAssign.EntityChangedEvent.addListener(this);

			IsTemplatePublic = new EntityModel();

			Kernel_parameters = new EntityModel();
			Kernel_path = new EntityModel();
			Initrd_path = new EntityModel();

			CustomProperties = new EntityModel();

			OSType = new ListModel();
			OSType.SelectedItemChangedEvent.addListener(this);

			DisplayProtocol = new ListModel();

			FirstBootDevice = new ListModel();
			FirstBootDevice.SelectedItemChangedEvent.addListener(this);

			SecondBootDevice = new ListModel();

			Provisioning = new ListModel();

			IsGeneralTabValid = IsFirstRunTabValid = IsDisplayTabValid = IsAllocationTabValid = IsBootSequenceTabValid = IsCustomPropertiesTabValid = IsHostTabValid = true;
			Provisioning.SelectedItemChangedEvent.addListener(this);

			Priority = new ListModel();
		}

		public override void Initialize()
		{
			base.Initialize();


			MemSize.Entity = 256;
			MinAllocatedMemory.Entity = 256;
			UsbPolicy.Items = DataProvider.GetUsbPolicyList();
			IsStateless.Entity = false;

			CdImage.IsChangable = false;

			IsHighlyAvailable.Entity = false;
			DontMigrateVM.Entity = false;

			RunVMOnSpecificHost.Entity = false;
			RunVMOnSpecificHost.IsChangable = false;

			IsAutoAssign.Entity = true;
			IsTemplatePublic.Entity = false;

			OSType.Items = DataProvider.GetOSList();
			OSType.SelectedItem = VmOsType.Unassigned;

			//Display protocols.
			List<EntityModel> displayProtocolOptions = new List<EntityModel>();

			EntityModel spiceProtocol = new EntityModel();
			spiceProtocol.Title = "Spice";
			spiceProtocol.Entity = DisplayType.qxl;

			EntityModel vncProtocol = new EntityModel();
			vncProtocol.Title = "VNC";
			vncProtocol.Entity = DisplayType.vnc;

			displayProtocolOptions.Add(spiceProtocol);
			displayProtocolOptions.Add(vncProtocol);
			DisplayProtocol.Items = displayProtocolOptions;

			DisplayProtocol.SelectedItemChangedEvent.addListener(this);
			if (VmType == VmType.Desktop)
			{
				DisplayProtocol.SelectedItem = spiceProtocol;
			}


			//Boot devices.
			EntityModel hardDiskOption =
				new EntityModel
				{
					Title = "Hard Disk",
					Entity = BootSequence.C
				};

			List<EntityModel> firstBootDeviceItems = new List<EntityModel>();
			firstBootDeviceItems.Add(hardDiskOption);
			firstBootDeviceItems.Add(
				new EntityModel
				{
					Title = "CD-ROM",
					Entity = BootSequence.D
				});
			firstBootDeviceItems.Add(
				new EntityModel
				{
					Title = "Network (PXE)",
					Entity = BootSequence.N
				});
			FirstBootDevice.Items = firstBootDeviceItems;
			FirstBootDevice.SelectedItem = hardDiskOption;


			//Provisioning
			List<EntityModel> provisioningItems = new List<EntityModel>();
			provisioningItems.Add(
				new EntityModel
				{
					Title = "Thin",
					Entity = false
				});
			provisioningItems.Add(
				new EntityModel
				{
					Title = "Clone",
					Entity = true
				});
			Provisioning.Items = provisioningItems;
			Provisioning.SelectedItem = provisioningItems[0];


			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
											{
												UserVmModel userVmModel = (UserVmModel)model;
												int maxPriority = (int)result;

												EntityModel lowOption =
													new EntityModel
													{
														Title = "Low",
														Entity = 1
													};

												List<EntityModel> priorityItems = new List<EntityModel>();
												priorityItems.Add(lowOption);
												priorityItems.Add(
													new EntityModel
													{
														Title = "Medium",
														Entity = maxPriority / 2
													});
												priorityItems.Add(
													new EntityModel
													{
														Title = "High",
														Entity = maxPriority
													});

												userVmModel.Priority.Items = priorityItems;
												userVmModel.Priority.SelectedItem = lowOption;
											};//END_DELEGATE
			AsyncDataProvider.GetMaxVmPriority(_asyncQuery);
			_asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
										  {
											  UserVmModel userVmModel = (UserVmModel)model;
											  string oldSelectedItem = null;
											  if (userVmModel.TimeZone.SelectedItem != null)
											  {
												  oldSelectedItem = ((KeyValuePair<string, string>)userVmModel.TimeZone.SelectedItem).Key;
											  }

				userVmModel.TimeZone.Items = ((Dictionary<string, string>)(valueObjectEnumerableMap)result).entrySet();

											  userVmModel.TimeZone.SelectedItem = !String.IsNullOrEmpty(oldSelectedItem) ?
													Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)userVmModel.TimeZone.Items, new Linq.TimeZonePredicate(oldSelectedItem)) :
													Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)userVmModel.TimeZone.Items);
										  };//END_DELEGATE
			AsyncDataProvider.GetTimeZoneList(_asyncQuery);
			_asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
			{
						UserVmModel userVmModel = (UserVmModel)model;
						List<storage_pool> list = new List<storage_pool>();
				foreach (storage_pool a in (List<storage_pool>)(valueObjectEnumerableList)result)
						{
							if (a.status == StoragePoolStatus.Up)
							{
								list.Add(a);
							}
						}
						userVmModel.DataCenter.Items = list;

			};//END_DELEGATE
			AsyncDataProvider.GetDataCenterList(_asyncQuery);
			_asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
			{
				UserVmModel userVmModel = (UserVmModel)model;
				userVmModel._MinMemSize = (int)result;

			};//END_DELEGATE
			AsyncDataProvider.GetMinimalVmMemSize(_asyncQuery);
			SetGUIByVMType();
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(EntityModel.EntityChangedEventDefinition))
			{
				if (sender == NumOfSockets)
				{
					NumOfSockets_EntityChanged();
				}
				else if (sender == IsAutoAssign)
				{
					if ((bool)IsAutoAssign.Entity)
					{
						RunVMOnSpecificHost.Entity = false;
						RunVMOnSpecificHost.IsChangable = false;
						DefaultHost.IsChangable = false;
					}
					else
					{
						RunVMOnSpecificHost.IsChangable = true;
						DefaultHost.IsChangable = true;
					}
				}
				else if (sender == RunVMOnSpecificHost)
				{
					if ((bool)RunVMOnSpecificHost.Entity)
					{
						DontMigrateVM.Entity = true;
						DontMigrateVM.IsChangable = false;
					}
					else
					{
						DontMigrateVM.IsChangable = true;
					}
				}
				else if (sender == MemSize)
				{
					UpdateMinAllocatedMemory(true);
				}
			}

			if (ev.Equals(ListModel.SelectedItemChangedEventDefinition))
			{
				if (sender == DataCenter)
				{
					DataCenter_SelectedItemChanged();
				}
				else if (sender == Template)
				{
					Template_SelectedItemChanged();
				}
				else if (sender == Cluster)
				{
					Cluster_SelectedItemChanged();
				}
				else if (sender == DefaultHost)
				{
					DefaultHost_SelectedItemChanged();
				}
				else if (sender == OSType)
				{
					OSType_SelectedItemChanged();
				}
				else if (sender == DisplayProtocol)
				{
					DisplayProtocol_SelectedItemChanged();
				}
				else if (sender == FirstBootDevice)
				{
					FirstBootDevice_SelectedItemChanged();
				}
				else if (sender == Provisioning)
				{
					Provisioning_SelectedItemChanged();
				}
			}
		}

		void DefaultHost_SelectedItemChanged()
		{
			UpdateCDImages();
		}

		void NumOfSockets_EntityChanged()
		{
			UpdateTotalCpus();
		}

		private void UpdateNumOfSockets()
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
			if (cluster == null)
			{
				return;
			}

			string version = cluster.compatibility_version.ToString();
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
											{
												UserVmModel userVmModel = (UserVmModel)model;
												userVmModel.NumOfSockets.Max = (int)result;
												userVmModel.NumOfSockets.Min = 1;
												userVmModel.NumOfSockets.Interval = 1;
												userVmModel.NumOfSockets.IsAllValuesSet = true;

												if (userVmModel.IsNew)
												{
													userVmModel.NumOfSockets.Entity = 1;
												}

												VDSGroup cluster1 = (VDSGroup)userVmModel.Cluster.SelectedItem;
												string version1 = cluster1.compatibility_version.ToString();

												AsyncQuery _asyncQuery1 = new AsyncQuery();
												_asyncQuery1.Model = userVmModel;
												/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object result1)
																			  {
																				  UserVmModel userVmModel1 = (UserVmModel)model1;
																				  userVmModel1._maxCpus = (int)result1;

																				  VDSGroup cluster2 = (VDSGroup)userVmModel1.Cluster.SelectedItem;
																				  string version2 = cluster2.compatibility_version.ToString();

																				  AsyncQuery _asyncQuery2 = new AsyncQuery();
																				  _asyncQuery2.Model = userVmModel1;
																				  /*START_DELEGATE*/_asyncQuery2.asyncCallback = delegate(Object model2, Object result2)
																												{
																													UserVmModel userVmModel2 = (UserVmModel)model2;
																													userVmModel2._maxCpusPerSocket = (int)result2;
																													userVmModel2.UpdateTotalCpus();
																												};//END_DELEGATE
																				  AsyncDataProvider.GetMaxNumOfCPUsPerSocket(_asyncQuery2, version2);

																			  };//END_DELEGATE
												AsyncDataProvider.GetMaxNumOfVmCpus(_asyncQuery1, version1);

											};//END_DELEGATE
			AsyncDataProvider.GetMaxNumOfVmSockets(_asyncQuery, version);
		}

		private void UpdateMinAllocatedMemory(bool forceUpdate)
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
			if (cluster == null)
			{
				return;
			}

			double overCommitFactor = 100.0 / cluster.max_vds_memory_over_commit;
			if (IsNew || forceUpdate)
			{
				MinAllocatedMemory.Entity = (int)((int)MemSize.Entity * overCommitFactor);
			}
		}

		public void UpdateTotalCpus()
		{
			int numOfSockets = Convert.ToInt32(NumOfSockets.Entity.ToString());

			int totalCPUCores = TotalCPUCores.Entity != null
				? Convert.ToInt32(TotalCPUCores.Entity.ToString())
				: 0;

			int realMaxCpus = _maxCpus < numOfSockets * _maxCpusPerSocket ? _maxCpus : numOfSockets * _maxCpusPerSocket;

			if (_maxCpus == 0 || _maxCpusPerSocket == 0)
			{
				return;
			}

			TotalCPUCores.Max = realMaxCpus - (realMaxCpus % numOfSockets);
			TotalCPUCores.Min = numOfSockets;
			TotalCPUCores.Interval = numOfSockets;
			//update value if needed
			//if the slider in the range but not on tick update it to lowest tick
			if ((totalCPUCores % numOfSockets != 0) && totalCPUCores < TotalCPUCores.Max && totalCPUCores > TotalCPUCores.Min)
			{
				TotalCPUCores.Entity = totalCPUCores - (totalCPUCores % numOfSockets);
			}
			//if the value is lower than range update it to min
			else if (totalCPUCores < TotalCPUCores.Min)
			{
				TotalCPUCores.Entity = Convert.ToInt32(TotalCPUCores.Min.ToString());
			}
			//if the value is higher than range update it to max
			else if (totalCPUCores > TotalCPUCores.Max)
			{
				TotalCPUCores.Entity = Convert.ToInt32(TotalCPUCores.Max.ToString());
			}

			TotalCPUCores.IsAllValuesSet = true;
		}


		void Provisioning_SelectedItemChanged()
		{
			UpdateIsDisksAvailable();
			UpdateStorageDomains();
		}

		void DataCenter_SelectedItemChanged()
		{
			storage_pool dataCenter = (storage_pool)DataCenter.SelectedItem;
			dataCenterId = dataCenter.Id;
			if (dataCenter.storage_pool_type == StorageType.LOCALFS)
			{
				IsHostAvailable = false;
			}
			else
			{
				IsHostAvailable = true;
			}
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
											{
												UserVmModel userVmModel = (UserVmModel)model;
												List<VDSGroup> clusters = (List<VDSGroup>)result;
												userVmModel.Cluster.Items = clusters;
												userVmModel.Cluster.SelectedItem = Cluster.SelectedItem ?? Linq.FirstOrDefault(clusters);

												userVmModel.FillTemplateList(dataCenterId);
												userVmModel.UpdateCDImages();

											};//END_DELEGATE
			AsyncDataProvider.GetClusterList(_asyncQuery, dataCenterId);
		}

		private void Template_SelectedItemChanged()
		{
			VmTemplate template = Template.SelectedItem as VmTemplate;

			UpdateStorageDomains();

			if (template == null)
			{
				return;
			}

			IsBlankTemplate = template.Id.Equals(Guid.Empty);

			if (IsNew)
			{
				OSType.SelectedItem = template.os;
				NumOfSockets.Entity = template.num_of_sockets;
				TotalCPUCores.Entity = template.num_of_cpus;

				NumOfMonitors.SelectedItem = template.num_of_monitors;
				Domain.Entity = template.domain;
				MemSize.Entity = template.mem_size_mb;
				UsbPolicy.SelectedItem = template.usb_policy;
				BootSequence = template.default_boot_sequence;
				IsHighlyAvailable.Entity = template.auto_startup;

				UpdateMinAllocatedMemory(false);

				CdImage.IsChangable = !String.IsNullOrEmpty(template.iso_path);
				if (CdImage.IsChangable) CdImage.SelectedItem = template.iso_path;

				if (String.IsNullOrEmpty(template.time_zone))
				{
					AsyncQuery _asyncQuery = new AsyncQuery();
					_asyncQuery.Model = this;
					/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
													{
														UserVmModel userVmModel = (UserVmModel)model;
														userVmModel.TimeZone.SelectedItem = Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)TimeZone.Items, new Linq.TimeZonePredicate((string)result));
													};//END_DELEGATE
					AsyncDataProvider.GetDefaultTimeZone(_asyncQuery);
				}
				else
				{
					TimeZone.SelectedItem = Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)TimeZone.Items, new Linq.TimeZonePredicate(template.time_zone));
				}

				if (Cluster.Items == null)
					return;
				List<VDSGroup> clusters = Linq.Cast<VDSGroup>(Cluster.Items);
				VDSGroup clusterToSelect = null;
				foreach (VDSGroup a in clusters)
				{
					if (a.ID.Equals(template.vds_group_id))
					{
						clusterToSelect = a;
						break;
					}
				}

				if (clusterToSelect == null)
				{
					clusterToSelect = Linq.FirstOrDefault(clusters);
				}

				Cluster.SelectedItem = clusterToSelect;

				// BZ#549348 (SPICE should be the default protocol for new Desktop).
				// Because of this bug, the Display Protocol is read only in case of
				// new Server or in case the template has the SPICE protocol as the
				// default display type:
				if (VmType == VmType.Server || template.default_display_type == DisplayType.qxl)
				{
					EntityModel displayProtocol = null;
					bool isFirst = true;
					foreach (object item in DisplayProtocol.Items)
					{
						EntityModel a = (EntityModel)item;
						if (isFirst)
						{
							displayProtocol = a;
							isFirst = false;
						}
						DisplayType dt = (DisplayType)a.Entity;
						if (dt == template.default_display_type)
						{
							displayProtocol = a;
							break;
						}
					}
					DisplayProtocol.SelectedItem = displayProtocol;
				}

				//By default, take kernel params from template.
				Kernel_path.Entity = template.kernel_url;
				Kernel_parameters.Entity = template.kernel_params;
				Initrd_path.Entity = template.initrd_url;

				if (!template.Id.Equals(Guid.Empty))
				{
					IsBlankTemplate = false;
					Provisioning.IsChangable = true;
					//Retrieve disks.
					if (IsNew)
					{
						AsyncQuery _asyncQuery = new AsyncQuery();
						_asyncQuery.Model = this;
						/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
														{
															UserVmModel userVmModel = (UserVmModel)model;
										  List<DiskImage> diskList = (List<DiskImage>)(valueObjectEnumerableList)result;
															diskList.Sort(new Linq.DiskByInternalDriveMappingComparer());

															List<DiskModel> list = new List<DiskModel>();
															foreach (DiskImage a in diskList)
															{
																DiskModel diskModel = new DiskModel();
																diskModel.IsNew = true;
																diskModel.Name = a.internal_drive_mapping;
																diskModel.Size =
																	new EntityModel
																	{
																		Entity = a.SizeInGigabytes
																	};
																diskModel.VolumeType =
																	new ListModel
																	{
																		Items = DataProvider.GetVolumeTypeList(),
																		SelectedItem = a.volume_type
																	};
																list.Add(diskModel);
															}

															userVmModel.Disks = list;
															userVmModel.UpdateIsDisksAvailable();

														};//END_DELEGATE
						AsyncDataProvider.GetTemplateDiskList(_asyncQuery, template.Id);
					}
				}
				else
				{
					IsBlankTemplate = true;
					IsDisksAvailable = false;
					Provisioning.IsChangable = false;
					Disks = null;
				}

				//Set priority
				AsyncQuery _asyncQuery1 = new AsyncQuery();
				_asyncQuery1.Model = this;
				/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model, Object result)
												{
													UserVmModel userVmModel = (UserVmModel)model;
													int priority = (int)result;

													object prioritySelectedItem = null;
													foreach (object item in userVmModel.Priority.Items)
													{
														EntityModel a = (EntityModel)item;
														if ((int)a.Entity == priority)
														{
															prioritySelectedItem = a;
															break;
														}
													}
													userVmModel.Priority.SelectedItem = prioritySelectedItem;
												};//END_DELEGATE
				AsyncDataProvider.GetRoundedPriority(_asyncQuery1, template.priority);
			}
		}

		private void Cluster_SelectedItemChanged()
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;

			if (cluster != null)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
							  {
								  UserVmModel userVmModel = (UserVmModel)model;
								  List<VDS> hosts = (List<VDS>)result;
								  userVmModel.DefaultHost.Items = hosts;
								  userVmModel.DefaultHost.SelectedItem = Linq.FirstOrDefault(hosts);

								  //VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
								  AsyncQuery _asyncQuery1 = new AsyncQuery();
								  _asyncQuery1.Model = userVmModel;
								  /*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object result1)
																  {
																	  UserVmModel userVmModel1 = (UserVmModel)model1;
																	  userVmModel1.UpdateNumOfSockets();

																  };//END_DELEGATE
								  AsyncDataProvider.GetMaxVmMemSize(_asyncQuery1, false);
								  AsyncDataProvider.GetMaxVmMemSize(_asyncQuery1, true);

							  };//END_DELEGATE
				AsyncDataProvider.GetHostListByCluster(_asyncQuery, cluster.name);
				_asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
                /*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
                                                              	{
												  UserVmModel userVmModel = (UserVmModel)model;
																	IsCustomPropertiesAvailable = (bool)result;
                                                              	};//END_DELEGATE
				AsyncDataProvider.IsCustomPropertiesAvailable(_asyncQuery, cluster.compatibility_version.ToString());

				UpdateMinAllocatedMemory(false);
			}
			else
			{
				List<VDS> hosts = new List<VDS>();
				DefaultHost.Items = hosts;
				DefaultHost.SelectedItem = Linq.FirstOrDefault(hosts);

				UpdateNumOfSockets();
			}
		}

		void OSType_SelectedItemChanged()
		{
			VmOsType osType = (VmOsType)OSType.SelectedItem;

			IsWindowsOS = DataProvider.IsWindowsOsType(osType);
			IsLinux_Unassign_UnknownOS = DataProvider.IsLinuxOsType(osType) || osType == VmOsType.Unassigned || osType == VmOsType.Other;

			Initrd_path.IsChangable = IsLinux_Unassign_UnknownOS;
			Initrd_path.IsAvailable = IsLinux_Unassign_UnknownOS;

			Kernel_path.IsChangable = IsLinux_Unassign_UnknownOS;
			Kernel_path.IsAvailable = IsLinux_Unassign_UnknownOS;

			Kernel_parameters.IsChangable = IsLinux_Unassign_UnknownOS;
			Kernel_parameters.IsAvailable = IsLinux_Unassign_UnknownOS;

			Domain.IsChangable = IsWindowsOS;
			Domain.IsAvailable = IsWindowsOS;

			if (IsFirstRun)
			{
				TimeZone.IsChangable = IsWindowsOS;
				TimeZone.IsAvailable = IsWindowsOS;
			}

			DefineNumOfMonitorsAvailabilityAccoringToSelectedOs();
		}

		void DisplayProtocol_SelectedItemChanged()
		{
			EntityModel entityModel = (EntityModel)DisplayProtocol.SelectedItem;
			DisplayType type = (DisplayType)entityModel.Entity;

			if (type == DisplayType.vnc)
			{
				UsbPolicy.SelectedItem = VdcCommon.BusinessEntities.UsbPolicy.Disabled;
				NumOfMonitors.SelectedItem = 1;
			}

			UsbPolicy.IsChangable = type == DisplayType.qxl;
			NumOfMonitors.IsChangable = type == DisplayType.qxl;
		}

		void FirstBootDevice_SelectedItemChanged()
		{
			EntityModel entityModel = (EntityModel)FirstBootDevice.SelectedItem;
			BootSequence firstDevice = (BootSequence)entityModel.Entity;

			List<EntityModel> list = new List<EntityModel>();
			foreach (object item in FirstBootDevice.Items)
			{
				EntityModel a = (EntityModel)item;
				if ((BootSequence)a.Entity != firstDevice)
				{
					list.Add(a);
				}
			}

			EntityModel noneOption = new EntityModel { Title = "[None]" };

			list.Insert(0, noneOption);

			SecondBootDevice.Items = list;
			SecondBootDevice.SelectedItem = noneOption;
		}

		public void UpdateIsDisksAvailable()
		{
			IsDisksAvailable = IsNew && (bool)((EntityModel)Provisioning.SelectedItem).Entity && (Disks != null);
		}

		void DefineNumOfMonitorsAvailabilityAccoringToSelectedOs()
		{
			if (VmType == VmType.Desktop)
			{
				if (DataProvider.IsLinuxOsType((VmOsType)OSType.SelectedItem))
				{
					NumOfMonitors.SelectedItem = 1;
					NumOfMonitors.IsAvailable = false;
					NumOfMonitors.IsChangable = false;
				}
				else if (!NumOfMonitors.IsAvailable)
				{
					NumOfMonitors.IsAvailable = true;
					NumOfMonitors.IsChangable = true;
				}
			}
		}

		virtual protected void FillTemplateList(Guid DataCenterId)
		{
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
											{
												UserVmModel userVmModel = (UserVmModel)model;
												List<VmTemplate> templates = (List<VmTemplate>)result;

												VmTemplate oldTemplate = (VmTemplate)userVmModel.Template.SelectedItem;
												userVmModel.Template.Items = templates;

												// If there was no selected template or the old selected template doesn't
												// exist in the new list of available templates - re-select a template.
												// Otherwise, leave the template selected value as is.
												bool all = false;
												if (oldTemplate != null)
												{
													foreach (VmTemplate a in templates)
													{
														if (a.Id.Equals(oldTemplate.Id))
														{
															userVmModel.Template.SelectedItem = a;
															all = true;
															break;
														}
													}
												}

												if (oldTemplate == null || !all)
												{
													foreach (VmTemplate a in templates)
													{
														if (a.Id.Equals(Guid.Empty))
														{
															userVmModel.Template.SelectedItem = a;
															break;
														}
													}
												}
												userVmModel.UpdateIsDisksAvailable();
											};//END_DELEGATE
			AsyncDataProvider.GetTemplateListByDataCenter(_asyncQuery, DataCenterId);
		}

		private void SetGUIByVMType()
		{
			if (VmType == VmType.Desktop)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
												{
													UserVmModel userVmModel = (UserVmModel)model;
													List<int> numOfMonitors = (List<int>)result;
													userVmModel.NumOfMonitors.Items = numOfMonitors;
													userVmModel.NumOfMonitors.SelectedItem = Linq.FirstOrDefault(numOfMonitors);
												};//END_DELEGATE
				AsyncDataProvider.GetNumOfMonitorList(_asyncQuery);
				UsbPolicy.SelectedItem = VdcCommon.BusinessEntities.UsbPolicy.Enabled;
			}
			else
			{
				List<int> numOfMonitors = new List<int> { 1 };
				NumOfMonitors.Items = numOfMonitors;
				NumOfMonitors.SelectedItem = Linq.FirstOrDefault(numOfMonitors);
			}


			foreach (object item in DisplayProtocol.Items)
			{
				EntityModel a = (EntityModel)item;
				if ((DisplayType)a.Entity == (VmType == VmType.Desktop ? DisplayType.qxl : DisplayType.vnc))
				{
					DisplayProtocol.SelectedItem = a;
					break;
				}
			}
		}

		public void UpdateCDImages()
		{
			storage_pool dataCenter = DataCenter.SelectedItem as storage_pool;
			if (dataCenter != null)
			{
				Guid? vds_id = null;
				if (DefaultHost.SelectedItem != null)
				{
					vds_id = ((VDS)DefaultHost.SelectedItem).vds_id;
					vds_id = vds_id == Guid.Empty ? null : vds_id;
				}
							AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
							/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
								{
									UserVmModel userVmModel = (UserVmModel)model;
									List<string> images = (List<string>)result;
									userVmModel.CdImage.Items = images;

									if (!userVmModel.IsNew && !String.IsNullOrEmpty(userVmModel.IsoPath))
									{
										userVmModel.CdImage.IsChangable = true;
										userVmModel.CdImage.SelectedItem = userVmModel.IsoPath;
									}
									else if (userVmModel.CdImage.IsChangable && userVmModel.CdImage.SelectedItem == null)
									{
										userVmModel.CdImage.SelectedItem = Linq.FirstOrDefault(images);
									}
								};//END_DELEGATE
				AsyncDataProvider.GetIrsImageList(_asyncQuery, Guid.Empty, true);
			}
		}

		private void UpdateStorageDomains()
		{
			VmTemplate template = Template.SelectedItem as VmTemplate;

			if (template != null && !template.Id.Equals(Guid.Empty))
			{
				storage_pool dataCenter = (storage_pool)DataCenter.SelectedItem;

				if ((bool)((EntityModel)Provisioning.SelectedItem).Entity)
				{
					AsyncQuery _asyncQuery = new AsyncQuery();
					_asyncQuery.Model = this;
					/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
													{
														UserVmModel userVmModel = (UserVmModel)model;
														List<storage_domains> storageDomains = (List<storage_domains>)result;
														userVmModel.PostUpdateStorageDomains(storageDomains);
													};//END_DELEGATE
					AsyncDataProvider.GetStorageDomainListByTemplate(_asyncQuery, template.Id);
				}
				else
				{
					AsyncQuery _asyncQuery = new AsyncQuery();
					_asyncQuery.Model = this;
					/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
					{
						UserVmModel userVmModel = (UserVmModel)model;
							List<storage_domains> list = (List<storage_domains>)(valueObjectEnumerableList)result;

						List<storage_domains> storageDomains = new List<storage_domains>();
						foreach (storage_domains a in list)
						{
							if (a.storage_domain_type == StorageDomainType.Data || a.storage_domain_type == StorageDomainType.Master)
							{
								storageDomains.Add(a);
							}
						}

						userVmModel.PostUpdateStorageDomains(storageDomains);
					};//END_DELEGATE
					AsyncDataProvider.GetStorageDomainList(_asyncQuery, dataCenter.Id);
				}
			}
			else
			{
				StorageDomain.Items = new List<storage_domains>();
				StorageDomain.SelectedItem = null;
				StorageDomain.IsChangable = false;
			}
		}

		public void PostUpdateStorageDomains(List<storage_domains> storageDomains)
		{
			// filter only the Active storage domains (Active regarding the relevant storage pool).
			//storageDomains = storageDomains.Where(a => a.status.HasValue && a.status.Value == StorageDomainStatus.Active);
			List<storage_domains> list = new List<storage_domains>();
			foreach (storage_domains a in storageDomains)
			{
				if (a.status.HasValue && a.status.Value == StorageDomainStatus.Active)
				{
					list.Add(a);
				}
			}

			StorageDomain.Items = list;
			StorageDomain.SelectedItem = Linq.FirstOrDefault(list);
			StorageDomain.IsChangable = true;
		}

		internal virtual bool Validate()
		{
			VmOsType os = (VmOsType)OSType.SelectedItem;

			string nameExpr;
			string nameMsg;
			if (DataProvider.IsWindowsOsType(os))
			{
				nameExpr = @"^[0-9a-zA-Z-_]{1," + WINDOWS_VM_NAME_MAX_LIMIT + "}$";
				nameMsg = "Name must contain only alphanumeric characters. Maximum length: " + WINDOWS_VM_NAME_MAX_LIMIT + ".";
			}
			else
			{
				nameExpr = @"^[-\w]{1," + NON_WINDOWS_VM_NAME_MAX_LIMIT + "}$";
				nameMsg = "Name cannot contain blanks or special characters. Maximum length: " + NON_WINDOWS_VM_NAME_MAX_LIMIT + ".";
			}

			Name.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(), 
					new RegexValidation
					{
						Expression = nameExpr,
						Message = nameMsg
					}
				});

			DataCenter.IsValid = true;
			//In case of Edit the only scenario in which it will be null - editing of Blank template
			if (IsNew)
			{
				DataCenter.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			Cluster.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			if ((bool)IsAutoAssign.Entity == false)
			{
				DefaultHost.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}
			else
			{
				DefaultHost.IsValid = true;
			}

			MemSize.ValidateEntity(new IValidation[] { new ByteSizeValidation() });
			MinAllocatedMemory.ValidateEntity(new IValidation[] { new ByteSizeValidation() });

			VmTemplate template = (VmTemplate)Template.SelectedItem;
			storage_domains storageDomain = (storage_domains)StorageDomain.SelectedItem;

			Template.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			StorageDomain.IsValid = true;
			if (template != null && !template.Id.Equals(Guid.Empty) && storageDomain == null)
			{
				StorageDomain.IsValid = false;
				StorageDomain.InvalidityReasons.Add("Storage Domain must be specified.");
			}

			VmOsType osType = (VmOsType)OSType.SelectedItem;
			bool is64OsType = (osType == VmOsType.Other || osType == VmOsType.OtherLinux || DataProvider.Is64bitOsType(osType));
			int maxMemSize = is64OsType ? _maxMemSize64 : _maxMemSize32;

			ValidateMemorySize(MemSize, maxMemSize);
			ValidateMemorySize(MinAllocatedMemory, (int)MemSize.Entity);

			CdImage.IsValid = true;
			if (CdImage.IsChangable)
			{
				CdImage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			Kernel_path.IsValid = true;
			Kernel_parameters.IsValid = true;
			Initrd_path.IsValid = true;
			if (Kernel_path.Entity == null)
			{
				Kernel_path.Entity = "";
			}
			if (Kernel_parameters.Entity == null)
			{
				Kernel_parameters.Entity = "";
			}
			if (Initrd_path.Entity == null)
			{
				Initrd_path.Entity = "";
			}

			if (isLinux_Unassign_UnknownOS && ((((string)Kernel_parameters.Entity).Length > 0 || ((string)Initrd_path.Entity).Length > 0) && ((string)Kernel_path.Entity).Length == 0))
			{
                int count = 0;
                string msg = "When ";
                if (((string)Kernel_parameters.Entity).Length > 0)
                {
                    Kernel_parameters.IsValid = false;
                    msg += "a kernel parameter argument ";
                    count++;
                }
                if (((string)Initrd_path.Entity).Length > 0)
                {
                    Initrd_path.IsValid = false;
                    if (count == 1)
                    {
                        msg += "or ";
                    }
                    msg += "an initrd path ";
                }
                msg += "is used, kernel path must be non-empty";

				Kernel_path.IsValid = false;
				Initrd_path.InvalidityReasons.Add(msg);
				Kernel_parameters.InvalidityReasons.Add(msg);
				Kernel_path.InvalidityReasons.Add(msg);
			}

			CustomProperties.ValidateEntity(new IValidation[] { new CustomPropertyValidation(CustomPropertiesKeysList) });


			IsGeneralTabValid =
				IsFirstRunTabValid =
				IsDisplayTabValid =
				IsAllocationTabValid =
				IsBootSequenceTabValid = true;


			IsGeneralTabValid =
				Name.IsValid
				&& Description.IsValid
				&& DataCenter.IsValid
				&& Template.IsValid
				&& Cluster.IsValid
				&& MemSize.IsValid
				&& MinAllocatedMemory.IsValid;

			IsFirstRunTabValid = Domain.IsValid && TimeZone.IsValid;
			IsDisplayTabValid = UsbPolicy.IsValid && NumOfMonitors.IsValid;
			IsHostTabValid = DefaultHost.IsValid;
			IsAllocationTabValid = StorageDomain.IsValid && MinAllocatedMemory.IsValid;
			IsBootSequenceTabValid = CdImage.IsValid && Kernel_path.IsValid;
			IsCustomPropertiesTabValid = CustomProperties.IsValid;

			return Name.IsValid
				   && Description.IsValid
				   && DataCenter.IsValid
				   && StorageDomain.IsValid
				   && Template.IsValid
				   && Cluster.IsValid
				   && DefaultHost.IsValid
				   && MemSize.IsValid
				   && MinAllocatedMemory.IsValid
				   && NumOfMonitors.IsValid
				   && Domain.IsValid
				   && UsbPolicy.IsValid
				   && TimeZone.IsValid
				   && OSType.IsValid
				   && CdImage.IsValid
				   && Kernel_path.IsValid
				   && CustomProperties.IsValid;
		}

		private void ValidateMemorySize(EntityModel memorySizeEntityModel, int maxMemSize)
		{
			memorySizeEntityModel.IsValid = true;

			int memSize = (int)memorySizeEntityModel.Entity;

			if (memSize == 0)
			{
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add("Memory size is between " + _minMemSize + " MB and " + maxMemSize + " MB");
			}
			else if (memSize > maxMemSize)
			{
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add("Maximum memory size is " + maxMemSize + " MB.");
			}
			else if (memSize < _minMemSize)
			{
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add("Minimum memory size is " + _minMemSize + " MB.");
			}
		}

		public BootSequence BootSequence
		{
			get
			{
				EntityModel firstSelectedItem = (EntityModel)FirstBootDevice.SelectedItem;
				EntityModel secondSelectedItem = (EntityModel)SecondBootDevice.SelectedItem;

				string firstSelectedString = firstSelectedItem.Entity == null ? string.Empty : firstSelectedItem.Entity.ToString();
				string secondSelectedString = secondSelectedItem.Entity == null ? string.Empty : secondSelectedItem.Entity.ToString();

				return (BootSequence)Enum.Parse(typeof(BootSequence), firstSelectedString + secondSelectedString);
			}
			set
			{
				List<BootSequence> items = new List<BootSequence>();
				foreach (char a in value.ToString().ToCharArray())
				{
					items.Add((BootSequence)Enum.Parse(typeof(BootSequence), a.ToString()));
				}

				object firstBootDevice = null;
				foreach (object item in FirstBootDevice.Items)
				{
					EntityModel a = (EntityModel)item;
					if ((BootSequence)a.Entity == Linq.FirstOrDefault(items))
					{
						firstBootDevice = a;
					}
				}
				FirstBootDevice.SelectedItem = firstBootDevice;

				List<EntityModel> secondDeviceOptions = Linq.Cast<EntityModel>(SecondBootDevice.Items);

				if (items.Count > 1)
				{
					BootSequence last = items[items.Count - 1];
					foreach (EntityModel a in secondDeviceOptions)
					{
						if (a.Entity != null && (BootSequence)a.Entity == last)
						{
							SecondBootDevice.SelectedItem = a;
							break;
						}
					}
				}
				else
				{
					foreach (EntityModel a in secondDeviceOptions)
					{
						if (a.Entity == null)
						{
							SecondBootDevice.SelectedItem = a;
							break;
						}
					}
				}
			}
		}
	}
}
