﻿using System;
using System.Collections.Generic;

namespace VdcCommon.BusinessEntities
{
    public partial class VmPoolParametersBase : VdcActionParametersBase
    {
        public VmPoolParametersBase() { }

        public VmPoolParametersBase(Guid vmPoolId)
        {
            _vmPoolId = vmPoolId;
        }
    }

    public partial class AddVmToPoolParameters : VmPoolParametersBase
    {
        public AddVmToPoolParameters() { }

        public AddVmToPoolParameters(Guid vmPoolId, Guid vmId)
            : base(vmPoolId)
        {
            VmId = vmId;
        }

    }

    public partial class VmPoolOperationParameters : VmPoolParametersBase
    {
        public VmPoolOperationParameters() { }

        public VmPoolOperationParameters(vm_pools vm_pools)
            : base(vm_pools.vm_pool_id)
        {
            vm_pools.vm_pool_description = vm_pools.vm_pool_description ?? string.Empty;
            _vmPool = vm_pools;
        }

    }

    public partial class AddVmPoolWithVmsParameters : VmPoolOperationParameters
    {
        public AddVmPoolWithVmsParameters() { }

        public AddVmPoolWithVmsParameters(vm_pools vmPool, VM vm, int count, int diskSize)
            : base(vmPool)
        {
            _vm = vm;
            _vmsCount = count;
            _diskSize = diskSize;
        }

    }

    public partial class RemoveVmFromPoolParameters : VmPoolParametersBase
    {
        public RemoveVmFromPoolParameters() { }

        public RemoveVmFromPoolParameters(Guid vmId)
            : base(Guid.Empty)
        {
            VmId = vmId;
        }
    }

    public partial class VmPoolSimpleUserParameters : VmPoolParametersBase
    {
        public VmPoolSimpleUserParameters() { }

        public VmPoolSimpleUserParameters(Guid vmPoolId, Guid userId)
            : base(vmPoolId)
        {
            UserId = userId;
        }
    }

    public partial class DetachUserFromTimeLeasedPoolParameters : VmPoolSimpleUserParameters
    {
        public DetachUserFromTimeLeasedPoolParameters() { }

        public DetachUserFromTimeLeasedPoolParameters
            (Guid vmPoolId, Guid userId, bool isInternal)
            : base(vmPoolId, userId)
        {
            _isInternal = isInternal;
        }
    }

    public partial class UpdateUserVmPoolParameters : VmPoolSimpleUserParameters
    {
        public UpdateUserVmPoolParameters() { }

        public UpdateUserVmPoolParameters(time_lease_vm_pool_map map)
            : base(map.vm_pool_id, map.id)
        {
            _userPoolMap = map;
        }
    }

    public partial class VmPoolUserParameters : VmPoolSimpleUserParameters
    {
        public VmPoolUserParameters() { }

        public VmPoolUserParameters(Guid vmPoolId, VdcUser user, bool isInternal)
            : base(vmPoolId, user.UserId)
        {
            VdcUserData = user;
            IsInternal = isInternal;
        }
    }

    public partial class AttachUserToTimeLeasedPoolParameters : VmPoolUserParameters
    {
        public AttachUserToTimeLeasedPoolParameters() { }

        public AttachUserToTimeLeasedPoolParameters(Guid vmPoolId, VdcUser user, time_lease_vm_pool_map map)
            : base(vmPoolId, user, false)
        {
            _userPoolMap = map;
        }
    }
}