﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Collections;

namespace VdcCommon.BusinessEntities
{
	public partial class nguid
	{
		protected nguid()
		{
			this.uuid = new Guid().ToString();
		}
		protected nguid(String s)
		{
			this.uuid = s;
		}
		public static implicit operator Guid?(nguid g)
		{
			return (g == (object)null) ? (Guid?)null : new Guid(g.uuid);
		}

		public static implicit operator nguid(Guid? G)
		{
			return ((Object)G == null) ? (nguid)null : new nguid(G.ToString());
		}

		public static bool operator ==(nguid ng1, nguid ng2)
		{
			if ((object)ng1 == null && (object)ng2 == null)
				return true;

			if ((object)ng1 != null && (object)ng2 == null)
				return false;

			if ((object)ng1 == null && (object)ng2 != null)
				return false;

			return ng1.uuid.Equals(ng2.uuid);
		}
		public static bool operator !=(nguid ng1, nguid ng2)
		{
			return !(ng1 == ng2);
		}

		public Guid Value
		{
			get
			{
				return new Guid(this.uuid);
			}
		}
		public override string ToString()
		{
			return new Guid(this.uuid).ToString();
		}
		public override bool Equals(object obj)
		{
			Guid objG;
			if (obj is Guid)
				objG = (Guid)obj;
			else if (obj is nguid)
				objG = new Guid(((nguid)obj).uuid);
			else
				throw new InvalidCastException(string.Format("nguid.Equals cannot compare object {0} of type {1}", obj.ToString(), obj.GetType().Name));
			Guid this_helper = new Guid(((nguid)this).uuid);
			return this_helper.Equals(objG);
		}
		public override int GetHashCode()
		{
			return new Guid(this.uuid).GetHashCode();
		}
	}

	public partial class guid
	{
		public guid()
		{
			this.uuid = new Guid().ToString();
		}
		public guid(String s)
		{
			this.uuid = s;
		}
		public static implicit operator Guid(guid g)
		{
			return ((Object)g == null) ? Guid.Empty : new Guid(g.uuid);
		}

		public static implicit operator guid(Guid G)
		{
			return new guid(G.ToString());
		}
	}

	public partial class timeSpan
	{
		public static implicit operator TimeSpan(timeSpan t)
		{
			return ((object)t == null) ? TimeSpan.Zero : new TimeSpan(t.Days, t.Hours, t.Minutes, t.Seconds, t.Milliseconds);
		}

		public static implicit operator timeSpan(TimeSpan T)
		{
			return new timeSpan() { Days = T.Days, Hours = T.Hours, Minutes = T.Minutes, Seconds = T.Seconds, Milliseconds = T.Milliseconds, TotalDays = T.TotalDays, TotalHours = T.TotalHours, TotalMinutes = T.TotalMinutes, TotalSeconds = T.TotalSeconds, TotalMilliseconds = (long)T.TotalMilliseconds };
		}
		public override string ToString()
		{
			return ((TimeSpan)this).ToString();
		}
		public override bool Equals(object obj)
		{
			TimeSpan objT;
			if (obj is TimeSpan)
				objT = (TimeSpan)obj;
			else if (obj is timeSpan)
				objT = (TimeSpan)(timeSpan)obj;
			else
				throw new InvalidCastException(string.Format("timeSpan.Equals cannot compare object {0} of type {1}", obj.ToString(), obj.GetType().Name));
			return ((TimeSpan)this).Equals(objT);
		}
		public override int GetHashCode()
		{
			return ((TimeSpan)this).GetHashCode();
		}
		public static bool operator ==(timeSpan ts1, timeSpan ts2)
		{
			if ((object)ts1 == null && (object)ts2 == null)
				return true;

			if ((object)ts1 != null && (object)ts2 == null)
				return false;

			if ((object)ts1 == null && (object)ts2 != null)
				return false;

			return ts1.Equals(ts2);
		}
		public static bool operator !=(timeSpan ts1, timeSpan ts2)
		{
			return !(ts1 == ts2);
		}

	}

	public partial class Logoff1
	{
		public static implicit operator Logoff1(LogoutUserParameters l)
		{
			return new Logoff1(l);
		}
	}
	public partial class Login1
	{
		public static implicit operator Login1(LoginUserParameters l)
		{
			return new Login1(l);
		}
	}
	public partial class LogoffResponse1
	{
		public static implicit operator VdcReturnValueBase(LogoffResponse1 l)
		{
			return l.@return;
		}
	}
	public partial class LoginResponse1
	{
		public static implicit operator VdcReturnValueBase(LoginResponse1 l)
		{
			return l.@return;
		}
	}

	public interface IBackend : VdcCommon.BusinessEntities.IBackendCxf { }
	public interface IUserBackend : VdcCommon.BusinessEntities.IBackend
	{
	}
	public partial class RunMultipleActionsResponse
	{
		public static implicit operator List<VdcReturnValueBase>(RunMultipleActionsResponse l)
		{
			if (l.@return == null)
				return new List<VdcReturnValueBase>();
			return l.@return.ToList();
		}
	}

	public partial class RunActionResponse1
	{
		public static implicit operator VdcReturnValueBase(RunActionResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class RunQueryResponse1
	{
		public static implicit operator VdcQueryReturnValue(RunQueryResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class RunMultipleQueriesResponse
	{
		public static implicit operator List<VdcQueryReturnValue>(RunMultipleQueriesResponse l)
		{
			if (l.@return == null)
			{
				return new List<VdcQueryReturnValue>();
			}
			return l.@return.ToList();
		}
	}

	public partial class RunUIQueryResponse1
	{
		public static implicit operator UIQueryReturnValue(RunUIQueryResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class RunPublicQueryResponse1
	{
		public static implicit operator VdcQueryReturnValue(RunPublicQueryResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class RunAutoQueryResponse1
	{
		public static implicit operator VdcQueryReturnValue(RunAutoQueryResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class RunAutoActionResponse1
	{
		public static implicit operator VdcReturnValueBase(RunAutoActionResponse1 l)
		{
			return l.@return;
		}
	}

	public partial class GetAsyncQueryResultsResponse1
	{
		public static implicit operator List<KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>>(GetAsyncQueryResultsResponse1 l)
		{
			List<KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>> response = new List<KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>>();
			asyncQueryResults result = l.@return;
			if (result == null || result.queryIDs == null)
				return response;

			for (int i = 0; i < result.queryIDs.Length; i++)
			{
				//KeyValuePairCompat kvpc = l.GetAsyncQueryResultsResponse.@return.[i];
				//KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>> kvp = new KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>(
				//    (Guid)kvpc.key,
				//    ((ListIVdcQueryableUpdatedData[])kvpc.value).ToList()
				//    );
				if (result.queryData[i].value == null)
					result.queryData[i].value = new ListIVdcQueryableUpdatedData[0];
				KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>> kvp = new KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>(
					result.queryIDs[i],
					result.queryData[i].value.Select<ListIVdcQueryableUpdatedData, ListIVdcQueryableUpdatedData>(x => new ListIVdcQueryableUpdatedData(x)).ToList()
					);
				response.Add(kvp);
			}
			return response;
		}
	}

	public static class MyExtensions
	{
		public static Guid[] GuidArray(this guid[] ar)
		{
			Guid[] ret = new Guid[ar.Length];
			for (int i = 0; i < ar.Length; i++)
			{
				ret[i] = ar[i];
			}
			return ret;
		}

		public static guid[] GuidArray(this Guid[] ar)
		{
			guid[] ret = new guid[ar.Length];
			for (int i = 0; i < ar.Length; i++)
			{
				ret[i] = ar[i];
			}
			return ret;
		}

		public static guid[] GuidArray(this List<Guid> ar)
		{
			guid[] ret = new guid[ar.Count];
			for (int i = 0; i < ar.Count; i++)
			{
				ret[i] = ar[i];
			}
			return ret;
		}
	}

	public partial class KeyValuePairCompat
	{
		public static implicit operator KeyValuePair<string, string>(KeyValuePairCompat l)
		{
			return new KeyValuePair<string, string>(l.key.ToString(), l.value.ToString());
		}
	}

	public partial class DiskImageList
	{
		public static implicit operator List<DiskImage>(DiskImageList l)
		{
			return l.diskImages.ToList();
		}
	}

	public partial class valueObject
	{
		public static explicit operator int(valueObject l) { return (int)((valueObjectSingle)l).value; }
		public static explicit operator bool(valueObject l) { return (bool)((valueObjectSingle)l).value; }
		public static explicit operator string(valueObject l) { return l == null ? null : (string)((valueObjectSingle)l).value; }
		public static explicit operator ad_groups(valueObject l) { return (ad_groups)((valueObjectSingle)l).value; }
		public static explicit operator AsyncTaskStatus(valueObject l) { return (AsyncTaskStatus)((valueObjectSingle)l).value; }
		public static explicit operator DbUser(valueObject l) { return (DbUser)((valueObjectSingle)l).value; }
		public static explicit operator DiskImage(valueObject l) { return (DiskImage)((valueObjectSingle)l).value; }
		public static explicit operator event_map(valueObject l) { return (event_map)((valueObjectSingle)l).value; }
		public static explicit operator event_notification_methods(valueObject l) { return (event_notification_methods)((valueObjectSingle)l).value; }
		public static explicit operator event_subscriber(valueObject l) { return (event_subscriber)((valueObjectSingle)l).value; }
		public static explicit operator VdsNetworkInterface(valueObject l) { return (VdsNetworkInterface)((valueObjectSingle)l).value; }
		public static explicit operator VmNetworkInterface(valueObject l) { return (VmNetworkInterface)((valueObjectSingle)l).value; }
		public static explicit operator NetworkInterface(valueObject l) { return (NetworkInterface)((valueObjectSingle)l).value; }
		public static explicit operator LUNs(valueObject l) { return (LUNs)((valueObjectSingle)l).value; }
		public static explicit operator network(valueObject l) { return (network)((valueObjectSingle)l).value; }
		public static explicit operator permissions(valueObject l) { return (permissions)((valueObjectSingle)l).value; }
		public static explicit operator roles_actions(valueObject l) { return (roles_actions)((valueObjectSingle)l).value; }
		public static explicit operator roles(valueObject l) { return (roles)((valueObjectSingle)l).value; }
		public static explicit operator vm_pools(valueObject l) { return (vm_pools)((valueObjectSingle)l).value; }
		public static explicit operator ServerCpu(valueObject l) { return (ServerCpu)((valueObjectSingle)l).value; }
		public static explicit operator storage_domain_static(valueObject l) { return (storage_domain_static)((valueObjectSingle)l).value; }
		public static explicit operator storage_domains(valueObject l) { return (storage_domains)((valueObjectSingle)l).value; }
		public static explicit operator storage_server_connections(valueObject l) { return (storage_server_connections)((valueObjectSingle)l).value; }
		public static explicit operator tags(valueObject l) { return (tags)((valueObjectSingle)l).value; }
		public static explicit operator vm_pool_map(valueObject l) { return (vm_pool_map)((valueObjectSingle)l).value; }
		public static explicit operator VmTemplate(valueObject l) { return (VmTemplate)((valueObjectSingle)l).value; }
		public static explicit operator bookmarks(valueObject l) { return (bookmarks)((valueObjectSingle)l).value; }
		public static explicit operator storage_pool(valueObject l) { return (storage_pool)((valueObjectSingle)l).value; }
		public static explicit operator VDS(valueObject l) { return (VDS)((valueObjectSingle)l).value; }
		public static explicit operator VdsStatic(valueObject l) { return (VdsStatic)((valueObjectSingle)l).value; }
		public static explicit operator VDSGroup(valueObject l) { return (VDSGroup)((valueObjectSingle)l).value; }
		public static explicit operator VM(valueObject l) { return (VM)((valueObjectSingle)l).value; }
		public static explicit operator DiskImageBase(valueObject l) { return (DiskImageBase)((valueObjectSingle)l).value; }
		public static explicit operator version(valueObject l) { return (version)((valueObjectSingle)l).value; }
		public static explicit operator FenceStatusReturnValue(valueObject l) { return (FenceStatusReturnValue)((valueObjectSingle)l).value; }

		public static explicit operator List<int>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<int>().ToList<int>(); }
		public static explicit operator List<bool>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<bool>().ToList<bool>(); }
		public static explicit operator List<string>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<string>().ToList<string>(); }
		public static explicit operator List<RpmVersion>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<RpmVersion>().ToList<RpmVersion>(); }
		public static explicit operator List<ad_groups>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<ad_groups>().ToList<ad_groups>(); }
		public static explicit operator List<RepoFileMetaData>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<RepoFileMetaData>().ToList<RepoFileMetaData>(); }
		public static explicit operator List<AsyncTaskStatus>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<AsyncTaskStatus>().ToList<AsyncTaskStatus>(); }
		public static explicit operator List<DbUser>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<DbUser>().ToList<DbUser>(); }
		public static explicit operator List<DiskImage>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<DiskImage>().ToList<DiskImage>(); }
		public static explicit operator List<event_map>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<event_map>().ToList<event_map>(); }
		public static explicit operator List<event_notification_methods>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<event_notification_methods>().ToList<event_notification_methods>(); }
		public static explicit operator List<event_subscriber>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<event_subscriber>().ToList<event_subscriber>(); }
		public static explicit operator List<VdsNetworkInterface>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VdsNetworkInterface>().ToList<VdsNetworkInterface>(); }
		public static explicit operator List<VmNetworkInterface>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VmNetworkInterface>().ToList<VmNetworkInterface>(); }
		public static explicit operator List<NetworkInterface>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<NetworkInterface>().ToList<NetworkInterface>(); }
		public static explicit operator List<IVdcQueryable>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<IVdcQueryable>().ToList<IVdcQueryable>(); }
		public static explicit operator List<LUNs>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<LUNs>().ToList<LUNs>(); }
		public static explicit operator List<network>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<network>().ToList<network>(); }
		public static explicit operator List<permissions>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<permissions>().ToList<permissions>(); }
		public static explicit operator List<roles_actions>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<roles_actions>().ToList<roles_actions>(); }
		public static explicit operator List<ActionGroup>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<ActionGroup>().ToList<ActionGroup>(); }
		public static explicit operator List<VmOsType>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VmOsType>().ToList<VmOsType>(); }
		public static explicit operator List<roles>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<roles>().ToList<roles>(); }
		public static explicit operator List<vm_pools>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<vm_pools>().ToList<vm_pools>(); }
		public static explicit operator List<ServerCpu>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<ServerCpu>().ToList<ServerCpu>(); }
		public static explicit operator List<storage_domain_static>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<storage_domain_static>().ToList<storage_domain_static>(); }
		public static explicit operator List<storage_domains>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<storage_domains>().ToList<storage_domains>(); }
		public static explicit operator List<storage_server_connections>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<storage_server_connections>().ToList<storage_server_connections>(); }
		public static explicit operator List<tags>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<tags>().ToList<tags>(); }
		public static explicit operator List<vm_pool_map>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<vm_pool_map>().ToList<vm_pool_map>(); }
		public static explicit operator List<VmTemplate>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VmTemplate>().ToList<VmTemplate>(); }
		public static explicit operator List<bookmarks>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<bookmarks>().ToList<bookmarks>(); }
		public static explicit operator List<storage_pool>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<storage_pool>().ToList<storage_pool>(); }
		public static explicit operator List<VDS>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VDS>().ToList<VDS>(); }
		public static explicit operator List<VdsStatic>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VdsStatic>().ToList<VdsStatic>(); }
		public static explicit operator List<VDSGroup>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VDSGroup>().ToList<VDSGroup>(); }
		public static explicit operator List<VM>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<VM>().ToList<VM>(); }
		public static explicit operator List<DiskImageBase>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<DiskImageBase>().ToList<DiskImageBase>(); }
		public static explicit operator List<version>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<version>().ToList<version>(); }
		public static explicit operator List<AuditLog>(valueObject l) { return ((valueObjectEnumerableList)l).list.Cast<AuditLog>().ToList<AuditLog>(); }

		public static explicit operator List<Version>(valueObject l)
		{
			List<Version> VersionList = new List<Version>();
			foreach (version v in ((valueObjectEnumerableList)l).list.Cast<version>().ToList<version>())
			{
				VersionList.Add((Version)v);
			}
			return VersionList;
		}
		public static explicit operator Dictionary<string, Dictionary<string, Dictionary<string, string>>>(valueObject l)
		{
			valueObjectMap map = (valueObjectMap)((valueObjectSingle)l).value;
			Dictionary<string, Dictionary<string, Dictionary<string, string>>> dictionary = new Dictionary<string, Dictionary<string, Dictionary<string, string>>>();
			foreach (valueObjectPair valueObjectPair in map.valuePairs)
			{
				dictionary.Add((string)valueObjectPair.key, new Dictionary<string, Dictionary<string, string>>());
				foreach (valueObjectPair valueObjectPair1 in ((valueObjectMap)valueObjectPair.value).valuePairs)
				{
					dictionary[(string)valueObjectPair.key].Add((string)valueObjectPair1.key, new Dictionary<string, string>());
					foreach (valueObjectPair valueObjectPair2 in ((valueObjectMap)valueObjectPair1.value).valuePairs)
					{
						dictionary[(string)valueObjectPair.key][(string)valueObjectPair1.key].Add((string)valueObjectPair2.key, (string)valueObjectPair2.value);
					}
				}
			}
			return dictionary;
		}

		public static explicit operator List<KeyValuePair<string, string>>(valueObject l) { return ((valueObjectEnumerableMap)l).valuePairs.Select(n => new KeyValuePair<string, string>((string)n.Key, (string)n.Value)).ToList(); }
		public static explicit operator Dictionary<string, string>(valueObject l) { return ((valueObjectEnumerableMap)l).valuePairs.ToDictionary<KeyValuePair<object, object>, string, string>(n => (string)n.Key, n => (string)n.Value); }

		public static explicit operator KeyValuePair<string, string>(valueObject l) { return (KeyValuePair<string, string>)(KeyValuePairCompat)((valueObjectSingle)l).value; }
		public static explicit operator Dictionary<string, int>(valueObject l) { return ((valueObjectEnumerableMap)l).valuePairs.ToDictionary<KeyValuePair<object, object>, string, int>(n => (string)n.Key, n => (int)n.Value); }
		public static explicit operator Dictionary<VmTemplate, List<DiskImage>>(valueObject l) { return ((valueObjectEnumerableMap)l).valuePairs.ToDictionary<KeyValuePair<object, object>, VmTemplate, List<DiskImage>>(n => (VmTemplate)n.Key, n => (List<DiskImage>)(DiskImageList)n.Value); }
		public static explicit operator Dictionary<ImportCandidateSourceEnum, Dictionary<string, ImportCandidateInfoBase>>(valueObject l) { throw new Exception("NYI"); } //ITAMAR-WEB

		public static explicit operator Dictionary<string, Dictionary<string, object>>(valueObject l)
		{
			return ((valueObjectMap)((valueObjectSingle)l).value).valuePairs.ToDictionary(a => (string)a.key, b => ((valueObjectMap)b.value).valuePairs.ToDictionary(c => (string)c.key, c => c.value));
		}
	}


	public partial class valueObjectMap
	{
		public valueObjectMap() { }

		// This c'tor is here in order to conform to the Java code, in which the only way
		// to get valueObjectMap object from a Map object is by using a parallel java c'tor.
		public valueObjectMap(Dictionary<string, string> dict, bool mapOfMaps)
			: this()
		{
			this.valuePairs = new valueObjectPair[dict.Count];
			int i = 0;
			foreach (KeyValuePair<string, string> item in dict)
			{
				this.valuePairs[i] = new valueObjectPair() { key = item.Key, value = item.Value };
				i++;
			}
		}

		public static implicit operator valueObjectMap(Dictionary<string, string> l)
		{
			valueObjectMap map = new valueObjectMap();
			map.valuePairs = new valueObjectPair[l.Count];
			int i = 0;
			foreach (KeyValuePair<string, string> item in l)
			{
				map.valuePairs[i] = new valueObjectPair() { key = item.Key, value = item.Value };
				i++;
			}
			return map;
		}

		public static implicit operator valueObjectMap(Dictionary<string, Dictionary<string, string>> l)
		{
			valueObjectMap map = new valueObjectMap();
			map.valuePairs = new valueObjectPair[l.Count];
			int i = 0;
			foreach (KeyValuePair<string, Dictionary<string, string>> item in l)
			{
				map.valuePairs[i] = new valueObjectPair() { key = item.Key, value = item.Value };
				i++;
			}
			return map;
		}

		public static explicit operator valueObjectMap(Dictionary<string, DiskImageBase> l)
		{
			valueObjectMap map = new valueObjectMap();
			map.valuePairs = new valueObjectPair[l.Count];
			int i = 0;
			foreach (KeyValuePair<string, DiskImageBase> item in l)
			{
				map.valuePairs[i] = new valueObjectPair() { key = item.Key, value = item.Value };
				i++;
			}
			return map;
		}

		public static implicit operator valueObjectMap(Dictionary<string, DiskImage> l)
		{
			valueObjectMap map = new valueObjectMap();
			map.valuePairs = new valueObjectPair[l.Count];
			int i = 0;
			foreach (KeyValuePair<string, DiskImage> item in l)
			{
				map.valuePairs[i] = new valueObjectPair() { key = item.Key, value = item.Value };
				i++;
			}
			return map;
		}

		public static implicit operator Dictionary<string, DiskImage>(valueObjectMap l)
		{
			Dictionary<string, DiskImage> dReturn = new Dictionary<string, DiskImage>();
			valueObjectPair[] vopaPairs = l.valuePairs;
			foreach (KeyValuePair<object, object> item in vopaPairs)
			{
				dReturn.Add((string)item.Key, (DiskImage)item.Value);
			}
			return dReturn;
		}

		public static implicit operator Dictionary<string, string>(valueObjectMap l)
		{
			return ((valueObjectEnumerableMap)l).valuePairs.ToDictionary(n => (string)n.Key, n => (string)n.Value);
		}
	}
	public partial class VM
	{
		[XmlIgnore]
		public Dictionary<string, DiskImage> DiskMap
		{
			get
			{
				return ((valueObjectEnumerableMap)this.DiskValueObjectMap).valuePairs.ToDictionary<KeyValuePair<object, object>, string, DiskImage>(n => (string)n.Key, n => (DiskImage)n.Value);
			}
		}
	}

	public partial class VmTemplate
	{
		[XmlIgnore]
		public int DiskMapCount
		{
			get { return ((valueObjectEnumerableMap) this.DiskImageMap).valuePairs.Count; }
		}
	}

	public partial class MoveOrCopyParameters
	{
		[XmlIgnore]
		public Dictionary<string, DiskImageBase> DiskInfoList
		{
			get
			{
				return ((valueObjectEnumerableMap)this.DiskInfoValueObjectMap).valuePairs.ToDictionary<KeyValuePair<object, object>, string, DiskImageBase>(n => (string)n.Key, n => (DiskImageBase)n.Value);
			}
			set
			{
				this.DiskInfoValueObjectMap = (valueObjectMap)value;
			}
		}
	}

	public partial class valueObjectPair
	{
		public static explicit operator KeyValuePair<string, string>(valueObjectPair l)
		{
			return new KeyValuePair<string, string>((String)l.key, (String)l.value);
		}
		public static explicit operator KeyValuePair<object, object>(valueObjectPair l)
		{
			return new KeyValuePair<object, object>(l.key, l.value);
		}
	}
	public partial class ListIVdcQueryableUpdatedData
	{
		public ListIVdcQueryableUpdatedData() { }
		public ListIVdcQueryableUpdatedData(ListIVdcQueryableUpdatedData l)
		{
			this.added = l.added;
			this.removed = l.removed;
			this.updated = l.updated;
			this.faulted = l.faulted;
		}
		[XmlIgnore]
		public Dictionary<object, IVdcQueryable> Added { get { if (this.added == null) return new Dictionary<object, IVdcQueryable>(); else return this.added.ToDictionary<ListIVdcQueryableUpdatedDataEntry, object, IVdcQueryable>(n => n.key, n => n.value); } }
		[XmlIgnore]
		public List<object> Removed { get { if (this.removed == null) return new List<object>(); else return this.removed.ToList(); } }
		[XmlIgnore]
		public Dictionary<object, IVdcQueryable> Updated { get { if (this.updated == null) return new Dictionary<object, IVdcQueryable>(); else return this.updated.ToDictionary<ListIVdcQueryableUpdatedDataEntry1, object, IVdcQueryable>(n => n.key, n => n.value); } }
		[XmlIgnore]
		public KeyValuePair<VdcActionType, VdcFault> Faulted { get { if (this.faulted == null) return new KeyValuePair<VdcActionType, VdcFault>(); else return new KeyValuePair<VdcActionType, VdcFault>((VdcActionType)this.faulted.key, (VdcFault)this.faulted.value); } }
	}

	public class valueObjectEnumerableList : valueObject, System.Collections.IEnumerable
	{

		public valueObjectEnumerableList(object[] l)
		{
			if (l == null)
			{
				this.listField = new List<object>();
			}
			else
			{
				this.listField = l.ToList();
			}
		}
		private List<Object> listField;

		public List<Object> list
		{
			get
			{
				return listField;
			}
		}
		#region IEnumerable Members

		public System.Collections.IEnumerator GetEnumerator()
		{
			return listField.GetEnumerator();
		}
		#endregion

	}
	public class valueObjectEnumerableMap : valueObject, System.Collections.IEnumerable
	{

		public valueObjectEnumerableMap(valueObjectPair[] l)
		{
			if (l == null)
			{
				this.valuePairsField = new List<KeyValuePair<object, object>>();
			}
			else
			{
				this.valuePairsField = l.Select(n => new KeyValuePair<object, object>(n.key, n.value)).ToList();
			}
		}
		private List<KeyValuePair<object, object>> valuePairsField;

		public List<KeyValuePair<object, object>> valuePairs
		{
			get
			{
				return valuePairsField;
			}
		}
		public static implicit operator valueObjectEnumerableMap(valueObjectMap map)
		{
			if (map == null)
			{
				return new valueObjectEnumerableMap(new valueObjectPair[] { });
			}
			return new valueObjectEnumerableMap(map.valuePairs);
		}
		#region IEnumerable Members

		public System.Collections.IEnumerator GetEnumerator()
		{
			return valuePairsField.GetEnumerator();
		}

		#endregion
	}

	public partial class VdcQueryReturnValue
	{
		public valueObject ReturnValue
		{
			get
			{
				if (ReturnValueWrapper is valueObjectList)
				{
					ReturnValueWrapper = new valueObjectEnumerableList(((valueObjectList)ReturnValueWrapper).list);
				}
				else if (ReturnValueWrapper is valueObjectMap)
				{
					ReturnValueWrapper = new valueObjectEnumerableMap(((valueObjectMap)ReturnValueWrapper).valuePairs);
				}
				else if (ReturnValueWrapper is valueObjectSingle)
				{
					//replace the wrapper object with null, if it's content is null
					if (((valueObjectSingle)ReturnValueWrapper).value == null)
						ReturnValueWrapper = null;
				}
				return ReturnValueWrapper;
			}
		}
	}

	public partial class UIQueryReturnValue
	{
		public valueObject ReturnValue
		{
			get
			{
				if (ReturnValueWrapper is valueObjectList)
				{
					ReturnValueWrapper = new valueObjectEnumerableList(((valueObjectList)ReturnValueWrapper).list);
				}
				else if (ReturnValueWrapper is valueObjectMap)
				{
					ReturnValueWrapper = new valueObjectEnumerableMap(((valueObjectMap)ReturnValueWrapper).valuePairs);
				}
				else if (ReturnValueWrapper is valueObjectSingle)
				{
					//replace the wrapper object with null, if it's content is null
					if (((valueObjectSingle)ReturnValueWrapper).value == null)
						ReturnValueWrapper = null;
				}
				return ReturnValueWrapper;
			}
		}
	}

	#region guid[] handling

	public partial class VdcReturnValueBase
	{
		[XmlIgnore]
		public Guid[] TaskIdList
		{
			get { return this.TaskIdListGuidArray.GuidArray(); }
			set { this.TaskIdListGuidArray = value.GuidArray(); }
		}
	}
	public partial class StoragePoolWithStoragesParameter
	{
		[XmlIgnore]
		public Guid[] Storages
		{
			get { return this.StoragesGuidArray.GuidArray(); }
			set { this.StoragesGuidArray = value.GuidArray(); }
		}
	}
	public partial class RemoveImageParameters
	{
		[XmlIgnore]
		public Guid[] ImagesToRemoveList
		{
			get { return this.ImagesToRemoveListGuidArray.GuidArray(); }
			set { this.ImagesToRemoveListGuidArray = value.GuidArray(); }
		}
	}
	public partial class AttachEntityToTagParameters
	{
		[XmlIgnore]
		public Guid[] _entitiesId
		{
			get { return this._entitiesIdGuidArray.GuidArray(); }
			set { this._entitiesIdGuidArray = value.GuidArray(); }
		}
	}
	public partial class VmTemplateParametersBase
	{
		[XmlIgnore]
		public List<Guid> StorageDomainsList
		{
			get { return this.StorageDomainsListGuidArray.Cast<Guid>().ToList(); }
			set { this.StorageDomainsListGuidArray = value.GuidArray(); }
		}
	}
	public partial class asyncQueryResults
	{
		[XmlIgnore]
		public Guid[] queryIDs
		{
			get { return this.QueryIDsGuidArray.GuidArray(); }
			set { this.QueryIDsGuidArray = value.GuidArray(); }
		}
	}
	public partial class GetAllFromExportDomainQueryParamenters
	{
		[XmlIgnore]
		public Guid[] Ids
		{
			get { return this.IdsGuidArray.GuidArray(); }
			set { this.IdsGuidArray = value.GuidArray(); }
		}
	}
	public partial class GetTasksStatusesByTasksIDsParameters
	{
		[XmlIgnore]
		public Guid[] TaskIDs
		{
			get { return this.TaskIDsGuidArray.GuidArray(); }
			set { this.TaskIDsGuidArray = value.GuidArray(); }
		}
	}
	public partial class version
	{
		public static implicit operator version(Version v)
		{
			return v == null ? null : new version()
			{
				value = v.ToString()
			};
		}
		public static implicit operator Version(version v)
		{
			return v == null ? null : new Version(v.value);
		}
		public override string ToString()
		{
			return ((Version)this).ToString();
		}
		public int compareTo(version v)
		{
			return ((Version)this).CompareTo(v);
		}

	}

	public partial class tags
	{
		[XmlIgnore]
		public List<tags> Children
		{
			get { return ChildrenArray.ToList(); }
			set { ChildrenArray = value.ToArray(); }
		}
	}

	#endregion

	public partial class CreateAllSnapshotsFromVmParameters
	{
		[XmlIgnore]
		public List<string> DisksList
		{
			get { return this.DisksListJport.ToList(); }
			set { this.DisksListJport = value.ToArray(); }
		}
	}

	public partial class AddSANStorageDomainParameters
	{
		[XmlIgnore]
		public List<string> LunIds
		{
			get { return this.LunIdsJport.ToList(); }
			set { this.LunIdsJport = value.ToArray(); }
		}
	}

	public partial class RoleWithActionGroupsParameters
	{
		[XmlIgnore]
		public List<ActionGroup> ActionGroups
		{
			get { return this.ActionGroupsJport.ToList(); }
			set { this.ActionGroupsJport = value.ToArray(); }
		}
	}

	public partial class ActionGroupsToRoleParameter
	{
		[XmlIgnore]
		public List<ActionGroup> ActionGroups
		{
			get { return this.ActionGroupsJport.ToList(); }
			set { this.ActionGroupsJport = value.ToArray(); }
		}
	}
}

namespace org.ovirt.engine.ui.genericapi.parameters
{
	class DummyGenericApiParameters
	{
	}
}

namespace org.ovirt.engine.ui.genericapi.returnvalues
{
	class DummyGenericApiReturnValues
	{
	}
}

namespace org.ovirt.engine.ui.genericapi.uiqueries
{
	class DummyGenericApiUIQueries
	{
	}
}

