package org.ovirt.engine.ui.uicommon.models.userportal;
import java.util.Collections;
import org.ovirt.engine.core.compat.*;
import org.ovirt.engine.ui.uicompat.*;
import org.ovirt.engine.core.common.businessentities.*;
import org.ovirt.engine.core.common.vdscommands.*;
import org.ovirt.engine.core.common.queries.*;
import org.ovirt.engine.core.common.action.*;
import org.ovirt.engine.ui.frontend.*;
import org.ovirt.engine.ui.uicommon.*;
import org.ovirt.engine.ui.uicommon.models.*;
import org.ovirt.engine.core.common.*;

import org.ovirt.engine.ui.uicommon.dataprovider.*;
import org.ovirt.engine.core.common.businessentities.*;

import org.ovirt.engine.core.common.users.*;
import org.ovirt.engine.ui.uicommon.validation.*;
import org.ovirt.engine.ui.uicommon.*;
import org.ovirt.engine.ui.uicommon.models.*;

@SuppressWarnings("unused")
public class UserPortalLoginModel extends LoginModel
{

	private UICommand privateChangePasswordCommand;
	public UICommand getChangePasswordCommand()
	{
		return privateChangePasswordCommand;
	}
	public void setChangePasswordCommand(UICommand value)
	{
		privateChangePasswordCommand = value;
	}



	private EntityModel privateNewPassword;
	public EntityModel getNewPassword()
	{
		return privateNewPassword;
	}
	private void setNewPassword(EntityModel value)
	{
		privateNewPassword = value;
	}
	private EntityModel privateVerifyPassword;
	public EntityModel getVerifyPassword()
	{
		return privateVerifyPassword;
	}
	private void setVerifyPassword(EntityModel value)
	{
		privateVerifyPassword = value;
	}
	private EntityModel privateIsAutoConnect;
	public EntityModel getIsAutoConnect()
	{
		return privateIsAutoConnect;
	}
	private void setIsAutoConnect(EntityModel value)
	{
		privateIsAutoConnect = value;
	}

	private boolean isChangingPassword;
	public boolean getIsChangingPassword()
	{
		return isChangingPassword;
	}
	public void setIsChangingPassword(boolean value)
	{
		if (isChangingPassword != value)
		{
			isChangingPassword = value;
			OnPropertyChanged(new PropertyChangedEventArgs("IsChangingPassword"));
		}
	}

	public static final String RHEVMUserRoleId = "00000000-0000-0000-0001-000000000001";
	public Guid Everyone = new Guid("eee00000-0000-0000-0000-123456789eee");
	public Guid Blank = new Guid("00000000-0000-0000-0000-000000000000");
	public Guid UserTemplateBasedVM = new Guid("def00009-0000-0000-0000-def000000009");

	private VdcUser privateLoggedUser;
	public VdcUser getLoggedUser()
	{
		return privateLoggedUser;
	}
	protected void setLoggedUser(VdcUser value)
	{
		privateLoggedUser = value;
	}
	private EntityModel privateIsRHEVMUser;
	public EntityModel getIsRHEVMUser()
	{
		return privateIsRHEVMUser;
	}
	public void setIsRHEVMUser(EntityModel value)
	{
		privateIsRHEVMUser = value;
	}
	private java.util.ArrayList<ActionGroup> privateLoggedUserActionGroupList;
	public java.util.ArrayList<ActionGroup> getLoggedUserActionGroupList()
	{
		return privateLoggedUserActionGroupList;
	}
	public void setLoggedUserActionGroupList(java.util.ArrayList<ActionGroup> value)
	{
		privateLoggedUserActionGroupList = value;
	}
	private java.util.ArrayList<ActionGroup> privateRHEVMUserActionGroupList;
	public java.util.ArrayList<ActionGroup> getRHEVMUserActionGroupList()
	{
		return privateRHEVMUserActionGroupList;
	}
	public void setRHEVMUserActionGroupList(java.util.ArrayList<ActionGroup> value)
	{
		privateRHEVMUserActionGroupList = value;
	}
	private int privateRolesCounter;
	public int getRolesCounter()
	{
		return privateRolesCounter;
	}
	public void setRolesCounter(int value)
	{
		privateRolesCounter = value;
	}


	public UserPortalLoginModel()
	{
		setChangePasswordCommand(new UICommand("ChangePassword", this));

		setNewPassword(new EntityModel());
		setVerifyPassword(new EntityModel());

		EntityModel tempVar = new EntityModel();
		tempVar.setEntity(true);
		setIsRHEVMUser(tempVar);
		EntityModel tempVar2 = new EntityModel();
		tempVar2.setEntity(true);
		setIsAutoConnect(tempVar2);
	}

	@Override
	public void Login()
	{
		//Completely override the base class functionality.

		if (!Validate())
		{
			return;
		}

		//Clear config cache on login (to make sure we don't use old config in a new session)
		DataProvider.ClearConfigCache();


		Frontend.RunAction(VdcActionType.LoginUser, new LoginUserParameters((String)getUserName().getEntity(), (String)getPassword().getEntity(), (String)getDomain().getSelectedItem(), "", "", ""),
		new IFrontendActionAsyncCallback() {
			@Override
			public void Executed(FrontendActionAsyncResult  result) {

			UserPortalLoginModel model = (UserPortalLoginModel)result.getState();
			VdcReturnValueBase returnValue = result.getReturnValue();
			boolean success = returnValue != null && returnValue.getSucceeded();
			if (success)
			{
				model.setLoggedUser((VdcUser)returnValue.getActionReturnValue());
				model.getLoggedInEvent().raise(this, EventArgs.Empty);
			}
			else
			{
				model.getPassword().setEntity("");
				if (returnValue != null)
				{
					model.setMessage(Linq.FirstOrDefault(returnValue.getCanDoActionMessages()));
				}
				model.getLoginFailedEvent().raise(this, EventArgs.Empty);
			}

			}
		}, this);
	}

	private void ChangePassword()
	{
		VdcReturnValueBase returnValue = Frontend.RunAction(VdcActionType.ChangeUserPassword, new ChangeUserPasswordParameters((String)getUserName().getEntity(), (String)getPassword().getEntity(), (String)getNewPassword().getEntity(), (String)getDomain().getSelectedItem()));

		if (returnValue != null && returnValue.getSucceeded())
		{
			//TODO:
		}
	}

	@Override
	protected boolean Validate()
	{
		boolean baseValidation = super.Validate();

		if (getIsChangingPassword())
		{
			getNewPassword().ValidateEntity(new IValidation[] { new NotEmptyValidation() });
			getVerifyPassword().ValidateEntity(new IValidation[] { new NotEmptyValidation() });

			//Check that the verify password field matches new password.
			if (!((String)getNewPassword().getEntity()).equals((String)getVerifyPassword().getEntity()))
			{
				getVerifyPassword().setIsValid(false);
				getVerifyPassword().getInvalidityReasons().add("TODO: Verify password field doesn't match a new password.");
			}
		}

		return baseValidation && getNewPassword().getIsValid() && getVerifyPassword().getIsValid();
	}

	@Override
	public void ExecuteCommand(UICommand command)
	{
		super.ExecuteCommand(command);

		if (command == getChangePasswordCommand())
		{
			ChangePassword();
		}
	}


	// Update IsRHEVMUser flag.
	// Get 'RHEVMUser' role's ActionGroups (and proceed to Step2).
	public void UpdateIsRHEVMUser(VdcUser LoggedUser)
	{
		setRHEVMUserActionGroupList(new java.util.ArrayList<ActionGroup>());
		this.setLoggedUser(LoggedUser);

		AsyncDataProvider.GetRoleActionGroupsByRoleId(new AsyncQuery(this,
		new INewAsyncCallback() {
			@Override
			public void OnSuccess(Object target, Object returnValue) {

			UserPortalLoginModel loginModel = (UserPortalLoginModel)target;
			loginModel.setRHEVMUserActionGroupList((java.util.ArrayList<ActionGroup>)returnValue);
			loginModel.GetUserRoles(loginModel);

			}
		}), new Guid(RHEVMUserRoleId));
	}

	// Get logged user's permissions and create a list of roles associated with the user (and proceed to Step3).
	// Use only as 'Step2' of 'UpdateIsRHEVMUser'
	public void GetUserRoles(Object targetObject)
	{
		UserPortalLoginModel loginModel = (UserPortalLoginModel)targetObject;
		AsyncDataProvider.GetPermissionsByAdElementId(new AsyncQuery(targetObject,
		new INewAsyncCallback() {
			@Override
			public void OnSuccess(Object target, Object returnValue) {

			java.util.ArrayList<permissions> permissions = (java.util.ArrayList<permissions>)returnValue;
			java.util.ArrayList<Guid> roleIdList = new java.util.ArrayList<Guid>();
			for (permissions permission : permissions)
			{
				if (IsEveryoneUserPortalBasedVmPermission(permission))
				{
					continue;
				}
				if (!roleIdList.contains(permission.getrole_id()))
				{
					roleIdList.add(permission.getrole_id());
				}
			}
			UserPortalLoginModel loginModel1 = (UserPortalLoginModel)target;
			loginModel1.setLoggedUserActionGroupList(new java.util.ArrayList<ActionGroup>());
			if (roleIdList.size() > 0)
			{
				loginModel1.setRolesCounter(roleIdList.size());
				loginModel1.UpdateUserActionGroups(loginModel1, roleIdList);
			}
			else
			{
				CheckIsRHEVMUser(loginModel1);
			}

			}
		}), loginModel.getLoggedUser().getUserId());
	}

	/**
	 Determines whether a given permission is a permission on Everyone associated with the "UserTemplateBasedVM" Role.

	 @param permission given permission
	 @return True if permission is on Everyone and associated with the "UserTemplateBasedVM" Role, false otherwise.
	*/
	public boolean IsEveryoneUserPortalBasedVmPermission(permissions permission)
	{
		return permission.getad_element_id().getValue().equals(Everyone) && permission.getrole_id().getValue().equals(UserTemplateBasedVM);
	}

	// Create a list of ActionGroups associated with the user by retrieving each role's ActionGroups (and proceed to Step4).
	// Use only as 'Step3' of 'UpdateIsRHEVMUser'
	public void UpdateUserActionGroups(Object targetObject, java.util.ArrayList<Guid> roleIdList)
	{
		for (Guid roleID : roleIdList)
		{
			AsyncDataProvider.GetRoleActionGroupsByRoleId(new AsyncQuery(targetObject,
		new INewAsyncCallback() {
			@Override
			public void OnSuccess(Object target, Object returnValue) {

				UserPortalLoginModel loginModel = (UserPortalLoginModel)target;
				java.util.ArrayList<ActionGroup> roleActionGroupList = (java.util.ArrayList<ActionGroup>)returnValue;
				for (ActionGroup actionGroup : roleActionGroupList)
				{
					if (!loginModel.getLoggedUserActionGroupList().contains(actionGroup))
					{
						loginModel.getLoggedUserActionGroupList().add(actionGroup);
					}
				}
					loginModel.setRolesCounter(loginModel.getRolesCounter() - 1);
				if (loginModel.getRolesCounter() == 0)
				{
					CheckIsRHEVMUser(loginModel);
				}

			}
		}), roleID);
		}
	}

	// If 'LoggedUserActionGroupList' contains an ActionGroup that doesn't exist in RHEVMUserActionGroupList
	// the logged user is not 'RHEVMUser' - Update IsRHEVMUser to false; Otherwise, true.
	// Raise 'LoggedIn' event after updating the flag.
	// Use only as 'Step4' of 'UpdateIsRHEVMUser'
	public void CheckIsRHEVMUser(Object targetObject)
	{
		UserPortalLoginModel loginModel = (UserPortalLoginModel)targetObject;
		loginModel.getIsRHEVMUser().setEntity(null);
		boolean isRHEVMUser = true;

		for (ActionGroup actionGroup : loginModel.getLoggedUserActionGroupList())
		{
			if (!loginModel.getRHEVMUserActionGroupList().contains(actionGroup))
			{
				isRHEVMUser = false;
				break;
			}
		}

		loginModel.getIsRHEVMUser().setEntity(isRHEVMUser);
	}
}