PRINT 'Processing storages_sp.sql'

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RethrowError')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].RethrowError AS RETURN')
END
GO

ALTER PROCEDURE RethrowError AS
    /* Return if there is no error information to retrieve. */
    IF ERROR_NUMBER() IS NULL
        RETURN;

    DECLARE
        @ErrorMessage    NVARCHAR(4000),
        @ErrorNumber     INT,
        @ErrorSeverity   INT,
        @ErrorState      INT,
        @ErrorLine       INT,
        @ErrorProcedure  NVARCHAR(200); 

    /* Assign variables to error-handling functions that
       capture information for RAISERROR. */

    SELECT
        @ErrorNumber = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE(),
        @ErrorLine = ERROR_LINE(),
        @ErrorProcedure = ISNULL(ERROR_PROCEDURE(), '-'); 

    /* Building the message string that will contain original
       error information. */

    SELECT @ErrorMessage = 
        N'Error %d, Level %d, State %d, Procedure %s, Line %d, ' + 
         'Message: '+ ERROR_MESSAGE(); 

    /* Raise an error: msg_str parameter of RAISERROR will contain
	   the original error information. */

    RAISERROR(@ErrorMessage, @ErrorSeverity, 1,
        @ErrorNumber,    /* parameter: original error number. */
        @ErrorSeverity,  /* parameter: original error severity. */
        @ErrorState,     /* parameter: original error state. */
        @ErrorProcedure, /* parameter: original error procedure name. */
        @ErrorLine       /* parameter: original error line number. */
        );

GO

----------------------------------------------------------------
-- [dbo].[storage_pool] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstorage_pool')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstorage_pool] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstorage_pool]
    @description nvarchar(max),
	@id uniqueidentifier,
	@name nvarchar(40),
	@storage_pool_type int,
	@status int,
	@master_domain_version int,
	@spm_vds_id uniqueidentifier = null,
	@compatibility_version nvarchar(40)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[storage_pool] ([description], [id], [name], [storage_pool_type],[status],[master_domain_version],[spm_vds_id],[compatibility_version])
	VALUES (@description, @id, @name, @storage_pool_type,@status,@master_domain_version,@spm_vds_id,@compatibility_version)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_pool')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestorage_pool] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_pool]
    @description nvarchar(max),
	@id uniqueidentifier,
	@name nvarchar(40),
	@storage_pool_type int,
	@status int,
	@storage_pool_format_type int,
	@master_domain_version int,
	@spm_vds_id uniqueidentifier = null,
	@compatibility_version nvarchar(40)
AS
BEGIN

	--The [dbo].[storage_pool] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[storage_pool] 
	SET [description] = @description, [name] = @name, [storage_pool_type] = @storage_pool_type, [status] =@status, [storage_pool_format_type] =@storage_pool_format_type, [master_domain_version] = @master_domain_version, [spm_vds_id] = @spm_vds_id, [compatibility_version] = @compatibility_version, _update_date = getdate() 
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_pool_status')
BEGIN
        EXEC('CREATE PROCEDURE [dbo].[Updatestorage_pool_status] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_pool_status]
        @id uniqueidentifier,
        @status int
AS
BEGIN

        SET NOCOUNT ON

        BEGIN TRY
        UPDATE [dbo].[storage_pool]
        SET [status] =@status,  _update_date = getdate()
        WHERE [id]=@id

    END TRY

    BEGIN CATCH
                EXEC RethrowError;
        END CATCH

        SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestorage_pool')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestorage_pool] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestorage_pool]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[storage_pool] WITH (UPDLOCK)
	WHERE [id] = @id
	
    DELETE FROM [dbo].[storage_pool]
	WHERE [id]=@id

	-- delete StoragePool permissions --
	DELETE FROM [dbo].[permissions] where object_id = @id 
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_pool')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_pool] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstorage_pool]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
FROM [dbo].[storage_pool] [storage_pool]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolByName] 
	@name nvarchar(40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
	WHERE [name]=@name

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolsByType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolsByType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolsByType] 
	@storage_pool_type int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
	WHERE [storage_pool_type]=@storage_pool_type

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolsByStorageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolsByStorageDomainId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolsByStorageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
	inner join [storage_pool_iso_map] on [storage_pool].id = [storage_pool_iso_map].storage_pool_id
	WHERE [storage_pool_iso_map].storage_id=@storage_domain_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolsByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolsByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolsByVdsId] 
	@vdsId uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

    DECLARE @clusterId uniqueidentifier

    SELECT @clusterId = vds_group_id
    FROM Vds_static
    WHERE vds_id = @vdsId 
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
    WHERE storage_pool.id in 
        (select storage_pool_id 
        FROM vds_groups 
        WHERE vds_group_id = @clusterId)

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_poolsByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_poolsByVdsGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_poolsByVdsGroupId] 
	@clusterId uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool].[description] AS 'description',
	[storage_pool].[id] AS 'id',
	[storage_pool].[name] AS 'name',
	[storage_pool].[storage_pool_type] AS 'storage_pool_type',
	[storage_pool].[status] AS 'status',
	[storage_pool].[master_domain_version] AS 'master_domain_version',
	[storage_pool].[spm_vds_id] AS 'spm_vds_id',
	[storage_pool].[compatibility_version] AS 'compatibility_version',
	[storage_pool].[storage_pool_format_type] AS 'storage_pool_format_type'
	FROM [dbo].[storage_pool] [storage_pool]
    WHERE storage_pool.id in 
        (select storage_pool_id 
        FROM vds_groups 
        WHERE vds_group_id = @clusterId)

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[storage_domain_static] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstorage_domain_static')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstorage_domain_static] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstorage_domain_static]
    @id uniqueidentifier,
	@storage nvarchar(250),
	@storage_name nvarchar(250),
	@storage_type int,
	@storage_domain_type int,
	@storage_domain_format_type int
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[storage_domain_static] ([id], [storage],[storage_name], [storage_type], [storage_domain_type], [storage_domain_format_type])
	VALUES (@id, @storage, @storage_name, @storage_type, @storage_domain_type, @storage_domain_format_type)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_domain_static')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestorage_domain_static] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_domain_static]
    @id uniqueidentifier,
	@storage nvarchar(250),
	@storage_name nvarchar(250),
	@storage_type int,
	@storage_domain_type int
AS
BEGIN

	--The [dbo].[storage_domain_static] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[storage_domain_static] 
	SET [storage] = @storage, [storage_name] = @storage_name, [storage_type] = @storage_type, [storage_domain_type] = @storage_domain_type, _update_date = getdate()
	WHERE [id]=@id

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestorage_domain_static')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestorage_domain_static] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestorage_domain_static]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[storage_domain_static] WITH (UPDLOCK)
	WHERE [id] = @id
	
    DELETE FROM [dbo].[storage_domain_static]
	WHERE [id]=@id
    
	-- delete Storage permissions --
	DELETE FROM [dbo].[permissions] where object_id = @id 	

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_domain_static')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_domain_static] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstorage_domain_static]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_static].[id] AS 'id',
	[storage_domain_static].[storage] AS 'storage',
	[storage_domain_static].[storage_name] AS 'storage_name',
	[storage_domain_static].[storage_type] AS 'storage_type',
	[storage_domain_static].[storage_domain_type] AS 'storage_domain_type',
	[storage_domain_static].[storage_domain_format_type] AS 'storage_domain_format_type'
	FROM [dbo].[storage_domain_static] [storage_domain_static]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_staticByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_staticByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_domain_staticByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_static].[id] AS 'id',
	[storage_domain_static].[storage] AS 'storage',
	[storage_domain_static].[storage_name] AS 'storage_name',
	[storage_domain_static].[storage_type] AS 'storage_type',
	[storage_domain_static].[storage_domain_type] AS 'storage_domain_type',
	[storage_domain_static].[storage_domain_format_type] AS 'storage_domain_format_type'
	FROM [dbo].[storage_domain_static] [storage_domain_static]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_staticByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_staticByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_domain_staticByName] 
	@name nvarchar(250)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_static].[id] AS 'id',
	[storage_domain_static].[storage] AS 'storage',
	[storage_domain_static].[storage_name] AS 'storage_name',
	[storage_domain_static].[storage_type] AS 'storage_type',
	[storage_domain_static].[storage_domain_type] AS 'storage_domain_type',
	[storage_domain_static].[storage_domain_format_type] AS 'storage_domain_format_type'
	FROM [dbo].[storage_domain_static] [storage_domain_static]
	WHERE [storage_name]=@name

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_staticBystorage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_staticBystorage_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_domain_staticBystorage_pool_id] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_static_view].[id] AS 'id',
	[storage_domain_static_view].[storage] AS 'storage',
	[storage_domain_static_view].[storage_name] AS 'storage_name',
	[storage_domain_static_view].[storage_type] AS 'storage_type',
	[storage_domain_static_view].[storage_domain_type] AS 'storage_domain_type',
	[storage_domain_static_view].[storage_domain_format_type] AS 'storage_domain_format_type'
	FROM [dbo].[storage_domain_static_view] [storage_domain_static_view]
	WHERE [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domains_By_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domains_By_id] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domains_By_id] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
	[storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
    [storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains_without_storage_pools] [storage_domains]
	WHERE [id]=@id

	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domains_By_id_and_by_storage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domains_By_id_and_by_storage_pool_id] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domains_By_id_and_by_storage_pool_id] 
	@id uniqueidentifier,
	@storage_pool_id uniqueidentifier = null
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
	[storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
    [storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
	WHERE [id]=@id and [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domains_By_storagePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domains_By_storagePoolId] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domains_By_storagePoolId] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
	[storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
	[storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
	WHERE [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_domains')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_domains] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[GetAllFromstorage_domains] 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
    [storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
	[storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_staticBystorage_pool_type')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_staticBystorage_pool_type] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domain_staticBystorage_pool_type] 
	@storage_pool_type int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_static].[id] AS 'id',
	[storage_domain_static].[storage] AS 'storage',
	[storage_domain_static].[storage_name] AS 'storage_name',
	[storage_domain_static].[storage_type] AS 'storage_type',
	[storage_domain_static].[storage_domain_type] AS 'storage_domain_type',
	[storage_domain_static].[storage_domain_format_type] AS 'storage_domain_format_type'
	FROM [dbo].[storage_domain_static] [storage_domain_static]
	WHERE [storage_type]=@storage_pool_type

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_staticBystorage_type_and_storage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_staticBystorage_type_and_storage_pool_id] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domain_staticBystorage_type_and_storage_pool_id] 
	@storage_type int,
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
	[storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
	WHERE [storage_pool_id]=@storage_pool_id and [storage_type]=@storage_type

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Force_Delete_storage_domain')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Force_Delete_storage_domain] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Force_Delete_storage_domain]
	 @storage_domain_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	-- delete the map between the domain to templates that was copied to it
	delete image_group_storage_domain_map where storage_domain_id = @storage_domain_id

	-- update images that their first storage domain was this and are on other domains (set the storage_id field to any other domain)
	update images set storage_id = 
	(select top 1 storage_domain_id from image_group_storage_domain_map map where images.image_group_id = map.image_group_id)
	where storage_id = @storage_domain_id and image_group_id in
	(select image_group_id from image_group_storage_domain_map)

	-- delete relations that are now duplicate because of the previous update action
	delete image_group_storage_domain_map where image_group_id in 
		(select images.image_group_id from images, image_group_storage_domain_map imap 
		where images.image_group_id = imap.image_group_id and images.storage_id = imap.storage_domain_id)
	
    select vmt_guid
	into #tempTemplatesTable
	from vm_template_disk where vtim_it_guid in 
			(select image_guid from images where storage_id = @storage_domain_id)

	select it_guid 
	into #tempTemplateImagesTable
	from vm_template_image_map where vmt_guid in 
			(select vmt_guid from #tempTemplatesTable)

	delete vm_static where vm_guid in 
			(select vm_guid from vm_images_view where storage_id = @storage_domain_id)
			or vmt_guid in (select vmt_guid from #tempTemplatesTable)

	delete images where storage_id = @storage_domain_id

	delete vm_template_image_map where vmt_guid in
			(select vmt_guid from #tempTemplatesTable)

	delete image_templates where it_guid in 
			(select it_guid from #tempTemplateImagesTable)

	delete vm_interface where vmt_guid in
			(select vmt_guid from #tempTemplatesTable)

	delete from vm_templates where vmt_guid in
			(select vmt_guid from #tempTemplatesTable)

	delete storage_domain_dynamic where id  = @storage_domain_id
	delete storage_domain_static where id  = @storage_domain_id
    
    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domains_By_imageGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domains_By_imageGroupId] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domains_By_imageGroupId] 
	@image_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
    [storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
	[storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
		INNER JOIN image_group_storage_domain_map as map on [storage_domains].id = map.storage_domain_id
	WHERE map.[image_group_id]=@image_group_id

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domains_List_By_storageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domains_List_By_storageDomainId] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domains_List_By_storageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domains].[id] AS 'id',
	[storage_domains].[storage] AS 'storage',
	[storage_domains].[storage_name] AS 'storage_name',
	[storage_domains].[storage_pool_id] AS 'storage_pool_id',
	[storage_domains].[storage_type] AS 'storage_type',
	[storage_domains].[storage_pool_name]	AS 'storage_pool_name',
	[storage_domains].[storage_domain_type] AS 'storage_domain_type',
	[storage_domains].[storage_domain_format_type] AS 'storage_domain_format_type',
	[storage_domains].[available_disk_size]	AS 'available_disk_size',
	[storage_domains].[used_disk_size]	AS 'used_disk_size',
	[storage_domains].[commited_disk_size]	AS 'commited_disk_size',
	[storage_domains].[status]	AS 'status',
	[storage_domains].[storage_domain_shared_status] AS 'storage_domain_shared_status'
	FROM [dbo].[storage_domains] [storage_domains]
	WHERE [storage_domains].[id]=@storage_domain_id

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domainsId_By_imageGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domainsId_By_imageGroupId] AS RETURN')
END
GO
ALTER PROCEDURE [dbo].[Getstorage_domainsId_By_imageGroupId] 
	@image_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT [images].storage_id AS storage_id FROM [dbo].images 
	WHERE  [images].image_group_id = @image_group_id
        UNION 
        SELECT [image_group_storage_domain_map].storage_domain_id AS storage_id FROM [dbo].image_group_storage_domain_map 
	WHERE [image_group_storage_domain_map].image_group_id = @image_group_id

	SET NOCOUNT OFF
END
GO
