using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models.userportal;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using VdcCommon.BusinessEntities;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class VmListView
	{
		private WindowView view1;
		private WindowView view2;
		private WindowView view3;

		public new VmListModel Model
		{
			get { return base.Model as VmListModel; }
			set { base.Model = value; }
		}

		[Dependency]
		public Shell Shell { get; set; }


		public VmListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewServerCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ServerView>();
					}
					else if (Model.LastExecutedCommand == Model.NewDesktopCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DesktopView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						UnitVmModel model = (UnitVmModel)Model.Window;
						view1 = model.VmType == VmType.Server
							? (WindowView)TypeResolver.Instance.Resolve<ServerView>()
							: TypeResolver.Instance.Resolve<DesktopView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else if (Model.LastExecutedCommand == Model.StopCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ConfirmationView>();
					}
					else if (Model.LastExecutedCommand == Model.ShutdownCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ConfirmationView>();
					}
					else if (Model.LastExecutedCommand == Model.MigrateCommand)
					{
						view1 = TypeResolver.Instance.Resolve<MigrateView>();
					}
					else if (Model.LastExecutedCommand == Model.NewTemplateCommand)
					{
						view1 = TypeResolver.Instance.Resolve<NewTemplateView>();
					}
					else if (Model.LastExecutedCommand == Model.RunOnceCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RunOnceView>();
					}
					else if (Model.LastExecutedCommand == Model.ExportCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ExportVmView>();
					}
					else if (Model.LastExecutedCommand == Model.MoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<FindSingleStorageView>();
					}
					else if (Model.LastExecutedCommand == Model.AssignTagsCommand)
					{
						view1 = TypeResolver.Instance.Resolve<AssignTagsView>();
					}
					else if (Model.LastExecutedCommand == Model.GuideCommand)
					{
						view1 = TypeResolver.Instance.Resolve<VmGuideView>();
					}
					else if (Model.Window is ConfirmationModel)
					{
						view1 = TypeResolver.Instance.Resolve<ConfirmationView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}

			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ExportConfirmationView>();
					WindowManager.AddWindow(view2);
					view2.Model = Model.ConfirmWindow;
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}

			if (e.PropertyName == "ErrorWindow")
			{
				if (Model.ErrorWindow != null)
				{
					view3 = TypeResolver.Instance.Resolve<ConfirmationView>();
					WindowManager.AddWindow(view3);
					view3.Model = Model.ErrorWindow;
				}
				else
				{
					WindowManager.RemoveWindow(view3);
					view3 = null;
				}
			}
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.NewServerCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void ChangeCD_OnSubmenuOpened(object sender, RoutedEventArgs e)
		{
			Model.RetrieveIsoImagesCommand.Execute();
		}

		private void ChangeCDButton_Click(object sender, RoutedEventArgs e)
		{
			MenuItem menuItem = (MenuItem)e.OriginalSource;
			var model = (ChangeCDModel)menuItem.DataContext;
			model.DoCommand.Execute();
		}

		private void GuideMeButton_Click(object sender, RoutedEventArgs e)
		{
			if (Model.Window != null && Model.Window.GetType() == typeof(VmGuideModel))
			{
				return;
			}
			VM vm = (VM)Model.SelectedItem;
			Model.GuideContext = vm.vm_guid;
			Model.GuideCommand.Execute();
		}
	}
}
