﻿using System;
using System.ComponentModel;
using System.Windows;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon.models.configure.roles_ui;

namespace UI.WPFClient
{
	public partial class RolePermissionListView
	{
		private WindowView view;

		public RolePermissionListView()
		{
			InitializeComponent();
		}

		public new RolePermissionListModel Model
		{
			get { return base.Model as RolePermissionListModel; }
			set { base.Model = value; }
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.RemoveCommand)
				{
					view = TypeResolver.Instance.Resolve<RemoveView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}
	}
}
