using System;
using System.Globalization;
using System.Threading;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class TimeFormatValidation : IValidation
	{
		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			if (value != null && value is String && !((string)value).Equals(String.Empty))
			{
				CultureInfo ci = CultureInfo.CurrentCulture;
				DateTime dtValue;

				if (!DateTime.TryParseExact((string)value, "t", ci.DateTimeFormat, DateTimeStyles.None, out dtValue))
				{
					result.Success = false;
					result.Reasons.Add("The field must contain a time value");
				}
			}

			return result;
		}
	}
}