using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class MoveHost : ListModel
	{
		#region Properties

		public ListModel Cluster { get; private set; }

		public List<VDS> SelectedHosts { get; set; }

		#endregion

		public MoveHost()
		{
			Cluster = new ListModel();
			//Cluster.ValueChanged += new EventHandler(Cluster_ValueChanged);
			Cluster.SelectedItemChangedEvent.addListener(this);
		}

		void Cluster_SelectedItemChanged()
		{
			if (Cluster.SelectedItem != null)
			{
				VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
				//IEnumerable<VDSGroup> clusters = Cluster.Options.Cast<VDSGroup>();

				List<VDSGroup> clusters = (List<VDSGroup>)Cluster.Items;
				//var hosts = DataProvider.GetHostList()
				//.Where(a => clusters.All(b => b.ID != a.vds_group_id)
				//     && (a.status == VDSStatus.Maintenance || a.status == VDSStatus.PendingApproval)
				//    && (a.Version.FullVersion == null || a.Version.FullVersion.GetFriendlyVersion() >= cluster.compatibility_version))
				//.ToList();
				//var items = hosts.Select(a => new EntityModel() { Entity = a }).ToList();

				List<VDS> hosts = DataProvider.GetHostList();
				List<EntityModel> items = new List<EntityModel>();
				foreach (VDS vds in hosts)
				{
					if (Linq.FirstOrDefault(clusters, new Linq.ClusterPredicate(vds.vds_group_id)) == null
						&& (vds.status == VDSStatus.Maintenance || vds.status == VDSStatus.PendingApproval)
						&& (vds.Version.FullVersion == null || Extensions.GetFriendlyVersion(vds.Version.FullVersion).CompareTo(cluster.compatibility_version) >= 0))
					{
						EntityModel entity = new EntityModel();
						entity.Entity = vds;
						items.Add(entity);
					}
				}


				//IEnumerable<int> previouslySelectedHostIDs = new List<int>();
				List<Guid> previouslySelectedHostIDs = new List<Guid>();
				if (Items != null)
				{
					//previouslySelectedHostIDs =
					//    Items.Cast<EntityModel>().Where(a => Selector.GetIsSelected(a)).Select(a => (a.Entity as VDS).vds_id);
					foreach (object item in Items)
					{
						EntityModel entity = (EntityModel)item;
						if (entity.IsSelected)
						{
							previouslySelectedHostIDs.Add(((VDS)entity.Entity).vds_id);
						}
					}
				}
				Items = items;
				//items.Each(a => Selector.SetIsSelected(a, previouslySelectedHostIDs.Contains((a.Entity as VDS).vds_id)));
				foreach (EntityModel entity in items)
				{
					entity.IsSelected = previouslySelectedHostIDs.Contains(((VDS)entity.Entity).vds_id);
				}
			}
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(SelectedItemChangedEventDefinition) && sender == Cluster)
			{
				Cluster_SelectedItemChanged();
			}
		}

		internal bool Validate()
		{
			Cluster.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			return Cluster.IsValid;
		}
	}
}
