using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using System.Windows.Media;
using org.ovirt.engine.ui.uicommon.dataprovider;
using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.common
{
	public class AboutModel : Model
	{
		#region Properties

		private IList<HostInfo> hosts;
		public IList<HostInfo> Hosts
		{
			get { return hosts; }
			set
			{
				if (hosts != value)
				{
					hosts = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Hosts"));
				}
			}
		}

		private bool showOnlyVersion;
		public bool ShowOnlyVersion
		{
			get { return showOnlyVersion; }
			set
			{
				if (showOnlyVersion != value)
				{
					showOnlyVersion = value;
					ShowOnlyVersionChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("ShowOnlyVersion"));
				}
			}
		}

		private string productVersion;
		public string ProductVersion
		{
			get { return productVersion; }
			set
			{
				if (productVersion != value)
				{
					productVersion = value;
					OnPropertyChanged(new PropertyChangedEventArgs("ProductVersion"));
				}
			}
		}

		#region License information - currently irrelevant

		//public string Enterprise { get; private set; }

		//public string Description { get; private set; }

		//public string CustomerId { get; private set; }


		//public string Limitations { get; private set; }

		//public string TimeLimit { get; private set; }

		//public string CPUSockets { get; private set; }

		#endregion License information - currently irrelevant

		public UICommand CopyToClipboardCommand { get; set; }

		#endregion

		public AboutModel()
		{
			#region License handling - currently irrelevant

			//var licenseProperties = DataProvider.GetLicenseProperties();
			//Enterprise = licenseProperties.ContainsKey("EnterpriseProperty") ? licenseProperties["EnterpriseProperty"] : string.Empty;
			//Description = licenseProperties.ContainsKey("DescriptionProperty") ? licenseProperties["DescriptionProperty"] : string.Empty;
			//CustomerId = licenseProperties.ContainsKey("CustomerIdProperty") ? licenseProperties["CustomerIdProperty"] : string.Empty;

			////Build limitations text.
			//int allowedConcurrentDesktops =
			//    licenseProperties.ContainsKey("MaxConcurrentlyRunningDesktopsProperty") &&
			//    !string.IsNullOrEmpty(licenseProperties["MaxConcurrentlyRunningDesktopsProperty"]) ?
			//            Convert.ToInt32(licenseProperties["MaxConcurrentlyRunningDesktopsProperty"]) :
			//            0;


			//var returnValue = Frontend.RunQuery(VdcQueryType.GetResourceUsage,
			//    new GetResourceUsageParameters("MaxConcurrentlyRunningDesktops"));

			//int currentConcurrentDesktops = (returnValue != null && returnValue.Succeeded)
			//    ? (int)returnValue.ReturnValue
			//    : 0;

			//if (allowedConcurrentDesktops > 0)
			//{
			//    Limitations = String.Format("There are currently {0} running Virtual Machines out of possible {1}.",
			//                                currentConcurrentDesktops,
			//                                allowedConcurrentDesktops
			//        );
			//}


			////Build time limit text.
			//bool isProduct = licenseProperties.ContainsKey("IsProductProperty") && !string.IsNullOrEmpty(licenseProperties["IsProductProperty"])
			//                    ? Convert.ToBoolean(licenseProperties["IsProductProperty"])
			//                    : false;

			//if (licenseProperties.ContainsKey("TimeLimitProperty") && !string.IsNullOrEmpty(licenseProperties["TimeLimitProperty"]))
			//{

			//    DateTime timeLimit = DateTime.Now;
			//    if (licenseProperties["TimeLimitProperty"].Equals("0"))
			//    {
			//        TimeLimit = "Product Support period is unlimited.";
			//    }
			//    else
			//    {
			//        try
			//        {
			//            timeLimit = Convert.ToDateTime(licenseProperties["TimeLimitProperty"]);
			//        }
			//        catch { QLogger.Instance.ErrorFormat("AboutModel(AboutView view): cannot convert {0} cause bugous license expire date recieved", licenseProperties["TimeLimitProperty"]); }
			//        if (isProduct)
			//        {
			//            bool isSupported = licenseProperties.ContainsKey("IsSupportedProperty")
			//                        ? Convert.ToBoolean(licenseProperties["IsSupportedProperty"])
			//                        : false;

			//            TimeLimit = isSupported
			//                ? String.Format("Product Support period will expire at {0}.", timeLimit)
			//                : String.Format("Product Support period has expired at {0}.", timeLimit);
			//        }
			//        else
			//        {
			//            TimeLimit = String.Format("This evaluation version will expire at {0}.", timeLimit);
			//        }
			//    }
			//}

			//if (licenseProperties.ContainsKey("MaxHostSocketsProperty") && !string.IsNullOrEmpty(licenseProperties["MaxHostSocketsProperty"]))
			//{
			//    VdcQueryReturnValue ret = Frontend.RunQuery(VdcQueryType.GetResourceUsage, new GetResourceUsageParameters("MaxHostSockets"));
			//    if (ret != null && ret.Succeeded)
			//    {
			//        if (string.IsNullOrEmpty(licenseProperties["MaxHostSocketsProperty"]) || int.Parse(licenseProperties["MaxHostSocketsProperty"]) == 0)
			//        {
			//            CPUSockets = string.Format("{0}(unlimited)", (int)ret.ReturnValue);
			//        }
			//        else
			//        {
			//            CPUSockets = string.Format("{0}(out of {1} supported by license)", (int)ret.ReturnValue, licenseProperties["MaxHostSocketsProperty"]);
			//        }
			//    }
			//}

			#endregion License handling - currently irrelevant

			CopyToClipboardCommand =
				new UICommand("CopyToClipboard", this)
				{
					Title = "Copy to Clipboard",
					IsAvailable =true
				};
			this.Commands.Add(CopyToClipboardCommand); 

			ShowOnlyVersion = true;
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
			                            	{
			                            		AboutModel aboutModel = (AboutModel) model;
												aboutModel.ProductVersion = (string)result;
			};//END_DELEGATE
			AsyncDataProvider.GetRpmVersionViaPublic(_asyncQuery);
		}

		private void ShowOnlyVersionChanged()
		{
			if (!ShowOnlyVersion)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
												{
													AboutModel aboutModel = (AboutModel)model;
													List<HostInfo> list = new List<HostInfo>();
													foreach (VDS a in (IList<VDS>)result)
													{
														HostInfo hi =
															new HostInfo
															{
																HostName = a.vds_name + ":"
															};
														if (!String.IsNullOrEmpty(a.host_os))
														{
															hi.OSVersion = "OS Version - " + a.host_os;
														}

														if (a.Version.FullVersion != null)
														{
															hi.VDSMVersion = "VDSM Version - " + Extensions.GetFriendlyVersion(a.Version.FullVersion) + " " + a.Version.BuildName;
														}

														list.Add(hi);
													}
													aboutModel.Hosts = list;
												};//END_DELEGATE
				AsyncDataProvider.GetHostList(_asyncQuery);
			}
		}

		public void CopyToClipboard()
		{
			string data = BuildClipboardData();
			CopyToClipboard(data);
		}

		private string BuildClipboardData()
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendLine(RpmVersion);
			if (ShowOnlyVersion == false)
			{
				sb.AppendLine();
				sb.AppendLine("Red Hat Enterprise Virtualization Hypervisor Hosts:");

                if (Hosts != null && Hosts.Count > 0)
                {
                    foreach (HostInfo item in Hosts)
                    {
                        sb.AppendFormat("\t{0}\t{1}\t{2}", item.HostName, item.OSVersion, item.VDSMVersion);
                        sb.AppendLine();
                    }
                }
                else
                {
                    sb.AppendLine("[No Hosts]");
                }

				#region License handling - currently irrelevant

				//sb.AppendLine();
				//sb.AppendLine("License Information:");
				//sb.Append("\tEnterprise:\t").AppendLine(Enterprise);
				//sb.Append("\tDescription:\t").AppendLine(Description);
				//sb.Append("\tLicense ID:\t").AppendLine(CustomerId);
				//sb.Append("\tUsed CPU Sockets:\t").AppendLine(CPUSockets);
				//if (Limitations != null)
				//{
				//    sb.Append("\tLimitations:\t").AppendLine(Limitations);
				//}
				//sb.AppendLine();
				//sb.AppendLine(TimeLimit);

				#endregion License handling - currently irrelevant
			}
			return sb.ToString();
		}

		protected virtual void CopyToClipboard(string data)
		{
			Clipboard.SetDataObject(data);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == CopyToClipboardCommand)
			{
				CopyToClipboard();
			}
		}

		private string RpmVersion
		{
			get { return "RHEV Manager for Servers and Desktops: " + ProductVersion; }
		}
	}
}
