'''
Created on May 10, 2010

@author: mpastern@redhat.com
'''
import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions

class HelpConstructor(object):
    '''
    HelpConstructor representing help content based on WebService.
    '''
    __brokersContainer = None
    __useCLIOutputManner = False
    def __init__(self, brokersContainer, useCLIOutputManner=False):
        '''
        @var brokersContainer: WEB based EntityDrivenBrokersContainer
        @type brokersContainer: EntityDrivenBrokersContainer
        @var useCLIOutputManner: show: func -arg1 -arg2 ... rather then: func(arg1,arg2,...) 
        @type useCLIOutputManner: bool
        '''
        self.__brokersContainer = brokersContainer
        self.__useCLIOutputManner = useCLIOutputManner

    def __showBrokers(self, name='*'):
        bc = self.__brokersContainer
        if(bc != None and (not len(bc.brokers()) == 0)and name == '*'):
            bc.show('Broker', self.__useCLIOutputManner)
        else:
            broker = bc.getBrokerByName(name)
            if(broker != None):broker.show(cliManner=self.__useCLIOutputManner)
            else: raise Exceptions.TypeNotFound(name)  

    def showUsage(self, all=True, params={}):
        if(all):
            print "Usage:  rhevmClient [OPTIONS] <command> [Command parameters]"
            print "\nOptions:"
#TODO: Implement 'rhevmClient Options' support.        
            print "-h or --help\tDisplay this help"
            print "-e\t        Display help by entity (e.g Action,Bookmark,Cluster etc.)"
            print "\nCommands:"
        if(params != None and params.__len__() == 1):
            if(params.keys()[0] == 'e'):
                self.__showBrokers(name=params.values()[0])
            else: raise Exceptions.UnsupportedArgument(params.keys()[0])  
        else:
            self.__showBrokers()
        
