PRINT 'Processing vds_spm_id_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[vds_spm_id_map] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertvds_spm_id_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertvds_spm_id_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertvds_spm_id_map]
    @storage_pool_id uniqueidentifier,  
 @vds_id uniqueidentifier,  
 @vds_spm_id int  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vds_spm_id_map] ([storage_pool_id], [vds_id], [vds_spm_id])
	VALUES (@storage_pool_id, @vds_id, @vds_spm_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletevds_spm_id_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletevds_spm_id_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletevds_spm_id_map]
 @vds_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[vds_spm_id_map]
	WHERE [vds_id]=@vds_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromvds_spm_id_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromvds_spm_id_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromvds_spm_id_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_spm_id_map].[storage_pool_id] AS 'storage_pool_id',
	[vds_spm_id_map].[vds_id] AS 'vds_id',
	[vds_spm_id_map].[vds_spm_id] AS 'vds_spm_id'
FROM [dbo].[vds_spm_id_map] [vds_spm_id_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvds_spm_id_mapBystorage_pool_idAndByvds_spm_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvds_spm_id_mapBystorage_pool_idAndByvds_spm_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvds_spm_id_mapBystorage_pool_idAndByvds_spm_id] 
 @storage_pool_id uniqueidentifier,  
 @vds_spm_id int  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_spm_id_map].[storage_pool_id] AS 'storage_pool_id',
	[vds_spm_id_map].[vds_id] AS 'vds_id',
	[vds_spm_id_map].[vds_spm_id] AS 'vds_spm_id'
	FROM [dbo].[vds_spm_id_map] [vds_spm_id_map]
	WHERE [storage_pool_id]=@storage_pool_id AND [vds_spm_id]=@vds_spm_id

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvds_spm_id_mapBystorage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvds_spm_id_mapBystorage_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvds_spm_id_mapBystorage_pool_id] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_spm_id_map].[storage_pool_id] AS 'storage_pool_id',
	[vds_spm_id_map].[vds_id] AS 'vds_id',
	[vds_spm_id_map].[vds_spm_id] AS 'vds_spm_id'
	FROM [dbo].[vds_spm_id_map] [vds_spm_id_map]
	WHERE [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvds_spm_id_mapByvds_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvds_spm_id_mapByvds_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvds_spm_id_mapByvds_id]
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_spm_id_map].[storage_pool_id] AS 'storage_pool_id',
	[vds_spm_id_map].[vds_id] AS 'vds_id',
	[vds_spm_id_map].[vds_spm_id] AS 'vds_spm_id'
	FROM [dbo].[vds_spm_id_map] [vds_spm_id_map]
	WHERE [vds_id]=@vds_id

	SET NOCOUNT OFF
END

GO