SET NOCOUNT ON
-- Restricts volume of output to errors and
-- messages that use the PRINT function

declare @id_0000 uniqueidentifier
declare @storage_pool_id uniqueidentifier
declare @cluster_id uniqueidentifier
declare @id_0009 uniqueidentifier
set @id_0000 = '00000000-0000-0000-0000-000000000000'
set @storage_pool_id = newid()
set @cluster_id = '99408929-82CF-4DC7-A532-9D998063FA95'
set @id_0009 = '00000000-0000-0000-0000-000000000009'



if (not exists (select TOP 1 id from storage_pool))
begin
	PRINT 'INSERTING DATA INTO TABLE storage_pool'
	INSERT INTO [storage_pool] ([id],[name],[description],[storage_pool_type],[status],[master_domain_version],[compatibility_version]) VALUES (@storage_pool_id,'Default','The default Data Center',1,0,0,'2.2')
end

if (not exists (select TOP 1 vds_group_id from vds_groups ))
begin
	PRINT 'INSERTING DATA INTO TABLE vds_groups'
	INSERT INTO [vds_groups] ([vds_group_id],[name],[description],[storage_pool_id],[compatibility_version]) VALUES (@cluster_id,'Default','The default server cluster',@storage_pool_id,'2.2')
end

if (not exists (select TOP 1 id from network))
begin
	PRINT 'INSERTING DEFAULT NETWORKS'
	insert into network ( [id] , [name], [description], [storage_pool_id]) values (@id_0009, 'rhevm', 'Management Network', @storage_pool_id)
	if (not exists (select TOP 1 network_id from network_cluster))
	begin
		insert into network_cluster (network_id, cluster_id, status) values (@id_0009 , @cluster_id, 1) 
	end
end

if (not exists (select it_guid from image_templates where it_guid = @id_0000))
begin
	PRINT 'INSERTING BLANK TEMPLATE TO ALL RELEVANT TABLES'
	-- size 85899345920 is 80GB
	INSERT INTO [image_templates] ([it_guid],[os],[os_version],[creation_date],[size],[description],[bootable]) VALUES (@id_0000,'-','-','2008/04/01 00:00:00',85899345920,'Blanc Image Template',0)
	INSERT INTO [vm_templates] ([vmt_guid],[name],[mem_size_mb],[os],[creation_date],[child_count],[num_of_sockets],[cpu_per_socket],[description],[vds_group_id],[domain],[num_of_monitors],[status]) VALUES (@id_0000,'Blank' ,512,'','2008/04/01 00:00:00',0,1,1,'Blank template',@cluster_id,'',1,0)
	INSERT INTO [vm_template_image_map] ([it_guid],[vmt_guid],[internal_drive_mapping]) VALUES (@id_0000,@id_0000,'1')
end

if (not exists (select 1 from [dbo].[dwh_history_timekeeping] WHERE var_name = 'lastSync'))
begin
	PRINT 'INSERTING HISTORY TIMEKEEPING DATA'
	Insert into [dbo].[dwh_history_timekeeping] VALUES('lastSync',NULL,cast('01/01/2000 12:00:00 PM' as datetime))
end
GO

-- EVENT NOTIFICATION ----

-- backup values (will be deleted by the forign key of [event_map],[event_notification_methods]
select * into event_subscriber_backup from event_subscriber 

PRINT 'INSERTING DATA FOR NOTIFICATION METHODS'
delete from [event_notification_methods]
go

insert into [event_notification_methods] (method_id,method_type) values(0, 'Email')
go

PRINT 'INSERTING DATA FOR EVENT NOTIFICATION MAP'
delete from [event_map] 
go

insert into [event_map] (event_up_name, event_down_name) values('VDC_STOP', 'VDC_START')

insert into [event_map] (event_up_name, event_down_name) values('IRS_FAILURE', 'UNASSIGNED')
insert into [event_map] (event_up_name, event_down_name) values('IRS_DISK_SPACE_LOW', 'UNASSIGNED')
insert into [event_map] (event_up_name, event_down_name) values('IRS_DISK_SPACE_LOW_ERROR', 'UNASSIGNED')

insert into [event_map] (event_up_name, event_down_name) values('VDS_FAILURE', 'VDS_ACTIVATE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_MAINTENANCE', 'VDS_ACTIVATE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_MAINTENANCE_FAILED', 'VDS_MAINTENANCE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_ACTIVATE_FAILED', 'VDS_ACTIVATE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_RECOVER_FAILED', 'VDS_RECOVER')
insert into [event_map] (event_up_name, event_down_name) values('VDS_SLOW_STORAGE_RESPONSE_TIME', 'VDS_ACTIVATE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_APPROVE_FAILED', 'VDS_APPROVE')
insert into [event_map] (event_up_name, event_down_name) values('VDS_INSTALL_FAILED', 'VDS_INSTALL')

insert into [event_map] (event_up_name, event_down_name) values('VM_FAILURE', 'UNASSIGNED')
insert into [event_map] (event_up_name, event_down_name) values('VM_MIGRATION_START', 'VM_MIGRATION_DONE')
insert into [event_map] (event_up_name, event_down_name) values('VM_MIGRATION_FAILED', 'UNASSIGNED')
insert into [event_map] (event_up_name, event_down_name) values('VM_MIGRATION_FAILED_FROM_TO', 'UNASSIGNED')
insert into [event_map] (event_up_name, event_down_name) values('VM_NOT_RESPONDING', 'UNASSIGNED')

go

-- restore subscriptions
if exists (select name from sys.objects where name = 'event_subscriber_backup' and type = 'U')
begin
	insert event_subscriber (subscriber_id,event_up_name,method_id,method_address,tag_name)
	(select subscriber_id,event_up_name,method_id,method_address,tag_name from event_subscriber_backup)
	drop table event_subscriber_backup
end
go


PRINT 'INSERTING DATA FOR [action_version_map]'
delete from [action_version_map] 
go

-- AddVmFromTemplate
insert into [action_version_map] values(2, '2.2', '2.2')
-- MoveVm
insert into [action_version_map] values(33, '2.2', '2.2')
-- ImportVm
insert into [action_version_map] values(36, '2.2', '2.2')
-- ExportVm
insert into [action_version_map] values(23, '2.2', '2.2')
-- ImportVmTemplate
insert into [action_version_map] values(39, '2.2', '2.2')
-- ExportVmTemplate
insert into [action_version_map] values(24, '2.2', '2.2')
-- AddExistingNFSStorageDomain
insert into [action_version_map] values(960, '2.2', '2.2')
-- AddExistingSANStorageDomainCommand
insert into [action_version_map] values(961, '2.2', '2.2')
-- RecoveryStoragePool
insert into [action_version_map] values(915, '2.2', '2.2')
go
