print 'USE ' + DB_NAME() 
print 'go'

set nocount on
/***************************************************************
							DROP
***************************************************************/

-- Generate Drops for All Foreign Keys in Database
print 'print ''Dropping Foreign Keys...'''

declare @statement nvarchar(max)
DECLARE pkDropCursor CURSOR FOR
select distinct 'IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA=''dbo'' ' +
     'AND CONSTRAINT_NAME=''' +  object_name(constid) + ''' AND TABLE_NAME=''' + object_name(fkeyid) + ''')' + CHAR(13) + CHAR(10) + 
	 'BEGIN' +  CHAR(13) + CHAR(10) +     
	 'ALTER TABLE [dbo].[' + object_name(fkeyid) +
	'] DROP CONSTRAINT ' + object_name(constid) +  CHAR(13) + CHAR(10) + 'END'
     from sysforeignkeys 
OPEN pkDropCursor

FETCH NEXT FROM pkDropCursor 
	INTO @statement

WHILE @@FETCH_STATUS = 0
BEGIN
	print @statement
	print 'go'
	FETCH NEXT FROM pkDropCursor 
	INTO @statement
END
CLOSE pkDropCursor
DEALLOCATE pkDropCursor
go

-- Generate Drops for All Primary Keys in Database
print 'print ''Dropping Primary Keys...'''

declare @statement nvarchar(max)
DECLARE fkDropCursor CURSOR FOR
select distinct 'IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA=''dbo'' ' +
    'AND CONSTRAINT_NAME=''' +  constraint_name + ''' AND TABLE_NAME=''' + table_name + ''')' + CHAR(13) + CHAR(10) + 
	'BEGIN' +  CHAR(13) + CHAR(10) +     
	'ALTER TABLE [dbo].[' + table_name +
	'] DROP CONSTRAINT ' + constraint_name +  CHAR(13) + CHAR(10) + 'END'
	from information_schema.KEY_COLUMN_USAGE
	where information_schema.KEY_COLUMN_USAGE.constraint_name in 
	(select name from sys.key_constraints)
OPEN fkDropCursor

FETCH NEXT FROM fkDropCursor 
	INTO @statement

WHILE @@FETCH_STATUS = 0
BEGIN
	print @statement
	print 'go'
	FETCH NEXT FROM fkDropCursor 
	INTO @statement
END
CLOSE fkDropCursor
DEALLOCATE fkDropCursor
go

-- Generate Drops fornon clustered indexes in Database
print 'print ''Dropping Indexes...'''

declare @statement nvarchar(max)
declare @table varchar(128)
declare @index varchar(128)
DECLARE idxDropCursor CURSOR FOR
	select object_name(object_id) as [table], [name] from sys.indexes where type_desc= 'NONCLUSTERED'
	and object_id in (select object_id from sys.objects where type = 'U')

OPEN idxDropCursor

FETCH NEXT FROM idxDropCursor INTO @table, @index

WHILE @@FETCH_STATUS = 0
BEGIN
	set @statement = 'IF INDEXPROPERTY ( OBJECT_ID(''' + @table + ''') , ''' + @index + ''' , ''IndexID'' ) IS NOT NULL' + CHAR(13) + CHAR(10) +
    'BEGIN' + CHAR(13) + CHAR(10) +
    'DROP INDEX ' +  @index + ' ON ' + @table + CHAR(13) + CHAR(10) + 'END' + CHAR(13) + CHAR(10) + 'go'
	print @statement
	FETCH NEXT FROM idxDropCursor INTO @table, @index
END
CLOSE idxDropCursor
DEALLOCATE idxDropCursor
go

/***************************************************************
							Custome
***************************************************************/

print '/***************************************************************'
print '                       Custome Section                          '
print '***************************************************************/'

print '/***************************************************************'
print '                       End of Custome Section                   '
print '***************************************************************/'

/***************************************************************
							CREATE
***************************************************************/
-- Generate Adds for All Primary Keys in Database
print 'print ''Recreating Primary Keys...'''

declare @constName varchar(800),@tabName varchar(800), @colName varchar(800), @ordinal int
declare @sep char(1) 
declare @statement nvarchar(max) 
declare @columns nvarchar(max)
declare @lastTab nvarchar(255)

set @sep = ' '

DECLARE pkCreateCursor CURSOR FOR
	select distinct constraint_name,table_name,column_name,ordinal_position
	from information_schema.KEY_COLUMN_USAGE
	where information_schema.KEY_COLUMN_USAGE.constraint_name in 
	(select name from sys.key_constraints)
	order by table_name, column_name,ordinal_position
OPEN pkCreateCursor

FETCH NEXT FROM pkCreateCursor 
	INTO @constName, @tabName, @colName,@ordinal

WHILE @@FETCH_STATUS = 0
BEGIN
    set @lastTab = @tabName
    if @columns is null
		set @columns =  @colName
	else
		set @columns =  @columns + @sep + @colName
	set @statement = 'IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA=''dbo'' ' +
					  'AND CONSTRAINT_NAME=''' +  @constName + ''' AND TABLE_NAME=''' + @tabName	 + ''')' + CHAR(13) + CHAR(10) + 
                      'BEGIN' +  CHAR(13) + CHAR(10) +     
					 'ALTER TABLE ' + @tabName + ' ADD CONSTRAINT ' + @constName +' PRIMARY KEY(' 
	FETCH NEXT FROM pkCreateCursor 
		INTO @constName, @tabName, @colName,@ordinal
	if (@tabName = @lastTab) 
	begin
		set @sep = ','		
	end
	else 
	begin
		set @statement = @statement + @columns + ')'  +  CHAR(13) + CHAR(10) + 'END'
		print @statement
        print 'go'
		set @sep = ' '
		set @columns = ''
        set @lastTab = @tabName
	end
END
set @statement = @statement + @columns + ')'  +  CHAR(13) + CHAR(10) + 'END'
print @statement
print 'go'

CLOSE pkCreateCursor
DEALLOCATE pkCreateCursor
go

-- Generate Adds for All Foreign Keys in Database
print 'print ''Recreating Foreign Keys...'''

DECLARE @fkName varchar(800), @tabName varchar(800), @refName varchar(800)
DECLARE @isDel int, @isUpd int, @fkCol varchar(8000), @refCol varchar(8000)
DECLARE @pline varchar(8000)

DECLARE fkCreateCursor CURSOR FOR
	select distinct object_name(constid), object_name(fkeyid), 
		object_name(rkeyid), 
		OBJECTPROPERTY ( constid , 'CnstIsDeleteCascade' ),
		OBJECTPROPERTY ( constid , 'CnstIsUpdateCascade' )
	from sysforeignkeys k 
	order by object_name(fkeyid)

OPEN fkCreateCursor

FETCH NEXT FROM fkCreateCursor 
	INTO @fkName, @tabName, @refName, @isDel, @isUpd

WHILE @@FETCH_STATUS = 0
BEGIN
	select @fkCol = NULL
	SELECT @fkCol = ISNULL(@fkCol + ', ','') + '[' + col_name(fkeyid, fkey) + ']'
	from sysforeignkeys 
	where object_name(constid) = @fkName 
	order by keyno

	select @refCol = NULL
	SELECT @refCol = ISNULL(@refCol + ', ','') + '[' + col_name(rkeyid, rkey) + ']'
	from sysforeignkeys 
	where object_name(constid) = @fkName 
	order by keyno

	select @pline = 'IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA=''dbo'' ' +
	'AND CONSTRAINT_NAME=''' + @fkName + ''' AND TABLE_NAME=''' + @tabName + ''')' + CHAR(13) + CHAR(10) +  
	'BEGIN' +  CHAR(13) + CHAR(10) +     
	'ALTER TABLE [dbo].[' + @tabName +
	'] ADD CONSTRAINT [' + @fkName + ']' +
	CHAR(13) + CHAR(10) + 
	'   FOREIGN KEY (' + @fkCol + ') REFERENCES [dbo].[' + @refName +
	'] (' + @refCol + ')'
	if @isDel = 1 
		select @pline = @pline + CHAR(13) + CHAR(10) + 
			'     ON DELETE CASCADE'
	if @isUpd = 1 
		select @pline = @pline + CHAR(13) + CHAR(10) + 
			'     ON UPDATE CASCADE'
	select @pline = @pline 
	print @pline + CHAR(13) + CHAR(10) + 'END'
    print 'go'
	FETCH NEXT FROM fkCreateCursor 
		INTO @fkName, @tabName, @refName, @isDel, @isUpd
END

CLOSE fkCreateCursor
DEALLOCATE fkCreateCursor
GO

-- Generate Adds for All non cluster indexes in Database
print 'print ''Recreating Indexes...'''

SELECT TOP 100
REPLICATE(' ',4000) AS COLNAMES ,
OBJECT_NAME(I.object_id) AS TABLENAME,
I.object_id AS TABLEID,
I.index_id AS INDEXID,
I.NAME AS INDEXNAME,
-- I.STATUS,
INDEXPROPERTY (I.object_id,I.NAME,'ISUNIQUE') AS ISUNIQUE,
INDEXPROPERTY (I.object_id,I.NAME,'ISCLUSTERED') AS ISCLUSTERED,
INDEXPROPERTY (I.object_id,I.NAME,'INDEXFILLFACTOR') AS INDEXFILLFACTOR
INTO #TMP
FROM SYS.INDEXES I
WHERE I.index_id > 1
AND I.index_id < 255
AND I.is_hypothetical=0
AND I.object_id in (select object_id from sys.objects where type = 'U')

--uncomment below to eliminate PK or UNIQUE indexes;
--what i call 'normal' indexes
--AND INDEXPROPERTY (I.object_id,I.NAME,'ISUNIQUE') =0
--AND INDEXPROPERTY (I.object_id,I.NAME,'ISCLUSTERED') =0

DECLARE
@ISQL nvarchar(max),
@TABLEID INT,
@INDEXID INT,
@MAXTABLELENGTH INT,
@MAXINDEXLENGTH INT
--USED FOR FORMATTING ONLY
SELECT @MAXTABLELENGTH=MAX(LEN(TABLENAME)) FROM #TMP
SELECT @MAXINDEXLENGTH=MAX(LEN(INDEXNAME)) FROM #TMP

DECLARE C1 CURSOR FOR
SELECT TABLEID,INDEXID FROM #TMP
OPEN C1
FETCH NEXT FROM C1 INTO @TABLEID,@INDEXID
WHILE @@FETCH_STATUS = 0
BEGIN
SET @ISQL = ''
SELECT @ISQL=@ISQL + ISNULL(SYS.COLUMNS.NAME,'') + ',' FROM SYS.INDEXES I
INNER JOIN SYS.INDEX_COLUMNS ON I.object_id=SYS.INDEX_COLUMNS.object_id AND I.index_id=SYS.INDEX_COLUMNS.index_id
INNER JOIN SYS.COLUMNS ON SYS.INDEX_COLUMNS.object_id=SYS.COLUMNS.object_id AND SYS.INDEX_COLUMNS.column_id=SYS.COLUMNS.column_id
WHERE I.index_id > 1
AND I.index_id < 255
AND I.is_hypothetical=0
AND I.object_id=@TABLEID AND I.index_id=@INDEXID
AND I.object_id in (select object_id from sys.objects where type = 'U')
ORDER BY SYS.COLUMNS.column_id
UPDATE #TMP SET COLNAMES=@ISQL WHERE TABLEID=@TABLEID AND INDEXID=@INDEXID

FETCH NEXT FROM C1 INTO @TABLEID,@INDEXID
END
CLOSE C1
DEALLOCATE C1
--AT THIS POINT, THE 'COLNAMES' COLUMN HAS A TRAILING COMMA
UPDATE #TMP SET COLNAMES=LEFT(COLNAMES,LEN(COLNAMES) -1)

declare @statement nvarchar(max)
DECLARE idxCreateCursor CURSOR FOR
SELECT  'IF INDEXPROPERTY ( OBJECT_ID(''' + TABLENAME +''') , ''' + INDEXNAME + ''' , ''IndexID'' ) IS NULL' + CHAR(13) + CHAR(10) + 
'BEGIN' + CHAR(13) + CHAR(10) + 
'CREATE ' +
 CASE WHEN ISUNIQUE = 1 THEN ' UNIQUE ' ELSE ' ' END +
 CASE WHEN ISCLUSTERED = 1 THEN ' CLUSTERED ' ELSE ' ' END +
 ' INDEX [' + UPPER(INDEXNAME) + ']' +
 SPACE(@MAXINDEXLENGTH - LEN(INDEXNAME)) +
' ON [' + UPPER(TABLENAME) + '] ' +
 SPACE(@MAXTABLELENGTH - LEN(TABLENAME)) +
 '(' + UPPER(COLNAMES) + ')' +
 CASE WHEN INDEXFILLFACTOR = 0 THEN '' ELSE ' WITH FILLFACTOR = ' + CONVERT(VARCHAR(10),INDEXFILLFACTOR) END +
 CHAR(13) + CHAR(10) + 'END' + CHAR(13) + CHAR(10) + 'go'


FROM #TMP
OPEN idxCreateCursor
FETCH NEXT FROM idxCreateCursor INTO @statement
WHILE @@FETCH_STATUS = 0
BEGIN
	print @statement
	FETCH NEXT FROM idxCreateCursor INTO @statement

END
CLOSE idxCreateCursor
DEALLOCATE idxCreateCursor
DROP TABLE #TMP
